/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.MergeArgs;
import com.bean.MHapInfo;
import com.common.Util;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merge {
    public static final Logger log = LoggerFactory.getLogger(Merge.class);
    MergeArgs args = new MergeArgs();
    Util util = new Util();

    public void merge(MergeArgs mergeArgs) throws Exception {
        String[] fileList;
        log.info("command.Merge start!");
        this.args = mergeArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        String mhapFileName = "";
        mhapFileName = this.args.getOutPutFile() == null || this.args.getOutPutFile().equals("") ? "out.mhap" : this.args.getOutPutFile().substring(0, this.args.getOutPutFile().length() - 3);
        BufferedWriter outputWriter = this.util.createOutputFile("", mhapFileName);
        ArrayList<BufferedReader> readerList = new ArrayList<BufferedReader>();
        ArrayList<MHapInfo> newLineList = new ArrayList<MHapInfo>();
        for (String fileName : fileList = this.args.getInputFile().trim().split(" ")) {
            FileInputStream fileInputStream = new FileInputStream(fileName);
            GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(gzipInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String mHapLine = bufferedReader.readLine();
            MHapInfo mHapInfo = new MHapInfo(mHapLine.split("\t")[0], Integer.valueOf(mHapLine.split("\t")[1]), Integer.valueOf(mHapLine.split("\t")[2]), mHapLine.split("\t")[3], Integer.valueOf(mHapLine.split("\t")[4]), mHapLine.split("\t")[5]);
            newLineList.add(mHapInfo);
            readerList.add(bufferedReader);
        }
        long lineCnt = 0L;
        String thisChrom = ((MHapInfo)newLineList.get(0)).getChrom();
        String nextChrom = ((MHapInfo)newLineList.get(0)).getChrom();
        while (readerList.size() > 0) {
            int i;
            if (++lineCnt % 1000000L == 0L) {
                log.info("Merge complete " + lineCnt + " lines. Now in " + thisChrom);
            }
            ArrayList<MHapInfo> newLineListFiltered = new ArrayList<MHapInfo>();
            for (MHapInfo mHapInfo : newLineList) {
                if (!mHapInfo.getChrom().equals(thisChrom)) continue;
                newLineListFiltered.add(mHapInfo);
            }
            int minIndex = 0;
            for (int i2 = 0; i2 < newLineListFiltered.size(); ++i2) {
                if (((MHapInfo)newLineListFiltered.get(minIndex)).compareTo((MHapInfo)newLineListFiltered.get(i2)) <= 0) continue;
                minIndex = i2;
            }
            Integer minLineCnt = ((MHapInfo)newLineListFiltered.get(minIndex)).getCnt();
            MHapInfo writeLine = (MHapInfo)newLineListFiltered.get(minIndex);
            ArrayList<Integer> moveIndexs = new ArrayList<Integer>();
            for (i = 0; i < newLineListFiltered.size(); ++i) {
                MHapInfo mHapInfo = (MHapInfo)newLineListFiltered.get(i);
                if (mHapInfo == null || ((MHapInfo)newLineListFiltered.get(minIndex)).compareTo(mHapInfo) != 0) continue;
                writeLine.setCnt(writeLine.getCnt() + ((MHapInfo)newLineListFiltered.get(i)).getCnt());
                moveIndexs.add(newLineList.indexOf(mHapInfo));
            }
            writeLine.setCnt(writeLine.getCnt() - minLineCnt);
            for (i = 0; i < moveIndexs.size(); ++i) {
                String newLine = ((BufferedReader)readerList.get((Integer)moveIndexs.get(i))).readLine();
                if (newLine == null || newLine.equals("")) {
                    ((BufferedReader)readerList.get((Integer)moveIndexs.get(i))).close();
                    readerList.remove((Integer)moveIndexs.get(i));
                    newLineList.remove((Integer)moveIndexs.get(i));
                    moveIndexs.remove(i);
                    for (int j = i; j < moveIndexs.size(); ++j) {
                        moveIndexs.set(j, (Integer)moveIndexs.get(j) - 1);
                    }
                    --i;
                    continue;
                }
                MHapInfo mHapInfo = new MHapInfo(newLine.split("\t")[0], Integer.valueOf(newLine.split("\t")[1]), Integer.valueOf(newLine.split("\t")[2]), newLine.split("\t")[3], Integer.valueOf(newLine.split("\t")[4]), newLine.split("\t")[5]);
                if (!mHapInfo.getChrom().equals(thisChrom)) {
                    nextChrom = mHapInfo.getChrom();
                }
                newLineList.set((Integer)moveIndexs.get(i), mHapInfo);
            }
            boolean changeChrFlag = true;
            for (MHapInfo mHapInfo : newLineList) {
                if (mHapInfo.getChrom().equals(nextChrom)) continue;
                changeChrFlag = false;
            }
            if (changeChrFlag) {
                thisChrom = nextChrom;
            }
            outputWriter.write(writeLine.print() + "\n");
        }
        log.info("Merge succeed! Total " + lineCnt + " lines");
        outputWriter.close();
        String gzFileName = mhapFileName + ".gz";
        FileInputStream inputStream = new FileInputStream(mhapFileName);
        BlockCompressedOutputStream outputStream = new BlockCompressedOutputStream(new File(gzFileName));
        byte[] b = new byte[1024];
        int len = ((InputStream)inputStream).read(b);
        while (len > 0) {
            ((OutputStream)outputStream).write(b, 0, len);
            len = ((InputStream)inputStream).read(b);
        }
        ((InputStream)inputStream).close();
        ((OutputStream)outputStream).close();
        new File(mhapFileName).delete();
        log.info("command.Merge end! ");
    }

    private boolean checkArgs() {
        if (this.args.getInputFile().equals("")) {
            log.error("The input file cannot be empty.");
            return false;
        }
        return true;
    }
}

