/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.MHapViewArgs;
import com.bean.BedInfo;
import com.bean.MHapInfo;
import com.bean.R2Info;
import com.bean.Region;
import com.common.Util;
import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.rewrite.CustomXYBlockRenderer;
import com.rewrite.CustomXYBlockRenderer2;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MHapView {
    public static final Logger log = LoggerFactory.getLogger(MHapView.class);
    Util util = new Util();
    MHapViewArgs args = new MHapViewArgs();
    Region region = new Region();
    Integer width = 0;

    public void mHapView(MHapViewArgs r2Args) throws Exception {
        List<Integer> cpgPosList;
        log.info("MHapView start!");
        this.args = r2Args;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        this.region = this.util.parseRegion(this.args.getRegion());
        List<MHapInfo> mHapList = this.util.parseMhapFile(this.args.getMhapPath(), this.region, this.args.getStrand(), false);
        boolean getMhapViewResult = this.getMhapView(mHapList, cpgPosList = this.util.parseCpgFileWithShift(this.args.getCpgPath(), this.region, 500));
        if (!getMhapViewResult) {
            log.error("getMhapView fail, please check the command.");
            return;
        }
        log.info("MHapView end!");
    }

    private boolean checkArgs() {
        if (this.args.getMhapPath().equals("")) {
            log.error("mhapPath can not be null.");
            return false;
        }
        if (this.args.getCpgPath().equals("")) {
            log.error("cpgPath can not be null.");
            return false;
        }
        if (this.args.getRegion().equals("")) {
            log.error("region can not be null.");
            return false;
        }
        if (this.args.getTag().equals("")) {
            log.error("tag can not be null.");
            return false;
        }
        if (!this.args.getOutFormat().equals("png") && !this.args.getOutFormat().equals("pdf")) {
            log.error("The output format must be pdf or png");
            return false;
        }
        if (!(this.args.getStrand().equals("plus") || this.args.getStrand().equals("minus") || this.args.getStrand().equals("both"))) {
            log.error("The strand must be one of plus, minus or both");
            return false;
        }
        return true;
    }

    private boolean getMhapView(List<MHapInfo> mHapList, List<Integer> cpgPosList) throws Exception {
        List<Integer> cpgPosListInRegion = this.util.getCpgPosListInRegion(cpgPosList, this.region);
        Integer[][] cpgHpMatInRegion = this.util.getCpgHpMat(mHapList, cpgPosList, cpgPosListInRegion);
        this.width = cpgHpMatInRegion[0].length * 200;
        CategoryPlot cellCntPlot = this.createReadCntPlot(mHapList, cpgPosListInRegion);
        CategoryPlot mmPlot = this.createMMPlot(cpgPosListInRegion, cpgHpMatInRegion);
        XYPlot whiteBlackPlot = this.createWhiteBlackPlot(cpgHpMatInRegion);
        XYPlot bedRegionPlot = new XYPlot();
        if (this.args.getBedPath() != null && !this.args.getBedPath().equals("")) {
            bedRegionPlot = this.createBedRegionPlot(cpgPosListInRegion);
        }
        XYPlot MHapViewHeatMapPlot = this.createHeatMapPlot(cpgHpMatInRegion, cpgPosListInRegion);
        ArrayList<Plot> plotList = new ArrayList<Plot>();
        ArrayList<Integer> heightList = new ArrayList<Integer>();
        plotList.add(cellCntPlot);
        heightList.add(this.width * 20 / 100);
        plotList.add(mmPlot);
        heightList.add(this.width * 15 / 100);
        plotList.add(whiteBlackPlot);
        heightList.add(this.width * 45 / 100);
        if (this.args.getBedPath() != null && !this.args.getBedPath().equals("")) {
            plotList.add(bedRegionPlot);
            heightList.add(this.width * 10 / 100);
        }
        plotList.add(MHapViewHeatMapPlot);
        heightList.add(this.width * 35 / 100);
        String outputPath = this.args.getTag() + "_" + this.region.toFileString() + ".mHapView." + this.args.getOutFormat();
        if (this.args.getOutFormat().equals("pdf")) {
            this.saveAsPdf(plotList, outputPath, this.width, heightList, cpgPosListInRegion);
        } else if (this.args.getOutFormat().equals("png")) {
            this.saveAsPng(plotList, outputPath, this.width, heightList, cpgPosListInRegion);
        }
        return true;
    }

    private CategoryPlot createReadCntPlot(List<MHapInfo> mHapList, List<Integer> cpgPosListInRegion) {
        ArrayList<Integer> readCntList = new ArrayList<Integer>();
        for (int i = 0; i < cpgPosListInRegion.size(); ++i) {
            Integer readCnt = 0;
            for (int j = 0; j < mHapList.size(); ++j) {
                MHapInfo mHapInfo = mHapList.get(j);
                if (mHapInfo.getStart() > cpgPosListInRegion.get(i) || cpgPosListInRegion.get(i) > mHapInfo.getEnd()) continue;
                readCnt = readCnt + 1;
            }
            readCntList.add(readCnt);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Integer maxCellCnt = 0;
        for (int i = 0; i < readCntList.size(); ++i) {
            dataset.addValue((Number)readCntList.get(i), (Comparable)cpgPosListInRegion.get(i), (Comparable)((Object)""));
            maxCellCnt = (Integer)readCntList.get(i) > maxCellCnt ? (Integer)readCntList.get(i) : maxCellCnt;
        }
        CategoryAxis categoryAxis = new CategoryAxis();
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setRange(new Range(1.0, (double)maxCellCnt.intValue() * 1.1));
        valueAxis.setVisible(true);
        valueAxis.setTickUnit(new NumberTickUnit(maxCellCnt / 2));
        valueAxis.setTickLabelFont(new Font("", 0, this.width / 75));
        valueAxis.setLabel("read count");
        valueAxis.setLabelFont(new Font("", 0, this.width / 60));
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBarPainter(new StandardBarPainter());
        barRenderer.setShadowVisible(false);
        barRenderer.setDrawBarOutline(false);
        barRenderer.setMaximumBarWidth(0.015);
        barRenderer.setDefaultItemLabelsVisible(true);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            barRenderer.setSeriesPaint(i, new Color(70, 130, 180));
            barRenderer.setSeriesItemLabelsVisible(i, true);
        }
        CategoryPlot categoryPlot = new CategoryPlot(dataset, categoryAxis, valueAxis, barRenderer);
        categoryPlot.setDomainGridlinesVisible(false);
        categoryPlot.setRangeGridlinesVisible(false);
        return categoryPlot;
    }

    private CategoryPlot createMMPlot(List<Integer> cpgPosListInRegion, Integer[][] cpgHpMatInRegion) {
        ArrayList<Double> mmList = new ArrayList<Double>();
        for (int i = 0; i < cpgPosListInRegion.size(); ++i) {
            Double mm3 = 0.0;
            Double cpgCnt = 0.0;
            Double unCpgCnt = 0.0;
            for (int j = 0; j < cpgHpMatInRegion.length; ++j) {
                Double d;
                Double d2;
                if (cpgHpMatInRegion[j][i] == null) continue;
                if (cpgHpMatInRegion[j][i] == 1) {
                    d2 = cpgCnt;
                    d = cpgCnt = Double.valueOf(cpgCnt + 1.0);
                    continue;
                }
                d2 = unCpgCnt;
                d = unCpgCnt = Double.valueOf(unCpgCnt + 1.0);
            }
            mm3 = cpgCnt / (cpgCnt + unCpgCnt);
            mmList.add(mm3);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < mmList.size(); ++i) {
            dataset.addValue((Number)mmList.get(i), (Comparable)cpgPosListInRegion.get(i), (Comparable)((Object)""));
        }
        CategoryAxis categoryAxis = new CategoryAxis();
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setRange(new Range(0.01, 1.1));
        valueAxis.setVisible(true);
        valueAxis.setTickUnit(new NumberTickUnit(0.5));
        valueAxis.setTickLabelFont(new Font("", 0, this.width / 75));
        valueAxis.setLabel("mean methylation");
        valueAxis.setLabelFont(new Font("", 0, this.width / 60));
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBarPainter(new StandardBarPainter());
        barRenderer.setShadowVisible(false);
        barRenderer.setDrawBarOutline(false);
        barRenderer.setMaximumBarWidth(0.015);
        barRenderer.setDefaultItemLabelsVisible(true);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            barRenderer.setSeriesPaint(i, new Color(70, 130, 180));
            barRenderer.setSeriesItemLabelsVisible(i, true);
        }
        CategoryPlot categoryPlot = new CategoryPlot(dataset, categoryAxis, valueAxis, barRenderer);
        categoryPlot.setDomainGridlinesVisible(false);
        categoryPlot.setRangeGridlinesVisible(false);
        return categoryPlot;
    }

    private XYPlot createWhiteBlackPlot(Integer[][] cpgHpMatInRegion) {
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        double[] x = new double[cpgHpMatInRegion.length * cpgHpMatInRegion[0].length];
        double[] y = new double[cpgHpMatInRegion.length * cpgHpMatInRegion[0].length];
        double[] z = new double[cpgHpMatInRegion.length * cpgHpMatInRegion[0].length];
        for (int i = 0; i < cpgHpMatInRegion.length; ++i) {
            for (int j = 0; j < cpgHpMatInRegion[0].length; ++j) {
                x[cpgHpMatInRegion[0].length * i + j] = j;
                y[cpgHpMatInRegion[0].length * i + j] = i;
                if (cpgHpMatInRegion[i][j] != null) {
                    if (cpgHpMatInRegion[i][j] == 0) {
                        z[cpgHpMatInRegion[0].length * i + j] = -1.0;
                        continue;
                    }
                    z[cpgHpMatInRegion[0].length * i + j] = 1.0;
                    continue;
                }
                z[cpgHpMatInRegion[0].length * i + j] = 0.0;
            }
        }
        double[][] pos = new double[][]{x, y, z};
        dataset.addSeries((Comparable)((Object)"Series"), pos);
        NumberAxis xAxis = new NumberAxis();
        xAxis.setUpperMargin(0.0);
        xAxis.setLowerMargin(0.0);
        xAxis.setVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickUnit(new NumberTickUnit(cpgHpMatInRegion.length * 2));
        yAxis.setRange(new Range(1.0, cpgHpMatInRegion.length));
        yAxis.setAxisLineVisible(false);
        yAxis.setVisible(true);
        yAxis.setLabel("read methylation status");
        yAxis.setLabelFont(new Font("", 0, this.width / 60));
        LookupPaintScale paintScale = new LookupPaintScale(-1.0, 2.0, Color.black);
        paintScale.add(-1.0, Color.white);
        paintScale.add(0.0, new Color(220, 220, 220));
        paintScale.add(1.0, Color.black);
        XYPlot xyPlot = new XYPlot(dataset, xAxis, yAxis, new XYBlockRenderer());
        XYBlockRenderer xyBlockRenderer = new XYBlockRenderer();
        xyBlockRenderer.setPaintScale(paintScale);
        xyBlockRenderer.setBlockHeight(1.0);
        xyBlockRenderer.setBlockWidth(1.0);
        xyPlot.setRenderer(xyBlockRenderer);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(false);
        return xyPlot;
    }

    private XYPlot createBedRegionPlot(List<Integer> cpgPosListInRegion) throws Exception {
        List<BedInfo> bedInfoList = this.util.parseBedFile(this.args.getBedPath(), this.region);
        if (bedInfoList.size() <= 0) {
            return null;
        }
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        double[] x = new double[cpgPosListInRegion.size() * (bedInfoList.size() * 2 + 1)];
        double[] y = new double[cpgPosListInRegion.size() * (bedInfoList.size() * 2 + 1)];
        double[] z = new double[cpgPosListInRegion.size() * (bedInfoList.size() * 2 + 1)];
        for (int i = 0; i < cpgPosListInRegion.size(); ++i) {
            Integer cnt = 2;
            for (int j = 0; j < bedInfoList.size(); ++j) {
                BedInfo bedInfo = bedInfoList.get(j);
                if (bedInfo.getStart() <= cpgPosListInRegion.get(i) && cpgPosListInRegion.get(i) <= bedInfo.getEnd()) {
                    x[cpgPosListInRegion.size() * cnt.intValue() + i] = i;
                    y[cpgPosListInRegion.size() * cnt.intValue() + i] = cnt.intValue();
                    z[cpgPosListInRegion.size() * cnt.intValue() + i] = 1.0;
                }
                cnt = cnt + 2;
            }
        }
        double[][] pos = new double[][]{x, y, z};
        dataset.addSeries((Comparable)((Object)"Series"), pos);
        NumberAxis xAxis = new NumberAxis();
        xAxis.setVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickUnit(new NumberTickUnit(bedInfoList.size() * 5));
        yAxis.setRange(new Range(1.0, bedInfoList.size() * 2 + 1));
        yAxis.setVisible(true);
        yAxis.setLabel("bed file");
        yAxis.setLabelFont(new Font("", 0, this.width / 60));
        LookupPaintScale paintScale = new LookupPaintScale(0.0, 2.0, Color.WHITE);
        paintScale.add(0.0, Color.WHITE);
        paintScale.add(1.0, new Color(70, 130, 180));
        XYPlot xyPlot = new XYPlot(dataset, xAxis, yAxis, new XYBlockRenderer());
        CustomXYBlockRenderer2 xyBlockRenderer = new CustomXYBlockRenderer2();
        xyBlockRenderer.setPaintScale(paintScale);
        xyBlockRenderer.setBlockHeight(0.5);
        xyBlockRenderer.setBlockWidth(1.0);
        xyBlockRenderer.setxBlockNum(cpgPosListInRegion.size());
        xyBlockRenderer.setyBlockNum(bedInfoList.size() * 2 + 1);
        xyBlockRenderer.setSeriesItemLabelsVisible(0, true);
        xyBlockRenderer.setSeriesItemLabelFont(0, new Font("", 0, cpgPosListInRegion.size() * 3 / (bedInfoList.size() * 2 + 1)));
        xyBlockRenderer.setSeriesItemLabelPaint(0, Color.BLACK);
        xyPlot.setRenderer(xyBlockRenderer);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(false);
        return xyPlot;
    }

    private XYPlot createHeatMapPlot(Integer[][] cpgHpMatInRegion, List<Integer> cpgPosListInRegion) throws IOException {
        Double d;
        Double d2;
        ArrayList<R2Info> r2List = new ArrayList<R2Info>();
        for (int i = 0; i < cpgPosListInRegion.size(); ++i) {
            for (int j = i + 1; j < cpgPosListInRegion.size(); ++j) {
                R2Info r2Info = this.util.getR2FromMat(cpgHpMatInRegion, i, j, 0);
                r2Info.setChrom(this.region.getChrom());
                r2Info.setStart(cpgPosListInRegion.get(i));
                r2Info.setEnd(cpgPosListInRegion.get(j));
                r2List.add(r2Info);
            }
        }
        Map<Integer, List<R2Info>> r2ListMap = r2List.stream().collect(Collectors.groupingBy(R2Info::getStart));
        ArrayList<Map.Entry<Integer, List<R2Info>>> r2ListMapSorted = new ArrayList<Map.Entry<Integer, List<R2Info>>>(r2ListMap.entrySet());
        Collections.sort(r2ListMapSorted, new Comparator<Map.Entry<Integer, List<R2Info>>>(){

            @Override
            public int compare(Map.Entry<Integer, List<R2Info>> o1, Map.Entry<Integer, List<R2Info>> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        double[] x = new double[r2List.size()];
        double[] y = new double[r2List.size()];
        double[] z = new double[r2List.size()];
        int next = 0;
        for (int i = 0; i < r2ListMapSorted.size(); ++i) {
            List r2InfoList = (List)((Map.Entry)r2ListMapSorted.get(i)).getValue();
            for (int j = 0; j < r2InfoList.size(); ++j) {
                R2Info r2Info = (R2Info)r2InfoList.get(j);
                x[next + j] = i;
                y[next + j] = j;
                Double r2 = 0.0;
                if (r2Info != null && !r2Info.getR2().isNaN()) {
                    r2 = (r2Info.getR2() < -1.0 ? -1.0 : r2Info.getR2()) > 1.0 ? 1.0 : r2Info.getR2();
                }
                z[next + j] = r2 * r2;
            }
            next += r2InfoList.size();
        }
        double[][] pos = new double[][]{x, y, z};
        dataset.addSeries((Comparable)((Object)"Series"), pos);
        NumberAxis xAxis = new NumberAxis();
        xAxis.setVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickUnit(new NumberTickUnit(cpgHpMatInRegion.length * 2));
        yAxis.setRange(new Range(1.0, cpgHpMatInRegion.length));
        yAxis.setAxisLineVisible(false);
        yAxis.setVisible(true);
        yAxis.setLabel("R2 HeatMap");
        yAxis.setLabelFont(new Font("", 0, this.width / 60));
        LookupPaintScale paintScale = new LookupPaintScale(-1.0, 1.0, Color.black);
        Double j = 0.0;
        while (j < 255.0) {
            paintScale.add((j - 255.0) / 255.0, new Color(j.intValue(), j.intValue(), 255));
            d2 = j;
            d = j = Double.valueOf(j + 1.0);
        }
        j = 255.0;
        while (j < 510.0) {
            paintScale.add((j - 255.0) / 255.0, new Color(255, 510 - j.intValue(), 510 - j.intValue()));
            d2 = j;
            d = j = Double.valueOf(j + 1.0);
        }
        XYPlot xyPlot = new XYPlot(dataset, xAxis, yAxis, new CustomXYBlockRenderer());
        CustomXYBlockRenderer xyBlockRenderer = new CustomXYBlockRenderer();
        xyBlockRenderer.setPaintScale(paintScale);
        xyBlockRenderer.setBlockHeight(1.0);
        xyBlockRenderer.setBlockWidth(1.0);
        xyBlockRenderer.setBlockNum(r2ListMapSorted.size());
        xyPlot.setRenderer(xyBlockRenderer);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(false);
        return xyPlot;
    }

    public void saveAsPdf(List<Plot> plotList, String outputPath, Integer width, List<Integer> heightList, List<Integer> cpgPosListInRegion) throws FileNotFoundException, DocumentException {
        width = width > 14400 ? 14400 : width;
        Integer sumHeight = 0;
        for (int i = 0; i < heightList.size(); ++i) {
            sumHeight = sumHeight + heightList.get(i);
        }
        if (sumHeight > 14400) {
            width = width / sumHeight * 14400;
            sumHeight = 14400;
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputPath));
        Rectangle pagesize = new Rectangle(width.intValue(), sumHeight.intValue());
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(width.intValue(), sumHeight.intValue());
        Graphics2D graphics2D = pdfTemplate.createGraphics(width.intValue(), sumHeight.intValue(), new DefaultFontMapper());
        Integer nextHeight = 0;
        for (int i = 0; i < plotList.size(); ++i) {
            JFreeChart jFreeChart = new JFreeChart("", null, plotList.get(i), false);
            if (i == 0) {
                jFreeChart = new JFreeChart(this.region.toHeadString(), new Font("", 0, sumHeight / 30), plotList.get(i), false);
            }
            jFreeChart.setBackgroundPaint(Color.WHITE);
            Rectangle2D.Double rectangle2D0 = new Rectangle2D.Double(0.0, nextHeight.intValue(), width.intValue(), heightList.get(i).intValue());
            jFreeChart.draw(graphics2D, rectangle2D0);
            if (i == plotList.size() - 1) {
                Double d;
                Double d2;
                LookupPaintScale paintScale = new LookupPaintScale(-1.0, 1.0, Color.black);
                Double j = 0.0;
                while (j < 255.0) {
                    paintScale.add((j - 255.0) / 255.0, new Color(j.intValue(), j.intValue(), 255));
                    d2 = j;
                    d = j = Double.valueOf(j + 1.0);
                }
                j = 255.0;
                while (j < 510.0) {
                    paintScale.add((j - 255.0) / 255.0, new Color(255, 510 - j.intValue(), 510 - j.intValue()));
                    d2 = j;
                    d = j = Double.valueOf(j + 1.0);
                }
                PaintScaleLegend paintScaleLegend = new PaintScaleLegend(paintScale, new NumberAxis());
                paintScaleLegend.setStripWidth(width / cpgPosListInRegion.size() / 5);
                paintScaleLegend.setPosition(RectangleEdge.RIGHT);
                paintScaleLegend.setAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
                paintScaleLegend.setMargin(heightList.get(i) / 3, 0.0, heightList.get(i) / 3, 0.0);
                Rectangle2D.Double legendRectangle2D = new Rectangle2D.Double(width - width / cpgPosListInRegion.size(), nextHeight + heightList.get(i) / 2, width / cpgPosListInRegion.size(), heightList.get(i) / 3);
                paintScaleLegend.draw(graphics2D, legendRectangle2D);
            }
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            nextHeight = nextHeight + heightList.get(i);
        }
        graphics2D.dispose();
        document.close();
        pdfWriter.close();
    }

    public void saveAsPng(List<Plot> plotList, String outputPath, Integer width, List<Integer> heightList, List<Integer> cpgPosListInRegion) throws IOException {
        File outFile = new File(outputPath);
        Integer sumHeight = 0;
        for (int i = 0; i < heightList.size(); ++i) {
            sumHeight = sumHeight + heightList.get(i);
        }
        BufferedImage bufferedImage = new BufferedImage(width, sumHeight, 1);
        Integer nextHeight = 0;
        for (int i = 0; i < plotList.size(); ++i) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            JFreeChart jFreeChart = new JFreeChart("", null, plotList.get(i), false);
            if (i == 0) {
                jFreeChart = new JFreeChart(this.region.toHeadString(), new Font("", 0, sumHeight / 30), plotList.get(i), false);
            }
            jFreeChart.setBackgroundPaint(Color.WHITE);
            Rectangle2D.Double rectangle2D0 = new Rectangle2D.Double(0.0, nextHeight.intValue(), width.intValue(), heightList.get(i).intValue());
            jFreeChart.draw(graphics2D, rectangle2D0);
            if (i == plotList.size() - 1) {
                Double d;
                Double d2;
                LookupPaintScale paintScale = new LookupPaintScale(-1.0, 1.0, Color.black);
                Double j = 0.0;
                while (j < 255.0) {
                    paintScale.add((j - 255.0) / 255.0, new Color(j.intValue(), j.intValue(), 255));
                    d2 = j;
                    d = j = Double.valueOf(j + 1.0);
                }
                j = 255.0;
                while (j < 510.0) {
                    paintScale.add((j - 255.0) / 255.0, new Color(255, 510 - j.intValue(), 510 - j.intValue()));
                    d2 = j;
                    d = j = Double.valueOf(j + 1.0);
                }
                PaintScaleLegend paintScaleLegend = new PaintScaleLegend(paintScale, new NumberAxis());
                paintScaleLegend.setStripWidth(width / cpgPosListInRegion.size() / 5);
                paintScaleLegend.setPosition(RectangleEdge.RIGHT);
                paintScaleLegend.setAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
                paintScaleLegend.setMargin(heightList.get(i) / 3, 0.0, heightList.get(i) / 3, 0.0);
                Rectangle2D.Double legendRectangle2D = new Rectangle2D.Double(width - width / cpgPosListInRegion.size(), nextHeight + heightList.get(i) / 2, width / cpgPosListInRegion.size(), heightList.get(i) / 3);
                paintScaleLegend.draw(graphics2D, legendRectangle2D);
            }
            nextHeight = nextHeight + heightList.get(i);
            graphics2D.dispose();
        }
        BufferedImage rendImage = bufferedImage;
        ImageIO.write((RenderedImage)rendImage, "png", outFile);
    }
}

