/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.MHBDiscoveryArgs;
import com.bean.MHBInfo;
import com.bean.MHapInfo;
import com.bean.R2Info;
import com.bean.Region;
import com.common.Util;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MHBDiscovery {
    public static final Logger log = LoggerFactory.getLogger(MHBDiscovery.class);
    Util util = new Util();
    MHBDiscoveryArgs args = new MHBDiscoveryArgs();

    public void MHBDiscovery(MHBDiscoveryArgs mhbDiscoveryArgs) throws Exception {
        log.info("MHBDiscovery start!");
        this.args = mhbDiscoveryArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        boolean getMHBResult = this.getMHB();
        if (!getMHBResult) {
            log.error("get MHB fail, please check the command.");
            return;
        }
        log.info("MHBDiscovery end!");
    }

    private boolean checkArgs() {
        if (this.args.getMhapPath().equals("")) {
            log.error("mhapPath can not be null.");
            return false;
        }
        if (this.args.getCpgPath().equals("")) {
            log.error("cpgPath can not be null.");
            return false;
        }
        if (!this.args.getRegion().equals("") && !this.args.getBedPath().equals("")) {
            log.error("Can not input region and bedPath at the same time.");
            return false;
        }
        return true;
    }

    private boolean doQC() throws Exception {
        BufferedWriter bufferedWriter = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".qcFlag.bed");
        List<Region> regionList = new ArrayList<Region>();
        if (this.args.getRegion() != null && !this.args.getRegion().equals("")) {
            Region region = this.util.parseRegion(this.args.getRegion());
            regionList.add(region);
        } else if (this.args.getBedPath() != null && !this.args.getBedPath().equals("")) {
            regionList = this.util.getBedRegionList(this.args.getBedPath());
        }
        for (Region region : regionList) {
            List<Integer> cpgPosListInRegion;
            List<Integer> cpgPosList;
            region.setStart(region.getStart() - 1);
            List<MHapInfo> mHapInfoList = this.util.parseMhapFile(this.args.getMhapPath(), region, "both", true);
            if (mHapInfoList.size() < 1 || (cpgPosList = this.util.parseCpgFileWithShift(this.args.getCpgPath(), region, 2000)).size() < 1 || (cpgPosListInRegion = this.util.getCpgPosListInRegion(cpgPosList, region)).size() < 1) continue;
            Map<Integer, List<Integer>> mHapIndexListMapToCpg = this.util.getMhapIndexMapToCpg(mHapInfoList, cpgPosListInRegion);
            boolean isMHBFlag = true;
            Integer firstIndex = 0;
            Integer secondIndex = 0;
            block1: while (secondIndex < cpgPosListInRegion.size() - 1) {
                Integer n = secondIndex;
                Integer n2 = secondIndex = Integer.valueOf(secondIndex + 1);
                for (int i = 1; i < this.args.getWindow() && (firstIndex = Integer.valueOf(secondIndex - i)) >= 0; ++i) {
                    Integer cpgPos1 = cpgPosListInRegion.get(firstIndex);
                    Integer cpgPos2 = cpgPosListInRegion.get(secondIndex);
                    List<Integer> mHapIndexList1 = mHapIndexListMapToCpg.get(cpgPos1);
                    List<Integer> mHapIndexList2 = mHapIndexListMapToCpg.get(cpgPos2);
                    List<MHapInfo> mHapList1 = this.util.getMHapListFromIndex(mHapInfoList, mHapIndexList1);
                    List<MHapInfo> mHapList2 = this.util.getMHapListFromIndex(mHapInfoList, mHapIndexList2);
                    R2Info r2Info = this.util.getR2FromMap(mHapList1, cpgPosList, cpgPos1, cpgPos2, 0);
                    if (r2Info != null && !(r2Info.getR2() < this.args.getR2()) && !(r2Info.getPvalue() > this.args.getPvalue())) continue;
                    isMHBFlag = false;
                    if (r2Info == null || r2Info.getR2().isNaN()) {
                        bufferedWriter.write(region.getChrom() + "\t" + region.getStart() + "\t" + region.getEnd() + "\tno\t" + cpgPosListInRegion.get(firstIndex) + "-" + cpgPosListInRegion.get(secondIndex) + " r2 is null or nan!\n");
                        continue block1;
                    }
                    bufferedWriter.write(region.getChrom() + "\t" + region.getStart() + "\t" + region.getEnd() + "\tno\t" + cpgPosListInRegion.get(firstIndex) + "-" + cpgPosListInRegion.get(secondIndex) + " " + r2Info.getR2() + " " + r2Info.getPvalue() + "\n");
                    continue block1;
                }
            }
            if (!isMHBFlag) continue;
            bufferedWriter.write(region.getChrom() + "\t" + region.getStart() + "\t" + region.getEnd() + "\tyes\n");
        }
        bufferedWriter.close();
        return true;
    }

    private boolean getMHB() throws Exception {
        Object cpgPosList;
        ArrayList<Region> regionList = new ArrayList<Region>();
        if (this.args.getRegion() != null && !this.args.getRegion().equals("")) {
            Region region2 = this.util.parseRegion(this.args.getRegion());
            regionList.addAll(this.util.splitRegionToSmallRegion(region2, 1000000, 1000));
        } else if (this.args.getBedPath() != null && !this.args.getBedPath().equals("")) {
            List<Region> regionListInBed = this.util.getBedRegionList(this.args.getBedPath());
            ArrayList<Serializable> regionListMerged = new ArrayList<Serializable>();
            Map<String, List<Integer>> cpgPosListMap = this.util.parseWholeCpgFile(this.args.getCpgPath());
            for (String string : cpgPosListMap.keySet()) {
                List list = regionListInBed.stream().filter(region -> region.getChrom().equals(string)).collect(Collectors.toList());
                if (list.size() > 1) {
                    Integer i = 0;
                    while (i < list.size() - 1) {
                        Serializable mergeRegion;
                        Region thisRegion = (Region)list.get(i);
                        Integer start = thisRegion.getStart();
                        Region nextRegion = (Region)list.get(i + 1);
                        Integer end = nextRegion.getEnd();
                        cpgPosList = cpgPosListMap.get(thisRegion.getChrom());
                        List<Integer> cpgPosListInThisRegion = this.util.getCpgPosListInRegion((List<Integer>)cpgPosList, thisRegion);
                        List<Integer> cpgPosListInNextRegion = this.util.getCpgPosListInRegion((List<Integer>)cpgPosList, nextRegion);
                        Integer thisRegionEndCpgIndex = this.util.indexOfList((List<Integer>)cpgPosList, 0, cpgPosList.size() - 1, cpgPosListInThisRegion.get(cpgPosListInThisRegion.size() - 1));
                        Integer nextRegionStartCpgIndex = this.util.indexOfList((List<Integer>)cpgPosList, 0, cpgPosList.size() - 1, cpgPosListInNextRegion.get(0));
                        if (nextRegionStartCpgIndex <= thisRegionEndCpgIndex + 1) {
                            int nextNum = 2;
                            while (i + nextNum < list.size() && nextRegionStartCpgIndex <= thisRegionEndCpgIndex + 1) {
                                thisRegion = (Region)list.get(i + nextNum - 1);
                                cpgPosListInThisRegion = this.util.getCpgPosListInRegion((List<Integer>)cpgPosList, thisRegion);
                                thisRegionEndCpgIndex = this.util.indexOfList((List<Integer>)cpgPosList, 0, cpgPosList.size() - 1, cpgPosListInThisRegion.get(cpgPosListInThisRegion.size() - 1));
                                nextRegion = (Region)list.get(i + nextNum);
                                cpgPosListInNextRegion = this.util.getCpgPosListInRegion((List<Integer>)cpgPosList, nextRegion);
                                nextRegionStartCpgIndex = this.util.indexOfList((List<Integer>)cpgPosList, 0, cpgPosList.size() - 1, cpgPosListInNextRegion.get(0));
                                ++nextNum;
                            }
                            end = i + nextNum == list.size() ? nextRegion.getEnd() : thisRegion.getEnd();
                            mergeRegion = new Region();
                            ((Region)mergeRegion).setChrom(string);
                            ((Region)mergeRegion).setStart(start);
                            ((Region)mergeRegion).setEnd(end);
                            regionListMerged.add(mergeRegion);
                            i = i + (nextNum - 1);
                            continue;
                        }
                        Integer nextNum = i;
                        i = i + 1;
                        mergeRegion = i;
                        regionListMerged.add(thisRegion);
                    }
                    continue;
                }
                regionListMerged.add((Serializable)list.get(0));
            }
            for (Region region3 : regionListMerged) {
                regionList.addAll(this.util.splitRegionToSmallRegion(region3, 1000000, 1000));
            }
        } else {
            ArrayList<Region> wholeRegionList = new ArrayList<Region>();
            Map<String, List<Integer>> cpgPostListMap = this.util.parseWholeCpgFile(this.args.getCpgPath());
            for (String string : cpgPostListMap.keySet()) {
                List<Integer> list = cpgPostListMap.get(string);
                Region region4 = new Region();
                region4.setChrom(string);
                region4.setStart(list.get(0));
                region4.setEnd(list.get(list.size() - 1));
                wholeRegionList.add(region4);
            }
            for (Region region5 : wholeRegionList) {
                regionList.addAll(this.util.splitRegionToSmallRegion(region5, 1000000, 1000));
            }
        }
        BufferedWriter bufferedWriter = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".txt");
        HashMap<String, String> mhbInfoListMap = new HashMap<String, String>();
        for (Region region6 : regionList) {
            List<Integer> cpgPosListInRegion;
            List<Integer> list;
            List<MHapInfo> list2 = this.util.parseMhapFile(this.args.getMhapPath(), region6, "both", true);
            if (list2.size() < 1 || (list = this.util.parseCpgFileWithShift(this.args.getCpgPath(), region6, 2000)).size() < 1 || (cpgPosListInRegion = this.util.getCpgPosListInRegion(list, region6)).size() < 1) continue;
            Map<Integer, List<Integer>> mHapIndexListMapToCpg = this.util.getMhapIndexMapToCpg(list2, cpgPosListInRegion);
            Integer startIndex = 0;
            Integer endIndex = 0;
            Integer index = 0;
            while (endIndex < cpgPosListInRegion.size() - 1) {
                cpgPosList = endIndex;
                Integer cpgPosListInThisRegion = endIndex = Integer.valueOf(endIndex + 1);
                Boolean extendFlag = true;
                for (int i = 1; i < this.args.getWindow() && (index = Integer.valueOf(endIndex - i)) >= 0; ++i) {
                    Integer cpgPos1 = cpgPosListInRegion.get(index);
                    Integer cpgPos2 = cpgPosListInRegion.get(endIndex);
                    List<Integer> mHapIndexList1 = mHapIndexListMapToCpg.get(cpgPos1);
                    List<Integer> mHapIndexList2 = mHapIndexListMapToCpg.get(cpgPos2);
                    List<MHapInfo> mHapList1 = this.util.getMHapListFromIndex(list2, mHapIndexList1);
                    List<MHapInfo> mHapList2 = this.util.getMHapListFromIndex(list2, mHapIndexList2);
                    R2Info r2Info = this.util.getR2FromMap(mHapList1, list, cpgPos1, cpgPos2, 0);
                    if (r2Info != null && !(r2Info.getR2() < this.args.getR2()) && !(r2Info.getPvalue() > this.args.getPvalue())) continue;
                    extendFlag = false;
                    break;
                }
                if (extendFlag.booleanValue()) continue;
                MHBInfo mhbInfo = new MHBInfo();
                Integer mhbSize = endIndex - startIndex;
                mhbInfo.setChrom(region6.getChrom());
                mhbInfo.setStart(cpgPosListInRegion.get(startIndex));
                mhbInfo.setEnd(cpgPosListInRegion.get(endIndex - 1));
                startIndex = index + 1 > startIndex ? index + 1 : startIndex;
                if (mhbSize < this.args.getWindow() || mhbInfoListMap.containsKey(mhbInfo.toString())) continue;
                mhbInfoListMap.put(mhbInfo.toString(), mhbInfo.toString());
                bufferedWriter.write(mhbInfo.getChrom() + "\t" + mhbInfo.getStart() + "\t" + mhbInfo.getEnd() + "\n");
            }
            if (endIndex - startIndex >= this.args.getWindow()) {
                MHBInfo mhbInfo = new MHBInfo();
                mhbInfo.setChrom(region6.getChrom());
                mhbInfo.setStart(cpgPosListInRegion.get(startIndex));
                mhbInfo.setEnd(cpgPosListInRegion.get(endIndex));
                if (!mhbInfoListMap.containsKey(mhbInfo.toString())) {
                    mhbInfoListMap.put(mhbInfo.toString(), mhbInfo.toString());
                    bufferedWriter.write(mhbInfo.getChrom() + "\t" + mhbInfo.getStart() + "\t" + mhbInfo.getEnd() + "\n");
                }
            }
            log.info("Get MHB from region: " + region6.toHeadString() + " end!");
        }
        bufferedWriter.close();
        return true;
    }
}

