/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.HeatMapPlotArgs;
import com.bean.Region;
import com.common.Util;
import com.common.bigwigTool.BBFileReader;
import com.common.bigwigTool.BigWigIterator;
import com.common.bigwigTool.WigItem;
import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.rewrite.HeatMapCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatMapPlot {
    public static final Logger log = LoggerFactory.getLogger(HeatMapPlot.class);
    HeatMapPlotArgs args = new HeatMapPlotArgs();
    Util util = new Util();
    public static final Integer MAXSIZE = 10000;

    public void heatMapPlot(HeatMapPlotArgs heatMapPlotArgs) throws Exception {
        log.info("HeatMapPlot start!");
        this.args = heatMapPlotArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        String[] bedPaths = this.args.getBedPaths().split(" ");
        Integer windowNum = (this.args.getUpLength() + this.args.getDownLength()) / this.args.getWindow() + 1;
        if (windowNum > 500) {
            log.error("The upLength/downLength is too big or window is too small, please input again.");
            return;
        }
        Integer width = 2000;
        BBFileReader reader = new BBFileReader(this.args.getBigwig());
        ArrayList<XYPlot> heatPlotList = new ArrayList<XYPlot>();
        ArrayList<Integer> heatHeightList = new ArrayList<Integer>();
        DefaultCategoryDataset lineDataset = new DefaultCategoryDataset();
        for (String bedPath : bedPaths) {
            String bedFileName = new File(bedPath).getName();
            String bedFileLabel = bedFileName.substring(0, bedFileName.lastIndexOf("."));
            List<Region> regionList = this.util.getBedRegionList(bedPath);
            if (regionList.size() < 1) {
                log.info("The bed file:" + bedPath + " is null, please check.");
                continue;
            }
            if (this.args.getSortRegions().equals("descend")) {
                Collections.sort(regionList, new Comparator<Region>(){

                    @Override
                    public int compare(Region o1, Region o2) {
                        if (o1.getChrom().equals(o2.getChrom())) {
                            if (o1.getStart().equals(o2.getStart())) {
                                return o1.getEnd() - o2.getEnd();
                            }
                            return o1.getStart() - o2.getStart();
                        }
                        return o1.getChrom().compareTo(o2.getChrom());
                    }
                });
            } else if (this.args.getSortRegions().equals("ascend")) {
                Collections.sort(regionList, new Comparator<Region>(){

                    @Override
                    public int compare(Region o1, Region o2) {
                        if (o2.getChrom().equals(o1.getChrom())) {
                            if (o2.getStart().equals(o1.getStart())) {
                                return o2.getEnd() - o1.getEnd();
                            }
                            return o2.getStart() - o1.getStart();
                        }
                        return o2.getChrom().compareTo(o1.getChrom());
                    }
                });
            }
            Double[][] valueList = new Double[regionList.size()][windowNum.intValue()];
            for (int i = 0; i < windowNum; ++i) {
                Double sumAverageOfWindow = 0.0;
                Integer notNaNAverageNumOfWindow = 0;
                for (int j = 0; j < regionList.size(); ++j) {
                    Double averageOfWindowOfRegion;
                    Integer n;
                    Integer n2;
                    Region region = regionList.get(j);
                    Integer midSiteOfRegion = (region.getStart() + region.getEnd()) / 2;
                    Integer startSiteOfWindow = midSiteOfRegion - this.args.getUpLength() + this.args.getWindow() * i;
                    if (startSiteOfWindow < 0) {
                        startSiteOfWindow = 0;
                    }
                    Integer endSiteOfWindow = startSiteOfWindow + this.args.getWindow();
                    BigWigIterator iter = reader.getBigWigIterator(region.getChrom(), startSiteOfWindow, region.getChrom(), endSiteOfWindow, true);
                    Double sumOfWindowOfRegion = 0.0;
                    Integer numOfWindowOfRegion = 0;
                    while (iter.hasNext()) {
                        WigItem wigItem = iter.next();
                        sumOfWindowOfRegion = sumOfWindowOfRegion + (double)wigItem.getWigValue();
                        n2 = numOfWindowOfRegion;
                        n = numOfWindowOfRegion = Integer.valueOf(numOfWindowOfRegion + 1);
                    }
                    valueList[j][i] = averageOfWindowOfRegion = Double.valueOf(numOfWindowOfRegion > 0 ? sumOfWindowOfRegion / (double)numOfWindowOfRegion.intValue() : Double.NaN);
                    if (averageOfWindowOfRegion.isNaN()) continue;
                    sumAverageOfWindow = sumAverageOfWindow + averageOfWindowOfRegion;
                    n2 = notNaNAverageNumOfWindow;
                    n = notNaNAverageNumOfWindow = Integer.valueOf(notNaNAverageNumOfWindow + 1);
                }
                Double average = sumAverageOfWindow > 0.0 ? sumAverageOfWindow / (double)notNaNAverageNumOfWindow.intValue() : 0.0;
                Integer xAxisPos = this.args.getUpLength() * -1 + this.args.getWindow() * i;
                Double kbPos = Double.valueOf(xAxisPos.intValue()) / 1000.0;
                String xAisLabel = "";
                xAisLabel = xAxisPos == 0 ? "center" : (Math.abs(kbPos - (double)Math.round(kbPos)) < Double.MIN_VALUE ? kbPos.intValue() + "Kb" : kbPos + "Kb");
                lineDataset.addValue(average, (Comparable)((Object)bedFileLabel), (Comparable)((Object)xAisLabel));
            }
            if (this.args.isMatrixFlag()) {
                int i;
                BufferedWriter bufferedWriter = this.util.createOutputFile("", bedFileLabel + ".heatMapPlot_matrix.txt");
                String matrixHead = "";
                for (i = 0; i < windowNum; ++i) {
                    Integer startSiteOfWindow = 0 - this.args.getUpLength() + this.args.getWindow() * i;
                    Integer endSiteOfWindow = startSiteOfWindow + this.args.getWindow();
                    matrixHead = matrixHead + "\t" + startSiteOfWindow + "-" + endSiteOfWindow;
                }
                bufferedWriter.write(matrixHead + "\n");
                for (i = 0; i < valueList.length; ++i) {
                    String matrixLine = regionList.get(i).toHeadString();
                    for (int j = 0; j < valueList[0].length; ++j) {
                        matrixLine = matrixLine + "\t" + valueList[i][j];
                    }
                    bufferedWriter.write(matrixLine + "\n");
                }
                bufferedWriter.close();
            }
            if (this.args.getSortRegions().equals("missingValues")) {
                Arrays.sort(valueList, new Comparator<Double[]>(){

                    @Override
                    public int compare(Double[] o1, Double[] o2) {
                        return (int)Arrays.stream(o2).filter(value -> !value.isNaN()).count() - (int)Arrays.stream(o1).filter(value -> !value.isNaN()).count();
                    }
                });
            }
            XYPlot heatPlot = this.generateHeatPlot(valueList, bedFileLabel, width);
            heatPlotList.add(heatPlot);
            Integer height = regionList.size() / 20 < 500 ? 500 : regionList.size() / 20;
            heatHeightList.add(height);
            log.info("Read " + bedPath + " end!");
        }
        reader.close();
        ArrayList<Plot> plotList = new ArrayList<Plot>();
        ArrayList<Integer> heightList = new ArrayList<Integer>();
        CategoryPlot linePlot = this.generateLinePlot(lineDataset, width);
        plotList.add(linePlot);
        plotList.addAll(heatPlotList);
        heightList.add(width / 2);
        heightList.addAll(heatHeightList);
        String outputPath = this.args.getTag() + ".heatMapPlot." + this.args.getOutFormat();
        if (this.args.getOutFormat().equals("pdf")) {
            this.saveAsPdf(plotList, outputPath, width, heightList);
        } else if (this.args.getOutFormat().equals("png")) {
            this.saveAsPng(plotList, outputPath, width, heightList);
        }
        log.info("HeatMapPlot end!");
    }

    private boolean checkArgs() {
        if (this.args.getBigwig() == null || this.args.getBigwig().equals("")) {
            log.error("The bigwig file can not be null.");
            return false;
        }
        if (this.args.getBedPaths() == null || this.args.getBedPaths().equals("")) {
            log.error("The bed file can not be null.");
            return false;
        }
        if (this.args.getTag() == null || this.args.getTag().equals("")) {
            log.error("The tag can not be null.");
            return false;
        }
        if (!this.args.getOutFormat().equals("png") && !this.args.getOutFormat().equals("pdf")) {
            log.error("The output format must be pdf or png");
            return false;
        }
        if (!(this.args.getSortRegions().equals("keep") || this.args.getSortRegions().equals("descend") || this.args.getSortRegions().equals("ascend") || this.args.getSortRegions().equals("missingValues"))) {
            log.error("The sortRegions format must be keep, descend, ascend or missingValues");
            return false;
        }
        if (this.args.getUpLength() != null && this.args.getUpLength() % this.args.getWindow() != 0) {
            log.error("The upLength should be a multiple of window");
            return false;
        }
        if (this.args.getDownLength() != null && this.args.getDownLength() % this.args.getWindow() != 0) {
            log.error("The upLength should be a multiple of window");
            return false;
        }
        return true;
    }

    private CategoryPlot generateLinePlot(CategoryDataset dataset, Integer width) {
        JFreeChart jFreeChart = ChartFactory.createLineChart("", "", "", dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.WHITE);
        categoryPlot.setRangeGridlinesVisible(false);
        categoryPlot.setOutlinePaint(Color.BLACK);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setDefaultShapesVisible(false);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            renderer.setSeriesStroke(i, new BasicStroke(width / 300));
        }
        categoryPlot.setRenderer(renderer);
        HeatMapCategoryAxis xAxis = new HeatMapCategoryAxis();
        xAxis.setTickLabelFont(new Font("", 0, width / 50));
        xAxis.setLowerMargin(0.02);
        xAxis.setUpperMargin(0.02);
        xAxis.setTickMarksVisible(false);
        xAxis.setAxisLineVisible(false);
        categoryPlot.setDomainAxis(xAxis);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickUnit(new NumberTickUnit(0.2));
        yAxis.setTickLabelFont(new Font("", 0, width / 60));
        yAxis.setRange(new Range(0.0, 1.0));
        yAxis.setLabelFont(new Font("", 0, width / 60));
        yAxis.setTickMarksVisible(false);
        yAxis.setAxisLineVisible(false);
        categoryPlot.setRangeAxis(yAxis);
        return categoryPlot;
    }

    private XYPlot generateHeatPlot(Double[][] dataMatrix, String yAxisLable, Integer width) {
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        double[] x = new double[dataMatrix.length * dataMatrix[0].length];
        double[] y = new double[dataMatrix.length * dataMatrix[0].length];
        double[] z = new double[dataMatrix.length * dataMatrix[0].length];
        for (int i = 0; i < dataMatrix.length; ++i) {
            for (int j = 0; j < dataMatrix[0].length; ++j) {
                x[dataMatrix[0].length * i + j] = j;
                y[dataMatrix[0].length * i + j] = i;
                if (dataMatrix[i][j].isNaN()) {
                    dataMatrix[i][j] = 0.0;
                }
                z[dataMatrix[0].length * i + j] = dataMatrix[i][j];
            }
        }
        double[][] pos = new double[][]{x, y, z};
        dataset.addSeries((Comparable)((Object)"Series"), pos);
        NumberAxis xAxis = new NumberAxis();
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickUnit(new NumberTickUnit(dataMatrix.length * 2));
        yAxis.setRange(new Range(1.0, dataMatrix.length));
        yAxis.setAxisLineVisible(false);
        yAxis.setVisible(true);
        yAxis.setLabel(yAxisLable);
        yAxis.setLabelFont(new Font("", 0, width / 50));
        LookupPaintScale paintScale = new LookupPaintScale(0.0, 1.0, Color.black);
        Double j = 0.0;
        while (j < 255.0) {
            paintScale.add((255.0 - j) / 255.0, new Color((int)(255.0 - j / 3.0 * 2.0), (int)(255.0 - j / 3.0 * 2.0), j.intValue()));
            Double d = j;
            Double d2 = j = Double.valueOf(j + 1.0);
        }
        XYPlot xyPlot = new XYPlot(dataset, xAxis, yAxis, new XYBlockRenderer());
        XYBlockRenderer xyBlockRenderer = new XYBlockRenderer();
        xyBlockRenderer.setPaintScale(paintScale);
        xyBlockRenderer.setBlockHeight(1.0);
        xyBlockRenderer.setBlockWidth(1.0);
        xyPlot.setRenderer(xyBlockRenderer);
        xyPlot.setDomainGridlinesVisible(false);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlineVisible(false);
        return xyPlot;
    }

    public void saveAsPdf(List<Plot> plotList, String outputPath, Integer width, List<Integer> heightList) throws FileNotFoundException, DocumentException {
        width = width > 14400 ? 14400 : width;
        Integer sumHeight = 0;
        for (int i = 0; i < heightList.size(); ++i) {
            sumHeight = sumHeight + heightList.get(i);
        }
        if (sumHeight > 14400) {
            width = width / sumHeight * 14400;
            sumHeight = 14400;
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputPath));
        Rectangle pagesize = new Rectangle(width.intValue(), sumHeight.intValue());
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(width.intValue(), sumHeight.intValue());
        Graphics2D graphics2D = pdfTemplate.createGraphics(width.intValue(), sumHeight.intValue(), new DefaultFontMapper());
        Integer nextHeight = 0;
        for (int i = 0; i < plotList.size(); ++i) {
            JFreeChart jFreeChart = new JFreeChart("", null, plotList.get(i), false);
            jFreeChart.setBackgroundPaint(Color.WHITE);
            Double plotWidth = width.doubleValue();
            if (i == 0) {
                String bigwigName = new File(this.args.getBigwig()).getName();
                String title = bigwigName.substring(0, bigwigName.lastIndexOf("."));
                jFreeChart = new JFreeChart(title, new Font("", 0, width / 50), plotList.get(i), true);
                LegendTitle legendTitle = jFreeChart.getLegend();
                legendTitle.setBorder(0.0, 0.0, 0.0, 0.0);
                legendTitle.setItemFont(new Font("", 0, width / 50));
                plotWidth = plotWidth - (double)width.intValue() * 0.025;
            } else {
                plotWidth = plotWidth - (double)width.intValue() * 0.025;
            }
            jFreeChart.setBackgroundPaint(Color.WHITE);
            Rectangle2D.Double rectangle2D0 = new Rectangle2D.Double(0.0, nextHeight.intValue(), plotWidth, heightList.get(i).intValue());
            jFreeChart.draw(graphics2D, rectangle2D0);
            if (i == plotList.size() - 1) {
                LookupPaintScale paintScale = new LookupPaintScale(0.0, 1.0, Color.black);
                Double j = 0.0;
                while (j < 255.0) {
                    paintScale.add((255.0 - j) / 255.0, new Color((int)(255.0 - j / 3.0 * 2.0), (int)(255.0 - j / 3.0 * 2.0), j.intValue()));
                    Double d = j;
                    Double d2 = j = Double.valueOf(j + 1.0);
                }
                PaintScaleLegend paintScaleLegend = new PaintScaleLegend(paintScale, new NumberAxis());
                paintScaleLegend.setStripWidth(width / 100);
                paintScaleLegend.setPosition(RectangleEdge.RIGHT);
                paintScaleLegend.setAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
                paintScaleLegend.setMargin(heightList.get(i) / 3, 0.0, heightList.get(i) / 3, 0.0);
                Rectangle2D.Double legendRectangle2D = new Rectangle2D.Double(plotWidth, nextHeight + heightList.get(i) / 3, (double)width.intValue() * 0.05, heightList.get(i) / 3);
                paintScaleLegend.draw(graphics2D, legendRectangle2D);
            }
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            nextHeight = nextHeight + heightList.get(i);
        }
        graphics2D.dispose();
        document.close();
        pdfWriter.close();
    }

    public void saveAsPng(List<Plot> plotList, String outputPath, Integer width, List<Integer> heightList) throws IOException {
        File outFile = new File(outputPath);
        Integer sumHeight = 0;
        for (int i = 0; i < heightList.size(); ++i) {
            sumHeight = sumHeight + heightList.get(i);
        }
        BufferedImage bufferedImage = new BufferedImage(width, sumHeight, 1);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, sumHeight);
        Integer nextHeight = 0;
        for (int i = 0; i < plotList.size(); ++i) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            JFreeChart jFreeChart = new JFreeChart("", null, plotList.get(i), false);
            Double plotWidth = width.doubleValue();
            if (i == 0) {
                String bigwigName = new File(this.args.getBigwig()).getName();
                String title = bigwigName.substring(0, bigwigName.lastIndexOf("."));
                jFreeChart = new JFreeChart(title, new Font("", 0, width / 50), plotList.get(i), true);
                LegendTitle legendTitle = jFreeChart.getLegend();
                legendTitle.setBorder(0.0, 0.0, 0.0, 0.0);
                legendTitle.setItemFont(new Font("", 0, width / 50));
                plotWidth = plotWidth - (double)width.intValue() * 0.025;
            } else {
                plotWidth = plotWidth - (double)width.intValue() * 0.025;
            }
            jFreeChart.setBackgroundPaint(Color.WHITE);
            Rectangle2D.Double rectangle2D0 = new Rectangle2D.Double(0.0, nextHeight.intValue(), plotWidth, heightList.get(i).intValue());
            jFreeChart.draw(graphics2D, rectangle2D0);
            if (i == plotList.size() - 1) {
                LookupPaintScale paintScale = new LookupPaintScale(0.0, 1.0, Color.black);
                Double j = 0.0;
                while (j < 255.0) {
                    paintScale.add((255.0 - j) / 255.0, new Color((int)(255.0 - j / 3.0 * 2.0), (int)(255.0 - j / 3.0 * 2.0), j.intValue()));
                    Double d = j;
                    Double d2 = j = Double.valueOf(j + 1.0);
                }
                PaintScaleLegend paintScaleLegend = new PaintScaleLegend(paintScale, new NumberAxis());
                paintScaleLegend.setStripWidth(width / 100);
                paintScaleLegend.setPosition(RectangleEdge.RIGHT);
                paintScaleLegend.setAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
                paintScaleLegend.setMargin(heightList.get(i) / 3, 0.0, heightList.get(i) / 3, 0.0);
                Rectangle2D.Double legendRectangle2D = new Rectangle2D.Double(plotWidth, nextHeight + heightList.get(i) / 3, (double)width.intValue() * 0.05, heightList.get(i) / 3);
                paintScaleLegend.draw(graphics2D, legendRectangle2D);
            }
            nextHeight = nextHeight + heightList.get(i);
            graphics2D.dispose();
        }
        BufferedImage rendImage = bufferedImage;
        ImageIO.write((RenderedImage)rendImage, "png", outFile);
    }
}

