/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.GenomeWideArgs;
import com.bean.BedGraphInfo;
import com.bean.MHapInfo;
import com.bean.Region;
import com.common.Util;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenomeWide {
    public final Logger log = LoggerFactory.getLogger(GenomeWide.class);
    GenomeWideArgs args = new GenomeWideArgs();
    Util util = new Util();
    BufferedWriter bufferedWriterCov = null;
    BufferedWriter bufferedWriterMM = null;
    BufferedWriter bufferedWriterPDR = null;
    BufferedWriter bufferedWriterCHALM = null;
    BufferedWriter bufferedWriterMHL = null;
    BufferedWriter bufferedWriterMCR = null;
    BufferedWriter bufferedWriterMBS = null;
    BufferedWriter bufferedWriterEntropy = null;
    BufferedWriter bufferedWriterR2 = null;

    public void genomeWide(GenomeWideArgs genomeWideArgs) throws Exception {
        this.log.info("GenomeWide start!");
        this.args = genomeWideArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            this.log.error("Checkargs fail, please check the command.");
            return;
        }
        if (this.args.getMetrics().contains("Cov")) {
            this.bufferedWriterCov = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".Cov.bedGraph");
        }
        if (this.args.getMetrics().contains("MM")) {
            this.bufferedWriterMM = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".MM.bedGraph");
        }
        if (this.args.getMetrics().contains("PDR")) {
            this.bufferedWriterPDR = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".PDR.bedGraph");
        }
        if (this.args.getMetrics().contains("CHALM")) {
            this.bufferedWriterCHALM = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".CHALM.bedGraph");
        }
        if (this.args.getMetrics().contains("MHL")) {
            this.bufferedWriterMHL = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".MHL.bedGraph");
        }
        if (this.args.getMetrics().contains("MCR")) {
            this.bufferedWriterMCR = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".MCR.bedGraph");
        }
        if (this.args.getMetrics().contains("MBS")) {
            this.bufferedWriterMBS = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".MBS.bedGraph");
        }
        if (this.args.getMetrics().contains("Entropy")) {
            this.bufferedWriterEntropy = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".Entropy.bedGraph");
        }
        if (this.args.getMetrics().contains("R2")) {
            this.bufferedWriterR2 = this.util.createOutputFile(this.args.getOutputDir(), this.args.getTag() + ".R2.bedGraph");
        }
        if (this.args.getRegion() != null && !this.args.getRegion().equals("")) {
            Region region = this.util.parseRegion(this.args.getRegion());
            List<Integer> cpgPosList = this.util.parseCpgFileWithShift(this.args.getCpgPath(), region, 500);
            Boolean calculateRegionResult = this.calculateRegion(cpgPosList, region);
            if (!calculateRegionResult.booleanValue()) {
                this.log.error("Calculate " + region.toHeadString() + " fail!");
                return;
            }
        } else if (this.args.getBedPath() != null && !this.args.getBedPath().equals("")) {
            List<Region> regionList = this.util.getBedRegionList(this.args.getBedPath());
            for (Region region : regionList) {
                List<Integer> cpgPosList = this.util.parseCpgFileWithShift(this.args.getCpgPath(), region, 500);
                Boolean calculateRegionResult = this.calculateRegion(cpgPosList, region);
                if (calculateRegionResult.booleanValue()) continue;
                this.log.error("Calculate " + region.toHeadString() + " fail!");
                return;
            }
        } else {
            Boolean calculateResult = this.calculateWholeGenome();
            if (!calculateResult.booleanValue()) {
                this.log.error("calculateResult fail!");
                return;
            }
        }
        if (this.args.getMetrics().contains("Cov")) {
            this.bufferedWriterCov.close();
        }
        if (this.args.getMetrics().contains("MM")) {
            this.bufferedWriterMM.close();
        }
        if (this.args.getMetrics().contains("PDR")) {
            this.bufferedWriterPDR.close();
        }
        if (this.args.getMetrics().contains("CHALM")) {
            this.bufferedWriterCHALM.close();
        }
        if (this.args.getMetrics().contains("MHL")) {
            this.bufferedWriterMHL.close();
        }
        if (this.args.getMetrics().contains("MCR")) {
            this.bufferedWriterMCR.close();
        }
        if (this.args.getMetrics().contains("MBS")) {
            this.bufferedWriterMBS.close();
        }
        if (this.args.getMetrics().contains("Entropy")) {
            this.bufferedWriterEntropy.close();
        }
        if (this.args.getMetrics().contains("R2")) {
            this.bufferedWriterR2.close();
        }
        this.log.info("GenomeWide end!");
    }

    private boolean checkArgs() {
        if (this.args.getMhapPath().equals("")) {
            this.log.error("mhapPath can not be null.");
            return false;
        }
        if (this.args.getCpgPath().equals("")) {
            this.log.error("cpgPath can not be null.");
            return false;
        }
        if (this.args.getMetrics().equals("")) {
            this.log.error("metrics can not be null.");
            return false;
        }
        if (!this.args.getRegion().equals("") && !this.args.getBedPath().equals("")) {
            this.log.error("Can not input region and bedPath at the same time.");
            return false;
        }
        return true;
    }

    private boolean calculateWholeGenome() throws Exception {
        Map<String, List<Integer>> cpgPosListMapRaw = this.util.parseWholeCpgFile(this.args.getCpgPath());
        ArrayList<Map.Entry<String, List<Integer>>> cpgPosListMapList = new ArrayList<Map.Entry<String, List<Integer>>>(cpgPosListMapRaw.entrySet());
        cpgPosListMapList.sort(new Comparator<Map.Entry<String, List<Integer>>>(){

            @Override
            public int compare(Map.Entry<String, List<Integer>> o1, Map.Entry<String, List<Integer>> o2) {
                String chromNum1 = o1.getKey().substring(3, o1.getKey().length());
                String chromNum2 = o2.getKey().substring(3, o2.getKey().length());
                if (GenomeWide.this.util.isNumeric(chromNum1) && GenomeWide.this.util.isNumeric(chromNum2)) {
                    return Integer.valueOf(chromNum1) - Integer.valueOf(chromNum2);
                }
                return chromNum1.compareTo(chromNum2);
            }
        });
        for (Map.Entry entry : cpgPosListMapList) {
            List cpgPosList = (List)entry.getValue();
            Region region = new Region();
            region.setChrom((String)entry.getKey());
            region.setStart((Integer)cpgPosList.get(0));
            region.setEnd((Integer)cpgPosList.get(cpgPosList.size() - 1));
            Boolean calculateRegionResult = this.calculateRegion(cpgPosList, region);
            if (!calculateRegionResult.booleanValue()) {
                this.log.error("Calculate " + region.toHeadString() + " fail!");
                return false;
            }
            this.log.info("Calculate " + (String)entry.getKey() + " end!");
        }
        return true;
    }

    private boolean calculateRegion(List<Integer> cpgPosList, Region region) throws Exception {
        String[] metricsList;
        int[] nReadsList = new int[cpgPosList.size()];
        int[] mReadList = new int[cpgPosList.size()];
        int[] cBaseList = new int[cpgPosList.size()];
        int[] tBaseList = new int[cpgPosList.size()];
        int[] K4plusList = new int[cpgPosList.size()];
        int[] nDRList = new int[cpgPosList.size()];
        int[] nMRList = new int[cpgPosList.size()];
        int[][] methKmersList = new int[0][0];
        int[][] totalKmersList = new int[0][0];
        if (this.args.getMetrics().contains("MHL")) {
            methKmersList = new int[this.args.getMaxK() - this.args.getMinK() + 1][cpgPosList.size()];
            totalKmersList = new int[this.args.getMaxK() - this.args.getMinK() + 1][cpgPosList.size()];
        }
        Double[] mbsNumList = new Double[]{};
        if (this.args.getMetrics().contains("MBS")) {
            mbsNumList = new Double[cpgPosList.size()];
            Integer i = 0;
            while (i < cpgPosList.size()) {
                mbsNumList[i.intValue()] = 0.0;
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        int[][] kmerList = new int[0][0];
        int[] kmerAllList = new int[]{};
        if (this.args.getMetrics().contains("Entropy")) {
            kmerList = new int[this.args.getK() * this.args.getK()][cpgPosList.size()];
            kmerAllList = new int[cpgPosList.size()];
        }
        int[][] N00List = new int[0][0];
        int[][] N01List = new int[0][0];
        int[][] N10List = new int[0][0];
        int[][] N11List = new int[0][0];
        if (this.args.getMetrics().contains("R2")) {
            N00List = new int[4][cpgPosList.size()];
            N01List = new int[4][cpgPosList.size()];
            N10List = new int[4][cpgPosList.size()];
            N11List = new int[4][cpgPosList.size()];
        }
        TabixReader tabixReader = new TabixReader(this.args.getMhapPath());
        TabixReader.Iterator mhapIterator = tabixReader.query(region.getChrom(), region.getStart() - 1, (int)region.getEnd());
        ArrayList<MHapInfo> mHapInfoList = new ArrayList<MHapInfo>();
        String mHapLine = "";
        Integer mHapLineCnt = 0;
        while ((mHapLine = mhapIterator.next()) != null) {
            int i;
            if (this.args.getStrand().equals("plus") && mHapLine.split("\t")[5].equals("-") || this.args.getStrand().equals("minus") && mHapLine.split("\t")[5].equals("+")) continue;
            Integer n = mHapLineCnt;
            Integer n3 = mHapLineCnt = Integer.valueOf(mHapLineCnt + 1);
            if (mHapLineCnt % 1000000 == 0) {
                this.log.info("Calculate complete " + region.getChrom() + " " + mHapLineCnt + " mhap lines.");
            }
            MHapInfo mHapInfo = new MHapInfo(mHapLine.split("\t")[0], Integer.valueOf(mHapLine.split("\t")[1]), Integer.valueOf(mHapLine.split("\t")[2]), mHapLine.split("\t")[3], Integer.valueOf(mHapLine.split("\t")[4]), mHapLine.split("\t")[5]);
            mHapInfoList.add(mHapInfo);
            Integer cpgPosIndex = this.util.indexOfList(cpgPosList, 0, cpgPosList.size() - 1, mHapInfo.getStart());
            String cpgStr = mHapInfo.getCpg();
            Integer cpgLen = cpgStr.length();
            Integer readCnt = mHapInfo.getCnt();
            for (i = 0; i < cpgLen; ++i) {
                if (cpgStr.charAt(i) == '1') {
                    int n4 = cpgPosIndex + i;
                    mReadList[n4] = mReadList[n4] + readCnt;
                }
                int n5 = cpgPosIndex + i;
                nReadsList[n5] = nReadsList[n5] + readCnt;
                int n6 = cpgPosIndex + i;
                tBaseList[n6] = tBaseList[n6] + cpgLen * readCnt;
                if (!cpgStr.contains("1")) continue;
                long noMethCnt = cpgStr.chars().filter(ch -> ch == 48).count();
                int n7 = cpgPosIndex + i;
                cBaseList[n7] = (int)((long)cBaseList[n7] + noMethCnt * (long)readCnt.intValue());
            }
            if (cpgLen >= this.args.getK()) {
                for (i = 0; i < cpgLen; ++i) {
                    int n8 = cpgPosIndex + i;
                    K4plusList[n8] = K4plusList[n8] + readCnt;
                    if (!cpgStr.contains("1")) continue;
                    int n9 = cpgPosIndex + i;
                    nMRList[n9] = nMRList[n9] + readCnt;
                    if (!cpgStr.contains("0")) continue;
                    int n10 = cpgPosIndex + i;
                    nDRList[n10] = nDRList[n10] + readCnt;
                }
            }
            if (this.args.getMetrics().contains("MHL")) {
                int i2;
                if (this.args.getMinK() > cpgLen) {
                    this.log.error("calculate MHL Error: minK is too large.");
                    continue;
                }
                Integer maxK = this.args.getMaxK() > cpgLen ? cpgLen : this.args.getMaxK();
                int[] subMethKmersList = new int[cpgLen.intValue()];
                int[] subTotalKmersList = new int[cpgLen.intValue()];
                String fullMethStr = "1";
                for (i2 = 0; i2 < cpgLen; ++i2) {
                    Integer noMethCnt = 0;
                    int start = 0;
                    while (cpgStr.indexOf(fullMethStr, start) >= 0 && start < cpgStr.length()) {
                        Integer n11 = noMethCnt;
                        Integer n12 = noMethCnt = Integer.valueOf(noMethCnt + 1);
                        start = cpgStr.indexOf(fullMethStr, start) + 1;
                    }
                    subMethKmersList[i2] = noMethCnt * readCnt;
                    subTotalKmersList[i2] = (cpgLen - i2) * readCnt;
                    fullMethStr = fullMethStr + "1";
                }
                for (i2 = this.args.getMinK() - 1; i2 < maxK; ++i2) {
                    Integer row = i2 - this.args.getMinK() + 1;
                    for (int j = 0; j < cpgLen; ++j) {
                        int[] nArray = methKmersList[row];
                        int n13 = cpgPosIndex + j;
                        nArray[n13] = nArray[n13] + subMethKmersList[i2];
                        int[] nArray2 = totalKmersList[row];
                        int n14 = cpgPosIndex + j;
                        nArray2[n14] = nArray2[n14] + subTotalKmersList[i2];
                    }
                }
            }
            if (this.args.getMetrics().contains("MBS")) {
                Double mbsNum = 0.0;
                if (cpgLen >= this.args.getK()) {
                    for (int i3 = 0; i3 < cpgLen; ++i3) {
                        String[] cpgStrList = cpgStr.split("0");
                        Double temp = 0.0;
                        for (String cpg : cpgStrList) {
                            temp = temp + Math.pow(cpg.length(), 2.0);
                        }
                        mbsNum = temp / Math.pow(cpgLen.intValue(), 2.0) * (double)readCnt.intValue();
                        Object[] i4 = mbsNumList;
                        int row = cpgPosIndex + i3;
                        Double.valueOf((Double)i4[row] + mbsNum);
                    }
                }
            }
            if (this.args.getMetrics().contains("Entropy") && cpgLen >= this.args.getK()) {
                int i5;
                HashMap<String, Integer> kmerMap = new HashMap<String, Integer>();
                for (i5 = 0; i5 < cpgLen - this.args.getK() + 1; ++i5) {
                    String kmerStr = cpgStr.substring(i5, i5 + this.args.getK());
                    if (kmerMap.containsKey(kmerStr)) {
                        kmerMap.put(kmerStr, (Integer)kmerMap.get(kmerStr) + readCnt);
                        continue;
                    }
                    kmerMap.put(kmerStr, readCnt);
                }
                for (i5 = 0; i5 < cpgLen; ++i5) {
                    for (String key : kmerMap.keySet()) {
                        Double index = 0.0;
                        for (int j = 0; j < key.length(); ++j) {
                            if (key.charAt(key.length() - 1 - j) != '1') continue;
                            index = index + Math.pow(2.0, j);
                        }
                        int[] nArray = kmerList[index.intValue()];
                        int n15 = cpgPosIndex + i5;
                        nArray[n15] = nArray[n15] + (Integer)kmerMap.get(key);
                        int n16 = cpgPosIndex + i5;
                        kmerAllList[n16] = kmerAllList[n16] + (Integer)kmerMap.get(key);
                    }
                }
            }
            if (!this.args.getMetrics().contains("R2")) continue;
            for (int i6 = 0; i6 < cpgLen; ++i6) {
                for (int j = i6 - 2; j < i6 + 3; ++j) {
                    if (j < 0 || j == i6 || j >= cpgLen) continue;
                    Integer index = j - i6 > 0 ? j - i6 + 1 : j - i6 + 2;
                    if (mHapInfo.getCpg().charAt(i6) == '0' && mHapInfo.getCpg().charAt(j) == '0') {
                        int[] nArray = N00List[index];
                        int n17 = cpgPosIndex + i6;
                        nArray[n17] = nArray[n17] + readCnt;
                        continue;
                    }
                    if (mHapInfo.getCpg().charAt(i6) == '0' && mHapInfo.getCpg().charAt(j) == '1') {
                        int[] nArray = N01List[index];
                        int n18 = cpgPosIndex + i6;
                        nArray[n18] = nArray[n18] + readCnt;
                        continue;
                    }
                    if (mHapInfo.getCpg().charAt(i6) == '1' && mHapInfo.getCpg().charAt(j) == '0') {
                        int[] nArray = N10List[index];
                        int n19 = cpgPosIndex + i6;
                        nArray[n19] = nArray[n19] + readCnt;
                        continue;
                    }
                    if (mHapInfo.getCpg().charAt(i6) != '1' || mHapInfo.getCpg().charAt(j) != '1') continue;
                    int[] nArray = N11List[index];
                    int n20 = cpgPosIndex + i6;
                    nArray[n20] = nArray[n20] + readCnt;
                }
            }
        }
        tabixReader.close();
        List<Integer> cpgPosListInRegion = this.util.getCpgPosListInRegion(cpgPosList, region);
        Integer start = this.util.indexOfList(cpgPosList, 0, cpgPosList.size(), cpgPosListInRegion.get(0));
        for (String metric : metricsList = this.args.getMetrics().trim().split(" ")) {
            Integer cpgPosCnt = 0;
            Integer i = 0;
            while (i < cpgPosListInRegion.size()) {
                block48: {
                    BedGraphInfo bedGraphInfo;
                    block55: {
                        block54: {
                            Integer K4plus;
                            block53: {
                                Integer tBase;
                                Integer cBase;
                                block52: {
                                    block51: {
                                        Integer nMR;
                                        block50: {
                                            Integer nDR;
                                            block49: {
                                                Integer index = cpgPosCnt;
                                                Integer j = cpgPosCnt = Integer.valueOf(cpgPosCnt + 1);
                                                if (cpgPosCnt % 100000 == 0) {
                                                    this.log.info("Calculate " + metric + " complete " + cpgPosCnt + " cpg positions.");
                                                }
                                                Integer nReads = nReadsList[start + i];
                                                Integer mRead = mReadList[start + i];
                                                cBase = cBaseList[start + i];
                                                tBase = tBaseList[start + i];
                                                K4plus = K4plusList[start + i];
                                                nDR = nDRList[start + i];
                                                nMR = nMRList[start + i];
                                                if ((metric.equals("MM") || metric.equals("MCR")) && nReads < this.args.getCpgCov() || (metric.equals("PDR") || metric.equals("CHALM") || metric.equals("MHL") || metric.equals("MBS") || metric.equals("Entropy")) && K4plus < this.args.getK4Plus()) break block48;
                                                bedGraphInfo = new BedGraphInfo();
                                                bedGraphInfo.setChrom(region.getChrom());
                                                bedGraphInfo.setStart(cpgPosListInRegion.get(i) - 1);
                                                bedGraphInfo.setEnd(cpgPosListInRegion.get(i));
                                                if (metric.equals("Cov")) {
                                                    bedGraphInfo.setCov(nReads);
                                                    this.bufferedWriterCov.write(bedGraphInfo.printCov());
                                                }
                                                if (!metric.equals("MM")) break block49;
                                                Double MM = mRead.doubleValue() / nReads.doubleValue();
                                                if (MM.isNaN() || MM.isInfinite()) break block48;
                                                bedGraphInfo.setMM(Float.valueOf(MM.floatValue()));
                                                this.bufferedWriterMM.write(bedGraphInfo.printMM());
                                            }
                                            if (!metric.equals("PDR")) break block50;
                                            Double PDR = nDR.doubleValue() / K4plus.doubleValue();
                                            if (PDR.isNaN() || PDR.isInfinite()) break block48;
                                            bedGraphInfo.setPDR(Float.valueOf(PDR.floatValue()));
                                            this.bufferedWriterPDR.write(bedGraphInfo.printPDR());
                                        }
                                        if (!metric.equals("CHALM")) break block51;
                                        Double CHALM = nMR.doubleValue() / K4plus.doubleValue();
                                        if (CHALM.isNaN() || CHALM.isInfinite()) break block48;
                                        bedGraphInfo.setCHALM(Float.valueOf(CHALM.floatValue()));
                                        this.bufferedWriterCHALM.write(bedGraphInfo.printCHALM());
                                    }
                                    if (!metric.equals("MHL")) break block52;
                                    Double temp = 0.0;
                                    Integer w = 0;
                                    for (int j = this.args.getMinK() - 1; j < this.args.getMaxK(); ++j) {
                                        Integer row = j - this.args.getMinK() + 1;
                                        Integer methKmers = methKmersList[row][start + i];
                                        Integer totalKmers = totalKmersList[row][start + i];
                                        if (totalKmers < 1) continue;
                                        temp = temp + methKmers.doubleValue() / totalKmers.doubleValue() * (double)(j + 1);
                                        w = w + (j + 1);
                                    }
                                    Double MHL = temp / (double)w.intValue();
                                    if (MHL.isNaN() || MHL.isInfinite()) break block48;
                                    bedGraphInfo.setMHL(Float.valueOf(MHL.floatValue()));
                                    this.bufferedWriterMHL.write(bedGraphInfo.printMHL());
                                }
                                if (!metric.equals("MCR")) break block53;
                                Double MCR = cBase.doubleValue() / tBase.doubleValue();
                                if (MCR.isNaN() || MCR.isInfinite()) break block48;
                                bedGraphInfo.setMCR(Float.valueOf(MCR.floatValue()));
                                this.bufferedWriterMCR.write(bedGraphInfo.printMCR());
                            }
                            if (!metric.equals("MBS")) break block54;
                            Double mbsNum = mbsNumList[start + i];
                            Double MBS = mbsNum / (double)K4plus.intValue();
                            if (MBS.isNaN() || MBS.isInfinite()) break block48;
                            bedGraphInfo.setMBS(Float.valueOf(MBS.floatValue()));
                            this.bufferedWriterMBS.write(bedGraphInfo.printMBS());
                        }
                        if (!metric.equals("Entropy")) break block55;
                        Integer kmerAll = kmerAllList[start + i];
                        if (kmerAll < 1) break block48;
                        Double temp = 0.0;
                        for (int j = 0; j < this.args.getK() * this.args.getK(); ++j) {
                            if (kmerList[j][i] <= 0) continue;
                            Integer cnt = kmerList[j][start + i];
                            temp = temp + cnt.doubleValue() / kmerAll.doubleValue() * Math.log(cnt.doubleValue() / kmerAll.doubleValue()) / Math.log(2.0);
                        }
                        Double entropy = -1.0 / this.args.getK().doubleValue() * temp;
                        if (entropy.isNaN() || entropy.isInfinite()) break block48;
                        bedGraphInfo.setEntropy(Float.valueOf(entropy.floatValue()));
                        this.bufferedWriterEntropy.write(bedGraphInfo.printEntropy());
                    }
                    if (metric.equals("R2")) {
                        Double r2Sum = 0.0;
                        Double r2Num = 0.0;
                        for (int j = i - 2; j < i + 3; ++j) {
                            if (j < 0 || j == i || j >= cpgPosListInRegion.size()) continue;
                            Integer index = j - i > 0 ? j - i + 1 : j - i + 2;
                            Integer N00 = N00List[index][start + i];
                            Integer N01 = N01List[index][start + i];
                            Integer N10 = N10List[index][start + i];
                            Integer N11 = N11List[index][start + i];
                            if (N00 + N01 + N10 + N11 < this.args.getR2Cov()) continue;
                            Double r2 = 0.0;
                            Double pvalue = 0.0;
                            Double N = (double)(N00 + N01 + N10 + N11) + 0.0;
                            if (N == 0.0) {
                                r2 = Double.NaN;
                                pvalue = Double.NaN;
                            }
                            Double PA = (double)(N10 + N11) / N;
                            Double PB = (double)(N01 + N11) / N;
                            Double D = (double)N11.intValue() / N - PA * PB;
                            Double Num = D * D;
                            Double Den = PA * (1.0 - PA) * PB * (1.0 - PB);
                            if (Den == 0.0) {
                                r2 = Double.NaN;
                            } else {
                                r2 = Num / Den;
                                if (D < 0.0) {
                                    r2 = -1.0 * r2;
                                }
                            }
                            if (r2.isNaN()) continue;
                            Double d = r2Num;
                            Double d2 = r2Num = Double.valueOf(r2Num + 1.0);
                            r2Sum = r2Sum + r2;
                        }
                        Double meanR2 = r2Sum / r2Num;
                        if (!meanR2.isNaN() && !meanR2.isInfinite()) {
                            bedGraphInfo.setR2(Float.valueOf(meanR2.floatValue()));
                            this.bufferedWriterR2.write(bedGraphInfo.printR2());
                        }
                    }
                }
                Integer n = i;
                Integer n21 = i = Integer.valueOf(i + 1);
            }
        }
        return true;
    }
}

