/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.EnrichmentPlotArgs;
import com.bean.Region;
import com.common.Util;
import com.common.bigwigTool.BBFileReader;
import com.common.bigwigTool.BigWigIterator;
import com.common.bigwigTool.WigItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLabelLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentPlot {
    public static final Logger log = LoggerFactory.getLogger(EnrichmentPlot.class);
    EnrichmentPlotArgs args = new EnrichmentPlotArgs();
    Util util = new Util();

    public void enrichmentPlot(EnrichmentPlotArgs enrichmentPlotArgs) throws Exception {
        Integer width;
        log.info("EnrichmentPlot start!");
        this.args = enrichmentPlotArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        List<Region> openChromatin = this.util.getBedRegionList(this.args.getOpenChromatin());
        if (openChromatin.size() < 1) {
            log.info("The openChromatin is null, please check.");
            return;
        }
        String[] bedPaths = this.args.getBedPaths().split(" ");
        BBFileReader reader = new BBFileReader(this.args.getBigwig());
        DefaultXYDataset xyDataset = new DefaultXYDataset();
        for (String bedPath : bedPaths) {
            double[] totalLengthArray = new double[this.args.getGroupNum().intValue()];
            double[] coverLengthArray = new double[this.args.getGroupNum().intValue()];
            double[] regionNumArray = new double[this.args.getGroupNum().intValue()];
            String bedFileName = new File(bedPath).getName();
            String bedFileLabel = bedFileName.substring(0, bedFileName.lastIndexOf("."));
            List<Region> regionList = this.util.getBedRegionList(bedPath);
            if (regionList.size() < 1) {
                log.info("The bed file:" + bedPath + " is null, please check.");
                continue;
            }
            for (Region region : regionList) {
                BigWigIterator iter = reader.getBigWigIterator(region.getChrom(), region.getStart(), region.getChrom(), region.getEnd(), true);
                Double sumInRegion = 0.0;
                Integer numInRegion = 0;
                while (iter.hasNext()) {
                    WigItem wigItem = iter.next();
                    sumInRegion = sumInRegion + (double)wigItem.getWigValue();
                    Integer n = numInRegion;
                    Integer n2 = numInRegion = Integer.valueOf(numInRegion + 1);
                }
                Double average = sumInRegion / (double)numInRegion.intValue();
                Integer groupIndex = (int)(average >= 1.0 ? (double)(this.args.getGroupNum() - 1) : average * (double)this.args.getGroupNum().intValue());
                Integer regionLength = region.getEnd() - region.getStart() + 1;
                Integer coverLength = this.getRegionCoverLength(openChromatin, 0, openChromatin.size() - 1, region);
                int n = groupIndex;
                totalLengthArray[n] = totalLengthArray[n] + (double)regionLength.intValue();
                int n3 = groupIndex;
                coverLengthArray[n3] = coverLengthArray[n3] + (double)coverLength.intValue();
                int n4 = groupIndex;
                regionNumArray[n4] = regionNumArray[n4] + 1.0;
            }
            double[][] xyData = new double[2][this.args.getGroupNum().intValue()];
            for (int i = 0; i < this.args.getGroupNum(); ++i) {
                double xAxisPos;
                if (regionNumArray[i] < (double)this.args.getGroupCutoff().intValue()) {
                    xyData[0][i] = Double.NaN;
                    xyData[1][i] = Double.NaN;
                    continue;
                }
                double coverRate = coverLengthArray[i] / totalLengthArray[i] * 100.0;
                xyData[0][i] = xAxisPos = (double)(i + 1) / (double)this.args.getGroupNum().intValue() - 1.0 / (double)(this.args.getGroupNum() * 2);
                xyData[1][i] = coverRate;
            }
            xyDataset.addSeries((Comparable)((Object)bedFileLabel), xyData);
        }
        Integer height = width = Integer.valueOf(1000);
        JFreeChart jfreechart = this.generateLinePlot(xyDataset, width);
        String outputFilename = "";
        if (this.args.getOutFormat().equals("png")) {
            outputFilename = this.args.getTag() + ".enrichmentPlot.png";
            this.util.saveAsPng(jfreechart, outputFilename, width, height);
        } else {
            outputFilename = this.args.getTag() + ".enrichmentPlot.pdf";
            this.util.saveAsPdf(jfreechart, outputFilename, width, height);
        }
        log.info("EnrichmentPlot end!");
    }

    private boolean checkArgs() {
        if (this.args.getBigwig() == null || this.args.getBigwig().equals("")) {
            log.error("The bigwig file can not be null.");
            return false;
        }
        if (this.args.getBedPaths() == null || this.args.getBedPaths().equals("")) {
            log.error("The bed file can not be null.");
            return false;
        }
        if (this.args.getOpenChromatin() == null || this.args.getOpenChromatin().equals("")) {
            log.error("The open chromatin file can not be null.");
            return false;
        }
        if (this.args.getTag() == null || this.args.getTag().equals("")) {
            log.error("The tag can not be null.");
            return false;
        }
        return true;
    }

    private Integer getRegionCoverLength(List<Region> regionList, Integer start, Integer end, Region target) {
        if (start <= end) {
            Integer middle = (start + end) / 2;
            Region middleRegion = regionList.get(middle);
            if (target.getChrom().equals(middleRegion.getChrom())) {
                if (target.getEnd() < middleRegion.getStart()) {
                    return this.getRegionCoverLength(regionList, start, middle - 1, target);
                }
                if (target.getStart() > middleRegion.getEnd()) {
                    return this.getRegionCoverLength(regionList, middle + 1, end, target);
                }
                Integer coverStart = middleRegion.getStart() > target.getStart() ? middleRegion.getStart() : target.getStart();
                Integer coverEnd = middleRegion.getEnd() > target.getEnd() ? target.getEnd() : middleRegion.getEnd();
                return coverEnd - coverStart + 1;
            }
            if (target.getChrom().compareTo(middleRegion.getChrom()) < 0) {
                return this.getRegionCoverLength(regionList, start, middle - 1, target);
            }
            return this.getRegionCoverLength(regionList, middle + 1, end, target);
        }
        return 0;
    }

    private JFreeChart generateLinePlot(XYDataset dataset, Integer width) {
        String bigwigName = new File(this.args.getBigwig()).getName();
        String title = bigwigName.substring(0, bigwigName.lastIndexOf("."));
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(title, "", "", dataset, PlotOrientation.VERTICAL, true, true, false);
        TextTitle textTitle = new TextTitle(title, new Font("", 0, width / 25));
        jFreeChart.setTitle(textTitle);
        LegendTitle legendTitle = jFreeChart.getLegend();
        legendTitle.setBorder(0.0, 0.0, 0.0, 0.0);
        legendTitle.setItemFont(new Font("", 0, width / 40));
        XYPlot xyPlot = (XYPlot)jFreeChart.getPlot();
        xyPlot.setBackgroundPaint(Color.WHITE);
        xyPlot.setRangeGridlinesVisible(false);
        xyPlot.setOutlinePaint(Color.BLACK);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setDefaultShapesVisible(false);
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            renderer.setSeriesStroke(i, new BasicStroke(width / 200));
        }
        xyPlot.setRenderer(renderer);
        NumberAxis xAxis = new NumberAxis();
        xAxis.setLabel("Mean signal");
        xAxis.setLabelLocation(AxisLabelLocation.MIDDLE);
        xAxis.setLabelFont(new Font("", 0, width / 30));
        xAxis.setTickLabelFont(new Font("", 0, width / 40));
        xAxis.setTickUnit(new NumberTickUnit(0.1));
        xAxis.setRange(new Range(0.0, 1.0));
        xAxis.setTickMarksVisible(false);
        xAxis.setAxisLineVisible(false);
        xyPlot.setDomainAxis(xAxis);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("The percentage of genomic features (%)");
        yAxis.setLabelFont(new Font("", 0, width / 30));
        yAxis.setTickUnit(new NumberTickUnit(20.0));
        yAxis.setTickLabelFont(new Font("", 0, width / 40));
        yAxis.setRange(new Range(0.0, 100.0));
        yAxis.setTickMarksVisible(false);
        yAxis.setAxisLineVisible(false);
        xyPlot.setRangeAxis(yAxis);
        return jFreeChart;
    }
}

