/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.ConvertArgs;
import com.bean.MHapInfo;
import com.bean.Region;
import com.bean.RegionType;
import com.bean.StrandType;
import com.common.Util;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.bed.BEDCodec;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convert {
    public static final Logger log = LoggerFactory.getLogger(Convert.class);
    ConvertArgs args = new ConvertArgs();
    Util util = new Util();
    public RegionType regionType;
    public File inputFile;

    public void convert(ConvertArgs convertArgs) throws Exception {
        log.info("command.Convert start!");
        this.args = convertArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        boolean initResult = this.initData();
        if (!initResult) {
            log.error("InitData fail, please check the command.");
            return;
        }
        String mhapFileName = "";
        mhapFileName = this.args.getOutPutFile() == null || this.args.getOutPutFile().equals("") ? "out.mhap" : this.args.getOutPutFile().substring(0, this.args.getOutPutFile().length() - 3);
        BufferedWriter bufferedWriter = this.util.createOutputFile("", mhapFileName);
        if (this.args.isPat()) {
            boolean convertPatResult = this.convertPat(bufferedWriter);
            if (!convertPatResult) {
                log.error("convertPat fail, please check the command.");
                return;
            }
        } else {
            boolean convertBamResult = this.convertBam(bufferedWriter);
            if (!convertBamResult) {
                log.error("convertBam fail, please check the command.");
                return;
            }
        }
        bufferedWriter.close();
        log.info("Start generate .gz file...");
        String gzFileName = mhapFileName + ".gz";
        FileInputStream inputStream = new FileInputStream(mhapFileName);
        BlockCompressedOutputStream outputStream = new BlockCompressedOutputStream(new File(gzFileName));
        byte[] b = new byte[1024];
        int len = ((InputStream)inputStream).read(b);
        while (len > 0) {
            ((OutputStream)outputStream).write(b, 0, len);
            len = ((InputStream)inputStream).read(b);
        }
        ((InputStream)inputStream).close();
        ((OutputStream)outputStream).close();
        new File(mhapFileName).delete();
        log.info("command.Convert end! ");
    }

    private boolean convertBam(BufferedWriter bufferedWriter) throws Exception {
        boolean getWholeFileDataResult;
        if (this.regionType == RegionType.SINGLE_REGION) {
            Region region = this.util.parseRegion(this.args.getRegion());
            boolean getSingleRegionDataResult = this.getSingleRegionData(region, bufferedWriter);
            if (!getSingleRegionDataResult) {
                log.error("getSingleRegionData fail, please check the command.");
                return false;
            }
        } else if (this.regionType == RegionType.WHOLE_FILE) {
            boolean getWholeFileDataResult2 = this.getWholeFileData(bufferedWriter);
            if (!getWholeFileDataResult2) {
                log.error("getWholeFileData fail, please check the command.");
                return false;
            }
        } else if (this.regionType == RegionType.MULTI_REGION && !(getWholeFileDataResult = this.getMultiRegionData(bufferedWriter))) {
            log.error("getWholeFileData fail, please check the command.");
            return false;
        }
        return true;
    }

    private boolean convertPat(BufferedWriter bufferedWriter) throws Exception {
        ArrayList<Integer> cpgPosList = new ArrayList<Integer>();
        TabixReader tabixReader = new TabixReader(this.args.getCpgPath());
        String cpgLine = tabixReader.readLine();
        while (cpgLine != null && !cpgLine.equals("")) {
            if (cpgLine.split("\t").length < 3) continue;
            cpgPosList.add(Integer.valueOf(cpgLine.split("\t")[1]));
            cpgLine = tabixReader.readLine();
        }
        log.info("Read cpg reference file: " + this.args.getCpgPath() + " end.");
        FileInputStream fileInputStream = new FileInputStream(this.args.getInputFile());
        GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(gzipInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String patLine = "";
        long completeLine = 0L;
        while ((patLine = bufferedReader.readLine()) != null && !patLine.equals("")) {
            if (++completeLine % 1000000L == 0L) {
                log.info("Complete convert pat file " + completeLine + " lines.");
            }
            if (patLine == null || patLine.split("\t").length < 4) continue;
            String thisChrom = patLine.split("\t")[0];
            Integer startLine = Integer.valueOf(patLine.split("\t")[1]);
            String cpgInfo = patLine.split("\t")[2];
            Integer readNum = Integer.valueOf(patLine.split("\t")[3]);
            if (cpgInfo.contains(".")) continue;
            Integer startPos = (Integer)cpgPosList.get(startLine - 1);
            Integer endPos = (Integer)cpgPosList.get(startLine + cpgInfo.length() - 2);
            String cpgStr = "";
            for (char cpg : cpgInfo.toCharArray()) {
                if (cpg == 'C') {
                    cpgStr = cpgStr + "1";
                    continue;
                }
                if (cpg != 'T') continue;
                cpgStr = cpgStr + "0";
            }
            bufferedWriter.write(thisChrom + "\t" + startPos + "\t" + endPos + "\t" + cpgStr + "\t" + readNum + "\t+\n");
        }
        return true;
    }

    private boolean checkArgs() {
        if (this.args.getInputFile().isEmpty() || this.args.getCpgPath().isEmpty()) {
            log.error("Please specify -i and -c options.");
            return false;
        }
        if (this.args.getMode() != "BS" && this.args.getMode() != "TAPS") {
            log.error("opt error: -m should be specified as BS or TAPS.");
            return false;
        }
        if (!this.args.getCpgPath().isEmpty() && !this.args.getCpgPath().endsWith(".gz")) {
            log.error("-c opt should be followed by a .gz file.");
            return false;
        }
        if (!this.args.getOutPutFile().isEmpty() && !this.args.getOutPutFile().endsWith(".mhap.gz")) {
            log.error("-o opt should be followed by a .mhap.gz file.");
            return false;
        }
        if (!this.args.getBedPath().isEmpty() && !this.args.getBedPath().endsWith(".bed")) {
            log.error("-b opt should be followed by a .bed file.");
            return false;
        }
        return true;
    }

    private boolean initData() {
        if (this.args.getRegion() != null && !this.args.getRegion().isEmpty()) {
            this.regionType = RegionType.SINGLE_REGION;
        } else if (this.args.getBedPath() != null && !this.args.getBedPath().isEmpty()) {
            this.regionType = RegionType.MULTI_REGION;
        } else if (this.args.getInputFile() != null && !this.args.getInputFile().isEmpty() && this.args.getCpgPath() != null && !this.args.getCpgPath().isEmpty()) {
            this.regionType = RegionType.WHOLE_FILE;
        } else {
            return false;
        }
        this.inputFile = new File(this.args.getInputFile());
        if (this.inputFile == null || !this.inputFile.exists()) {
            log.error("The sam/bam file do not exist.");
            return false;
        }
        return true;
    }

    private boolean getWholeFileData(BufferedWriter bufferedWriter) throws Exception {
        SamReader samReader = SamReaderFactory.makeDefault().open(this.inputFile);
        SAMFileHeader samFileHeader = samReader.getFileHeader();
        List<SAMSequenceRecord> samFileHeaderList = samFileHeader.getSequenceDictionary().getSequences();
        for (int i = 0; i < samFileHeaderList.size(); ++i) {
            SAMSequenceRecord samSequenceRecord = samFileHeaderList.get(i);
            Region region = new Region();
            region.setChrom(samSequenceRecord.getSequenceName());
            region.setStart(samSequenceRecord.getStart());
            region.setEnd(samSequenceRecord.getEnd());
            boolean getSingleRegionDataResult = this.getSingleRegionData(region, bufferedWriter);
            if (!getSingleRegionDataResult) {
                log.error("getSingleRegionData fail, please check the command.");
                return false;
            }
            log.info("Convert " + region.getChrom() + " completed!");
        }
        return true;
    }

    private boolean getMultiRegionData(BufferedWriter bufferedWriter) throws Exception {
        File bedFile = new File(this.args.getBedPath());
        FileInputStream inputStream = new FileInputStream(bedFile);
        AsciiLineReader asciiLineReader = new AsciiLineReader(inputStream);
        LineIteratorImpl lineIterator = new LineIteratorImpl(asciiLineReader);
        BEDCodec bedCodec = new BEDCodec();
        while (!bedCodec.isDone(lineIterator)) {
            BEDFeature bedFeature = (BEDFeature)bedCodec.decode(lineIterator);
            Region region = new Region();
            region.setChrom(bedFeature.getContig());
            region.setStart(bedFeature.getStart());
            region.setEnd(bedFeature.getEnd());
            boolean getSingleRegionDataResult = this.getSingleRegionData(region, bufferedWriter);
            if (getSingleRegionDataResult) continue;
            log.info("getSingleRegionData fail, please check the command.");
            return false;
        }
        return true;
    }

    private boolean getSingleRegionData(Region region, BufferedWriter bufferedWriter) throws Exception {
        List<Integer> cpgPosList = this.util.parseCpgFile(this.args.getCpgPath(), region);
        if (cpgPosList.size() < 1) {
            log.info("remove chrome:" + region.getChrom() + " due to the size of cpg is 0.");
            return true;
        }
        Integer cpgStartIndex = 0;
        SamReader samReader = SamReaderFactory.makeDefault().open(this.inputFile);
        SAMRecordIterator samRecordIterator = samReader.query(region.getChrom(), region.getStart(), region.getEnd(), true);
        HashMap<String, MHapInfo> mHapMap = new HashMap<String, MHapInfo>();
        long samCnt = 0L;
        while (samRecordIterator.hasNext()) {
            Integer n;
            SAMRecord samRecord;
            if (++samCnt % 1000000L == 0L) {
                log.info("Read sam/bam " + region.getChrom() + " completed " + samCnt + " reads.");
            }
            if ((samRecord = (SAMRecord)samRecordIterator.next()).getReadLength() == 0) {
                log.error("The read length is 0.");
                continue;
            }
            StrandType strand = StrandType.UNKNOWN;
            if (this.args.isNonDirectional()) {
                strand = StrandType.UNKNOWN;
            } else if (samRecord.getReadPairedFlag() && samRecord.getProperPairFlag()) {
                if (samRecord.getFirstOfPairFlag()) {
                    if (samRecord.getReadNegativeStrandFlag()) {
                        strand = StrandType.MINUS;
                    } else if (samRecord.getMateNegativeStrandFlag()) {
                        strand = StrandType.PLUS;
                    }
                } else if (samRecord.getSecondOfPairFlag()) {
                    if (samRecord.getReadNegativeStrandFlag()) {
                        strand = StrandType.MINUS;
                    } else if (samRecord.getMateNegativeStrandFlag()) {
                        strand = StrandType.PLUS;
                    }
                }
            } else {
                strand = samRecord.getReadNegativeStrandFlag() ? StrandType.MINUS : StrandType.PLUS;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (cpgStartIndex < cpgPosList.size() - 1 && cpgPosList.get(cpgStartIndex) < samRecord.getStart()) {
                Integer n2 = cpgStartIndex;
                n = cpgStartIndex = Integer.valueOf(cpgStartIndex + 1);
            }
            Integer cpgCnt = 0;
            while (cpgStartIndex + cpgCnt < cpgPosList.size() && cpgPosList.get(cpgStartIndex + cpgCnt) < samRecord.getEnd()) {
                arrayList.add(cpgPosList.get(cpgStartIndex + cpgCnt));
                n = cpgCnt;
                Integer n3 = cpgCnt = Integer.valueOf(cpgCnt + 1);
            }
            if (cpgCnt == 0) {
                log.error("remove read:" + samRecord.getReadName() + " due to the size of cpg is 0.");
                continue;
            }
            String haplotype = this.getHaplotype(samRecord, arrayList, cpgCnt, strand);
            if (haplotype.matches(".*[a-zA-z].*")) continue;
            MHapInfo mHapLine = new MHapInfo(region.getChrom(), (Integer)arrayList.get(0), (Integer)arrayList.get(arrayList.size() - 1), haplotype, 1, strand.getStrandFlag());
            if (mHapMap.containsKey(mHapLine.indexByReadAndStrand())) {
                ((MHapInfo)mHapMap.get(mHapLine.indexByReadAndStrand())).setCnt(((MHapInfo)mHapMap.get(mHapLine.indexByReadAndStrand())).getCnt() + 1);
                continue;
            }
            mHapMap.put(mHapLine.indexByReadAndStrand(), mHapLine);
        }
        ArrayList mHapList = new ArrayList(mHapMap.entrySet());
        Collections.sort(mHapList, new Comparator<Map.Entry<String, MHapInfo>>(){

            @Override
            public int compare(Map.Entry<String, MHapInfo> o1, Map.Entry<String, MHapInfo> o2) {
                return o1.getValue().getChrom().compareTo(o2.getValue().getChrom()) + o1.getValue().getStart().compareTo(o2.getValue().getStart()) + o1.getValue().getEnd().compareTo(o2.getValue().getEnd());
            }
        });
        for (Map.Entry entry : mHapList) {
            bufferedWriter.write(((MHapInfo)entry.getValue()).print() + "\n");
        }
        return true;
    }

    private String getHaplotype(SAMRecord samRecord, List<Integer> cpgPosList, Integer cpgCnt, StrandType strand) {
        String haploString = "";
        String readString = samRecord.getReadString();
        for (int i = 0; i < cpgCnt; ++i) {
            Integer pos = 0;
            if (strand == StrandType.UNKNOWN || strand == StrandType.PLUS) {
                if (cpgPosList.get(i) < samRecord.getStart()) continue;
                if (cpgPosList.get(i) > samRecord.getEnd()) break;
                pos = cpgPosList.get(i) - samRecord.getStart();
            } else {
                if (cpgPosList.get(i) < samRecord.getStart() - 1) continue;
                if (cpgPosList.get(i) > samRecord.getEnd() - 1) break;
                pos = cpgPosList.get(i) - samRecord.getStart() + 1;
            }
            if (pos >= samRecord.getReadLength() || pos < 0) continue;
            haploString = haploString + String.valueOf(readString.charAt(pos));
        }
        String haplotype = "";
        for (int i = 0; i < haploString.length(); ++i) {
            if (strand == StrandType.UNKNOWN || strand == StrandType.PLUS) {
                if (haploString.charAt(i) == 'C') {
                    if (this.args.getMode().equals("BS")) {
                        haplotype = haplotype + "1";
                        continue;
                    }
                    haplotype = haplotype + "0";
                    continue;
                }
                if (haploString.charAt(i) == 'T') {
                    if (this.args.getMode().equals("BS")) {
                        haplotype = haplotype + "0";
                        continue;
                    }
                    haplotype = haplotype + "1";
                    continue;
                }
                haplotype = haplotype + haploString.charAt(i);
                log.info("Direction + or * : beg: " + samRecord.getStart() + ", end:" + samRecord.getEnd() + " nucleobases error:" + haplotype);
                continue;
            }
            if (haploString.charAt(i) == 'G') {
                if (this.args.getMode().equals("BS")) {
                    haplotype = haplotype + "1";
                    continue;
                }
                haplotype = haplotype + "0";
                continue;
            }
            if (haploString.charAt(i) == 'A') {
                if (this.args.getMode().equals("BS")) {
                    haplotype = haplotype + "0";
                    continue;
                }
                haplotype = haplotype + "1";
                continue;
            }
            haplotype = haplotype + haploString.charAt(i);
            log.info("Direction - : beg: " + samRecord.getStart() + ", end:" + samRecord.getEnd() + " nucleobases error:" + haplotype);
        }
        return haplotype;
    }
}

