/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.ComputeCpgCovArgs;
import com.bean.Region;
import com.common.Util;
import com.common.bigwigTool.BBFileReader;
import com.common.bigwigTool.BigWigIterator;
import com.common.bigwigTool.WigItem;
import java.io.BufferedWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeCpgCov {
    public static final Logger log = LoggerFactory.getLogger(ComputeCpgCov.class);
    ComputeCpgCovArgs args = new ComputeCpgCovArgs();
    Util util = new Util();

    public void computeCpgCov(ComputeCpgCovArgs ComputeCpgCovArgs2) throws Exception {
        List<Region> bedRegionList;
        log.info("ComputeCpgCov start!");
        this.args = ComputeCpgCovArgs2;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        Map<Object, Object> openChromatinRegionMap = new HashMap();
        if (this.args.getOpenChromatin() != null && !this.args.getOpenChromatin().equals("")) {
            List<Region> openChromatinRegionList = this.util.getBedRegionList(this.args.getOpenChromatin());
            if (openChromatinRegionList.size() < 1) {
                log.info("The openChromatin is null, please check.");
                return;
            }
            openChromatinRegionMap = openChromatinRegionList.stream().collect(Collectors.groupingBy(Region::getChrom));
        }
        if ((bedRegionList = this.util.getBedRegionList(this.args.getBedPath())).size() < 1) {
            log.info("The bed file is null, please check.");
            return;
        }
        BBFileReader reader = new BBFileReader(this.args.getBigwig());
        BBFileReader reader2 = null;
        if (this.args.getChipseqBigwig() != null && !this.args.getChipseqBigwig().equals("")) {
            reader2 = new BBFileReader(this.args.getChipseqBigwig());
        }
        BufferedWriter bufferedWriter = this.util.createOutputFile("", this.args.getTag() + ".txt");
        long totalCnt = bedRegionList.size();
        long completeCnt = 0L;
        for (Region region : bedRegionList) {
            String regionStr;
            WigItem wigItem;
            List<Integer> cpgPosListInRegion;
            if (++completeCnt % (totalCnt / 100L) == 0L) {
                int percent = (int)Math.round(Double.valueOf(completeCnt) * 100.0 / (double)totalCnt);
                log.info("Complete " + percent + "%.");
            }
            if ((cpgPosListInRegion = this.util.parseCpgFile(this.args.getCpgPath(), region)).size() < 1) continue;
            if (this.args.getOpenChromatin() != null && !this.args.getOpenChromatin().equals("")) {
                List openChromatinRegionOfChrom = (List)openChromatinRegionMap.get(region.getChrom());
                if (openChromatinRegionOfChrom == null || openChromatinRegionOfChrom.size() < 1) {
                    log.info("openChromatinRegion in " + region.getChrom() + " is null.");
                    continue;
                }
                for (Integer cpgPos : cpgPosListInRegion) {
                    Integer coverFlag = this.whetherRegionListCoverCpg(openChromatinRegionOfChrom, 0, openChromatinRegionOfChrom.size(), cpgPos);
                    BigWigIterator iter = reader.getBigWigIterator(region.getChrom(), cpgPos - 1, region.getChrom(), cpgPos, true);
                    Double value = 0.0;
                    if (iter.hasNext()) {
                        wigItem = iter.next();
                        value = wigItem.getWigValue();
                    } else if (!this.args.getMissingDataAsZero().booleanValue()) {
                        value = Double.NaN;
                    }
                    regionStr = region.getChrom() + ":" + (cpgPos - 1) + "-" + cpgPos;
                    bufferedWriter.write(regionStr + "\t" + value + "\t" + coverFlag + "\n");
                }
            }
            if (this.args.getChipseqBigwig() == null || this.args.getChipseqBigwig().equals("")) continue;
            for (Integer cpgPos : cpgPosListInRegion) {
                BigWigIterator iter1 = reader.getBigWigIterator(region.getChrom(), cpgPos - 1, region.getChrom(), cpgPos, true);
                Double value1 = 0.0;
                if (iter1.hasNext()) {
                    WigItem wigItem2 = iter1.next();
                    value1 = wigItem2.getWigValue();
                } else if (!this.args.getMissingDataAsZero().booleanValue()) {
                    value1 = Double.NaN;
                }
                BigWigIterator iter2 = reader2.getBigWigIterator(region.getChrom(), cpgPos - 1, region.getChrom(), cpgPos, true);
                Double value2 = 0.0;
                if (iter2.hasNext()) {
                    wigItem = iter2.next();
                    value2 = wigItem.getWigValue();
                } else if (!this.args.getMissingDataAsZero().booleanValue()) {
                    value2 = Double.NaN;
                }
                regionStr = region.getChrom() + ":" + (cpgPos - 1) + "-" + cpgPos;
                bufferedWriter.write(regionStr + "\t" + value1 + "\t" + value2 + "\n");
            }
        }
        bufferedWriter.close();
        log.info("ComputeCpgCov end!");
    }

    private boolean checkArgs() {
        if (this.args.getBigwig() == null || this.args.getBigwig().equals("")) {
            log.error("The bigwig file can not be null.");
            return false;
        }
        if (this.args.getCpgPath() == null || this.args.getCpgPath().equals("")) {
            log.error("cpgPath can not be null.");
            return false;
        }
        if (this.args.getBedPath() == null || this.args.getBedPath().equals("")) {
            log.error("The bed file can not be null.");
            return false;
        }
        if (this.args.getTag() == null || this.args.getTag().equals("")) {
            log.error("The tag can not be null.");
            return false;
        }
        return true;
    }

    private Integer whetherRegionListCoverCpg(List<Region> regionList, Integer start, Integer end, Integer target) {
        if (start <= end) {
            Integer middle = (start + end) / 2;
            Region middleRegion = regionList.get(middle);
            if (target < middleRegion.getStart()) {
                if (middle < 0) {
                    return 0;
                }
                return this.whetherRegionListCoverCpg(regionList, start, middle - 1, target);
            }
            if (target >= middleRegion.getStart()) {
                if (target <= middleRegion.getEnd()) {
                    return 1;
                }
                if (middle >= regionList.size() - 1) {
                    return 0;
                }
                return this.whetherRegionListCoverCpg(regionList, middle + 1, end, target);
            }
        }
        return 0;
    }
}

