/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.args.BoxPlotArgs;
import com.bean.Region;
import com.common.Util;
import com.common.bigwigTool.BBFileReader;
import com.common.bigwigTool.BigWigIterator;
import com.common.bigwigTool.WigItem;
import com.rewrite.CustomBoxAndWhiskerRenderer;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.Range;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxPlot {
    public static final Logger log = LoggerFactory.getLogger(BoxPlot.class);
    BoxPlotArgs args = new BoxPlotArgs();
    Util util = new Util();
    public static final Integer MAXSIZE = 10000;
    public static final Integer MAXSAMPLE = 20;

    public void boxPlot(BoxPlotArgs boxPlotArgs) throws Exception {
        log.info("BoxPlot start!");
        this.args = boxPlotArgs;
        boolean checkResult = this.checkArgs();
        if (!checkResult) {
            log.error("Checkargs fail, please check the command.");
            return;
        }
        List<Region> regionList = this.util.getBedRegionList(this.args.getBedPath());
        if (regionList.size() < 1) {
            log.error("The bed file is null, please check.");
            return;
        }
        String[] bigwigs = this.args.getBigwigs().split(" ");
        if (bigwigs.length > MAXSAMPLE) {
            log.error("The input bigwid files is larger than " + MAXSAMPLE + ", please re-enter the bigwigs");
            return;
        }
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (String bigwig : bigwigs) {
            ArrayList<Double> averageList = new ArrayList<Double>();
            for (Region region : regionList) {
                String startChr = region.getChrom();
                Integer startBase = region.getStart();
                String endChr = region.getChrom();
                Integer endBase = region.getEnd();
                double sumInRegion = 0.0;
                BBFileReader reader = new BBFileReader(bigwig);
                BigWigIterator iter = reader.getBigWigIterator(startChr, startBase, endChr, endBase, true);
                Integer index = 0;
                while (iter.hasNext()) {
                    WigItem wigItem = iter.next();
                    sumInRegion += (double)wigItem.getWigValue();
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                }
                reader.close();
                Double average = sumInRegion / (double)index.intValue();
                averageList.add(average);
            }
            String bigwigName = new File(bigwig).getName();
            dataset.add(averageList, (Comparable)((Object)""), (Comparable)((Object)bigwigName.substring(0, bigwigName.lastIndexOf("."))));
            log.info("Process " + bigwig + " end!");
        }
        Integer width = bigwigs.length * 250;
        width = width > 14400 ? 14400 : (width < 1000 ? 1000 : width);
        Integer height = 1000;
        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        xAxis.setTickLabelFont(new Font("", 0, width / 50));
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("Value");
        yAxis.setLabelFont(new Font("", 0, width / 40));
        yAxis.setLowerMargin(0.01);
        yAxis.setUpperMargin(0.01);
        yAxis.setRange(new Range(0.0, 1.0));
        yAxis.setTickUnit(new NumberTickUnit(0.1));
        yAxis.setTickLabelFont(new Font("", 0, width / 50));
        CustomBoxAndWhiskerRenderer renderer = new CustomBoxAndWhiskerRenderer();
        renderer.setFillBox(false);
        renderer.setMaxOutlierVisible(false);
        renderer.setMinOutlierVisible(false);
        renderer.setMaximumBarWidth(1.0 / Double.valueOf(bigwigs.length) / 2.0);
        renderer.setMeanVisible(false);
        renderer.setDefaultToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);
        String bedName = new File(this.args.getBedPath()).getName();
        JFreeChart jfreechart = new JFreeChart(bedName.substring(0, bedName.lastIndexOf(".")), new Font("", 1, width / 40), plot, false);
        jfreechart.setBackgroundPaint(Color.WHITE);
        String outputFilename = "";
        if (this.args.getOutFormat().equals("png")) {
            outputFilename = this.args.getTag() + ".boxPlot.png";
            this.util.saveAsPng(jfreechart, outputFilename, width, height);
        } else {
            outputFilename = this.args.getTag() + ".boxPlot.pdf";
            this.util.saveAsPdf(jfreechart, outputFilename, width, height);
        }
        log.info("BoxPlot end!");
    }

    private boolean checkArgs() {
        if (this.args.getBedPath() == null || this.args.getBedPath().equals("")) {
            log.error("The input bed file can not be null.");
            return false;
        }
        if (this.args.getBigwigs() == null || this.args.getBigwigs().equals("")) {
            log.error("The bigwig files can not be null.");
            return false;
        }
        if (this.args.getTag() == null || this.args.getTag().equals("")) {
            log.error("The tag can not be null.");
            return false;
        }
        if (!this.args.getOutFormat().equals("png") && !this.args.getOutFormat().equals("pdf")) {
            log.error("The output format must be pdf or png");
            return false;
        }
        return true;
    }
}

