import os
import subprocess as sp


src_dir= os.path.dirname(os.path.realpath(__file__))

def postalign( args ):
	print("Post alignment filtering");
	ibam=args.bam
	obam=args.obam
	nUmap=args.umap if args.umap>0 else 0;
	bRealign=args.realign
	strDedup=args.dedup

	nMaxsoftclip5=args.maxsoftclip5
	nMaxsoftclip3=args.maxsoftclip3
	nThread=args.thread

	if bRealign:
		starref=args.starindex;
		reffa=args.refgenome
		
		if starref=="" or reffa=="":
			print("--starindex and --refgenome should be assigned" )
			return -1;

		process=sp.Popen(['bash', src_dir+'/postalign.sh', ibam, obam, str(nUmap), "1", strDedup, str(nMaxsoftclip5), str(nMaxsoftclip3), str(nThread), starref, reffa]);
		process.wait();
	else:
		process=sp.Popen(['bash', src_dir+'/postalign.sh', ibam, obam, str(nUmap), "0", strDedup, str(nMaxsoftclip5), str(nMaxsoftclip3), str(nThread)]);
		process.wait();

	print("---Completed")









