iMM2bam=$1
odir=$2
nReadCutoff=$3

iMM2bam_fname=${iMM2bam##*/}

odir=$odir/mm2_read_gtf
mkdir $odir

#3) Prepare GTF for STAR realignment
##Each line is two-exon and one-intron gtf
bedtools bamtobed -bed12 -i $iMM2bam > $odir/${iMM2bam_fname%.bam}".bed12"
awk -v OFS='\t' '$10==1{ print $1,$2,$3,$4,$5,$6,"single";}' $odir/${iMM2bam_fname%.bam}".bed12" > $odir/${iMM2bam_fname%.bam}".single.exon.annot.bed"
awk -v OFS='\t' '$10>1' $odir/${iMM2bam_fname%.bam}".bed12" | bedtools bed12tobed6 -i stdin > $odir/${iMM2bam_fname%.bam}".multi.exon.bed"
python /script/AnnotateExonNumber.py $odir/${iMM2bam_fname%.bam}".multi.exon.bed" $odir/${iMM2bam_fname%.bam}".bed12" $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed"
rm $odir/${iMM2bam_fname%.bam}".bed12"


#Output non-inner exon for candidate search
awk -v OFS='\t' '$7!="Inner"' $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed" | cat $odir/${iMM2bam_fname%.bam}".single.exon.annot.bed" - > $odir/${iMM2bam_fname%.bam}".mm2_outerexon.annot.bed" 


##Prepare confident set of exon/intron
nTotalExonCnt=$(wc -l $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed" | cut -d' ' -f1)
nRowHeight=$((nTotalExonCnt-1))
head -n $nRowHeight $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed" > $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed.left"
tail -n $nRowHeight $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed" > $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed.right"
paste -d'\t' $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed.left" $odir/${iMM2bam_fname%.bam}".multi.exon.annot.bed.right" | awk -v OFS='\t' '$4==$11{ print $0,$1"_"$3"_"$9"_"$6; }' > $odir/${iMM2bam_fname%.bam}".mm2_multiexon.combined"
rm $odir/${iMM2bam_fname%.bam}".multi.bed12" $odir/${iMM2bam_fname%.bam}".multi.exon.bed.left" $odir/${iMM2bam_fname%.bam}".multi.exon.bed.right" $odir/${iMM2bam_fname%.bam}".mm2_multiexon.bed"

awk -v OFS='\t' '{ print $1,$3,$9,"intron",".",$6,$15; }' $odir/${iMM2bam_fname%.bam}".mm2_multiexon.combined" | sort -k1,1 -V -k2,2n | uniq -c | awk -v OFS='\t' '{ print $2,$3,$4,$5,$1,$7,$8;}' > $odir/${iMM2bam_fname%.bam}".mm2_intron.bed"

#Retain only confident intron and exon.combined
awk -v OFS='\t' -v nReadCutoff=$nReadCutoff '$5>=nReadCutoff' $odir/${iMM2bam_fname%.bam}".mm2_intron.bed" > $odir/${iMM2bam_fname%.bam}".mm2_intron.conf.bed"








