FQ1_trimmed=$1
FQ2_trimmed=$2
REF_STAR=$3
INTRON_CONF=$4
odir=$5
THREAD=$6

FILENAME=${FQ1_trimmed##*/}
STAR_PREF=$odir/${FILENAME%.fq}".star"

#--outSAMattributes Standard + MD 
#--outSAMunmapped Within
#--outFilterMultimapNmax 100
#--outFilterMultimapScoreRange 10 print more multimapped
### error score https://www.nature.com/articles/s41467-019-12575-x
#--seedSearchStartLmax matching minimap2

#convert intron.bed to STAR compatible format
INTRON_FNAME=${INTRON_CONF##*/}
INTRON_CONF_TXT=$odir/${INTRON_FNAME%.bed}".txt"
awk -v OFS='\t' '{ print $1,$2+1,$3,$6; }' $INTRON_CONF > $INTRON_CONF_TXT

STAR --runThreadN $THREAD --runMode alignReads --twopassMode None --chimOutType WithinBAM SoftClip --sjdbFileChrStartEnd $INTRON_CONF_TXT --outSAMattributes NH HI AS nM MD --genomeDir $REF_STAR --outFilterMultimapScoreRange 10 --outFilterMultimapNmax 100 --outFileNamePrefix $STAR_PREF --outSAMtype BAM SortedByCoordinate --scoreDelOpen -1 --scoreDelBase -1 --scoreInsOpen -1 --scoreInsBase -1 --seedSearchStartLmax 15 --readFilesIn $FQ1_trimmed $FQ2_trimmed



