ibam=$1
realnInfo=$2
nReadLength=$3
intron_mm2=$4
REF_STAR=$5
INTRON_CONF=$6
genref=$7
odir=$8

nFragLen=400
nIntronCutoff=3

ibam_fname=${ibam##*/}

##For realign candidate
##1) obtain fastq 
##2) align with STAR
##3) update realign candidate
odir=$odir/STARrealn_PE
obam=$odir/../${ibam_fname%.bam}".realn.bam"
mkdir $odir

#For candidate query sequence with softclip+nOverhang+nLength is trimmed
##For multi-processing, we need to group reads by the softclip length
ibam_fname=${ibam##*/}
bedtools bamtofastq -i $ibam -fq $odir/${ibam_fname%.bam}".fastq"

#Prepare read1
## |------------------------------------>
## |->  |->                       <-| <-|
## AGA  CCG			  GGT AGT
## sc 5 read1: AGA
## sc 5 read2: CGG
## sc 3 read1: GGT
## sc 3 read2: ACT

seqtk trimfq -L $nFragLen $odir/${ibam_fname%.bam}".fastq" > $odir/${ibam_fname%.bam}".5end_"$nFragLen".fastq"
seqtk seq -r $odir/${ibam_fname%.bam}".fastq" | seqtk trimfq -L $nFragLen - > $odir/${ibam_fname%.bam}".3end_rc_"$nFragLen".fastq"

seqtk trimfq -L $nReadLength $odir/${ibam_fname%.bam}".5end_"$nFragLen".fastq" > $odir/${ibam_fname%.bam}".sc5.R1.fastq"
seqtk seq -r $odir/${ibam_fname%.bam}".5end_"$nFragLen".fastq" | seqtk trimfq -L $nReadLength - > $odir/${ibam_fname%.bam}".sc5.R2.fastq"

seqtk trimfq -L $nReadLength $odir/${ibam_fname%.bam}".3end_rc_"$nFragLen".fastq" > $odir/${ibam_fname%.bam}".sc3.R1.fastq"
seqtk seq -r $odir/${ibam_fname%.bam}".3end_rc_"$nFragLen".fastq" | seqtk trimfq -L $nReadLength - > $odir/${ibam_fname%.bam}".sc3.R2.fastq"
rm $odir/${ibam_fname%.bam}".5end_"$nFragLen".fastq"  $odir/${ibam_fname%.bam}".3end_rc_"$nFragLen".fastq"

awk -v OFS='\t' 'NR>1{ if($6=="O"){ print $1; }}' $realnInfo > $odir/${ibam_fname%.bam}".sc5.filter"
seqtk subseq $odir/${ibam_fname%.bam}".sc5.R1.fastq" $odir/${ibam_fname%.bam}".sc5.filter" | awk '{ if(NR%4==1) { gsub(/\//,",",$0); print $0";5end";}else{ print $0; } }' > $odir/${ibam_fname%.bam}".sc5.filt.R1.fastq"
seqtk subseq $odir/${ibam_fname%.bam}".sc5.R2.fastq" $odir/${ibam_fname%.bam}".sc5.filter" | awk '{ if(NR%4==1) { gsub(/\//,",",$0); print $0";5end";}else{ print $0; } }' > $odir/${ibam_fname%.bam}".sc5.filt.R2.fastq"
rm $odir/${ibam_fname%.bam}".sc5.R1.fastq" $odir/${ibam_fname%.bam}".sc5.R2.fastq" $odir/${ibam_fname%.bam}".sc5.filter"


awk -v OFS='\t' 'NR>1{ if($7=="O"){ print $1; }}' $realnInfo > $odir/${ibam_fname%.bam}".sc3.filter"
seqtk subseq $odir/${ibam_fname%.bam}".sc3.R1.fastq" $odir/${ibam_fname%.bam}".sc3.filter" | awk '{ if(NR%4==1) { gsub(/\//,",",$0); print $0";3end";}else{ print $0; } }' > $odir/${ibam_fname%.bam}".sc3.filt.R1.fastq"
seqtk subseq $odir/${ibam_fname%.bam}".sc3.R2.fastq" $odir/${ibam_fname%.bam}".sc3.filter" | awk '{ if(NR%4==1) { gsub(/\//,",",$0); print $0";3end";}else{ print $0; } }' > $odir/${ibam_fname%.bam}".sc3.filt.R2.fastq"
rm $odir/${ibam_fname%.bam}".sc3.R1.fastq" $odir/${ibam_fname%.bam}".sc3.R2.fastq" $odir/${ibam_fname%.bam}".sc3.filter"

cat $odir/${ibam_fname%.bam}".sc5.filt.R1.fastq" $odir/${ibam_fname%.bam}".sc3.filt.R1.fastq" > $odir/${ibam_fname%.bam}".realn_SR.R1.fastq"
cat $odir/${ibam_fname%.bam}".sc5.filt.R2.fastq" $odir/${ibam_fname%.bam}".sc3.filt.R2.fastq" > $odir/${ibam_fname%.bam}".realn_SR.R2.fastq"
rm $odir/${ibam_fname%.bam}".sc5.filt.R1.fastq" $odir/${ibam_fname%.bam}".sc3.filt.R1.fastq" $odir/${ibam_fname%.bam}".sc5.filt.R2.fastq" $odir/${ibam_fname%.bam}".sc3.filt.R2.fastq"


iSTARrealn=$odir/${ibam_fname%.bam}".realn_SR.R1.fastq.starAligned.sortedByCoord.out.bam"
bash /script/align_PE.sh $odir/${ibam_fname%.bam}".realn_SR.R1.fastq" $odir/${ibam_fname%.bam}".realn_SR.R2.fastq" $REF_STAR $INTRON_CONF $odir 4
samtools index $iSTARrealn
python /script/ChooseRealn.v6.py $ibam $iSTARrealn $realnInfo $odir/${ibam_fname%.bam}"_unsort.bam"

nTotalTrim=$((nOverhang+nLength))
samtools sort -@ 8 -o $odir/${ibam_fname%.bam}"_sort.bam" $odir/${ibam_fname%.bam}"_unsort.bam"


##Update MD and NM tag based on CIGAR
samtools calmd -b -@ 8 $odir/${ibam_fname%.bam}"_sort.bam" $genref > $obam
samtools index $obam


mv $odir/${ibam_fname%.bam}"_unsort.bam.stat" $odir/${ibam_fname%.bam}".realn_detail.txt"

rm $odir/${ibam_fname%.bam}"_sort.bam" $odir/${ibam_fname%.bam}"_unsort.bam"

