# plot Rhh outputs in histogram fashion

setwd("~/myproject/hetFunctionsCardEtAl/")
Bxyboot <- read.delim("100_boot_reps_Bxy_BenithosSNPsOnly.Mutli.final.txt", header=T)
Mxyboot <- read.delim("100_boot_reps_Mxy_BenithosSNPsOnly.Mutli.final.txt", header=T)

dens_Bxy <- apply(Bxyboot[3:8], 2, density)
dens_Mxy <- apply(Mxyboot[3:8], 2, density)

par(mfrow=c(2,1))

plot(NA, xlim=range(sapply(dens_Bxy, "[", "x")), ylim=range(sapply(dens_Bxy, "[", "y")), xlab="Shared genotypes Bxy", ylab="Density")
mapply(lines, dens_Bxy, col=c("deeppink","darkolivegreen1","darkolivegreen1","darkolivegreen4","darkolivegreen4","darkolivegreen4"))
mapply(polygon, dens_Bxy, col=c("darkgrey","darkgrey","deeppink","darkgrey","deeppink","darkolivegreen1"), border=NA)

plot(NA, xlim=range(sapply(dens_Mxy, "[", "x")), ylim=range(sapply(dens_Mxy, "[", "y")), xlab="Shared loci Mxy", ylab="Density")
mapply(lines, dens_Mxy, col=c("deeppink","darkolivegreen1","darkolivegreen1","darkolivegreen4","darkolivegreen4","darkolivegreen4"))
mapply(polygon, dens_Mxy, col=c("darkgrey","darkgrey","deeppink","darkgrey","deeppink","darkolivegreen1"), border=NA)
legend("topright", legend=c("wildI","mother","child1","child2"), fill=c("darkgrey","deeppink","darkolivegreen1","darkolivegreen4"))






