#!/usr/bin/env Rscript

args=commandArgs(trailingOnly=TRUE)
setwd(args[1])
library(Demerelate)
library(Rhh)

boot_related <- function(data, method, reps) {
  print("Bootstrap replicate #1")
  initial <- Emp.calc(data, method)
  colnames(initial) <- NULL
  out <- cbind(data.frame(method=method, rep=1), t(initial))
  nloci <- ((ncol(data))/2)-1 ##fixed here!
  for (rep in 2:reps) {
    print(paste0("Bootstrap replicate #", rep))
    j <- numeric(2 * nloci)
    random <- sample(seq(1, nloci, 2), nloci, replace=TRUE) 
    for (i in 1:length(random)) {
      j[2*i-1] <- random[i]
      j[2*i] <- random[i]+1
    }
    initial <- Emp.calc((cbind(data[,c(1,2)], data[,c(-1,-2)][,j])), method)
    colnames(initial) <- NULL
    row <- data.frame(method, rep, t(initial))
    out <- rbind(out, row)
  }
  return(out)
}

my_thinped<-read.delim(args[2], stringsAsFactors=FALSE, header=T, sep="\t", colClasses = "character")

my_thinped$Sample_ID[1]<-"Unr_Indv"
my_thinped$Sample_ID[2]<-"Mother"
my_thinped$Sample_ID[3]<-"Child1"
my_thinped$Sample_ID[4]<-"Child2"

my_indIDs<-my_thinped[,1]
my_popIDs<-my_thinped[,2]
my_genotypes<-my_thinped[,3:ncol(my_thinped)]

chkdata(my_genotypes)

allcalcs_demrelate<-Emp.calc(my_thinped)
write.table(allcalcs_demrelate, args[3], col.names = T, row.names = F, quote = F, sep = "\t")

# bootstrap Bxy and Mxy
boot_reps_Bxy<-boot_related(my_thinped, "Bxy", 100)
boot_reps_Mxy<-boot_related(my_thinped, "Mxy", 100)

write.table(boot_reps_Bxy, args[4], col.names = T, row.names = F, quote = F, sep = "\t")
write.table(boot_reps_Mxy, args[5], col.names = T, row.names = F, quote = F, sep = "\t")