#!/usr/bin/env Rscript

library(vcfR)

setwd("~/myproject/genotypesharing")
testvcf<-read.vcfR("~/myproject/filter/BenithosSNPsOnlyMulti.final.NoUNP.vcf.gz")
testvcf<-extract.gt(testvcf)
testvcf<-as.data.frame(testvcf)
testvcf <- data.frame(apply(testvcf, 2, function(x) {gsub("/", "|", x)}))
testvcf<-t(testvcf)
testvcf<-sub("\\|", " ", testvcf)

row.names(testvcf)<-c("WildI pop1", "Mother pop1", "child1 pop1", "child2  pop1")
write.table(testvcf, file="temp.txt", sep=" ", row.names = T, col.names = F, quote = F)

# generate header row for demerelate
df<-as.data.frame(rep(colnames(testvcf), each=2))
andb<-c("_a", "_b")
df$locus<-rep(andb, nrow(df)/2)
df$finalheaderrow<-paste(df$`rep(colnames(testvcf), each = 2)`, df$locus, sep="")
remove(testvcf)
testvcf2 <- read.table("temp.txt", quote="\"", comment.char="")
colnames(testvcf2)<-c("Sample_ID", "population", df$finalheaderrow)
testvcf3<-data.frame(testvcf2[1:2],testvcf2[, 3:ncol(testvcf2)] + 1)

write.table(testvcf3, "BenithosSNPsOnly.Multi.final.DemeIn.txt", append = FALSE, sep = "\t",
            row.names = FALSE, col.names = TRUE, quote = FALSE)

