#!/bin/bash

module load gatk/4.1.4.1
module load vcftools
module load bcftools
module load htslib/1.10.2


cd ~/mydirectory/filter

###########################################################################
##remove spanning deletions
###########################################################################
echo "start removing spanning deletions"
bcftools view -e 'ALT="*"' SelectedVariantsFiltered_tmp7.vcf.gz -o BenithosSNPsOnlyMulti.final | bgzip -c BenithosSNPsOnlyMulti.final > BenithosSNPsOnlyMulti.final.vcf.gz
echo "done removing spanning deletions"

###########################################################################
##remove UNPLACED
###########################################################################
echo "start removing UNPLACED"
vcftools --gzvcf BenithosSNPsOnlyMulti.final.vcf.gz \
--not-chr UNPLACED \
--recode --recode-INFO-all --stdout | bgzip -c > BenithosSNPsOnlyMulti.final.NoUNP.vcf.gz
echo "done removing UNPLACED"

rm SelectedVariantsFiltered_tmp7.vcf.gz