#!/bin/bash

module load vcftools/0.1.16
module load bcftools/1.10.2

mkdir  ~/mydirectory/vcftools
cd  ~/mydirectory/vcftools

#index vcf
bcftools index  ~/mydirectory/filter/BenithosAllSites.final.NoUNP.vcf.gz

SUBSET_VCF= ~/mydirectory/filter/BenithosAllSites.final.NoUNP.vcf.gz
OUT=BenithosAllSites.final.NoUNP_vcftools

# Calculate the allele frequency for each variant. 
vcftools --gzvcf $SUBSET_VCF --freq2 --out freq2_$OUT --max-alleles 2

# Mean depth of coverage per individual
vcftools --gzvcf $SUBSET_VCF --depth --out depth_$OUT

# Mean depth of coverage for each site
vcftools --gzvcf $SUBSET_VCF --site-mean-depth --out site_meandepth_$OUT

# Extract the site quality score for each site
vcftools --gzvcf $SUBSET_VCF --site-quality --out quality_$OUT

# Calculate the proportion of missing data per sample.
vcftools --gzvcf $SUBSET_VCF --missing-indv --out _missing_ind_$OUT

# Missing data per site 
vcftools --gzvcf $SUBSET_VCF --missing-site --out missing_site_$OUT

# Calculate heterozygosity and inbreeding coefficient per individual
vcftools --gzvcf $SUBSET_VCF --het --out het_$OUT