#!/bin/bash
#$ -N GenerateMaskStep1
#$ -pe smp 1
#$ -e ~/mydirectory/MappabilityMaskOrenil2
#$ -o ~/mydirectory/MappabilityMaskOrenil2

cd ~/mydirectory/inputdata
mkdir bwa
cd bwa
cp ../GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna .

bwa-0.7.17/bwa index GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna

mkdir ~/mydirectory/MappabilityMaskOrenil2
cd ~/mydirectory/MappabilityMaskOrenil2

seqbility-20091110/splitfa ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna 100 | split -l 20000000

ls -1 x* > allsubfiles


#!/bin/bash
#$ -N GenerateMaskStep2
#$ -pe smp 1
#$ -t 1-101
#$ -e ~/mydirectory/MappabilityMaskOrenil2
#$ -o ~/mydirectory/MappabilityMaskOrenil2

cd  ~/mydirectory/MappabilityMaskOrenil2

module load samtools/1.8

export filein=$(cat allsubfiles | head -n $SGE_TASK_ID | tail -n 1 )
echo $filein

bwa-0.7.17/bwa aln -R 1000000 -O 3 -E 3 \
~/mydirectory/inputdata/bwa/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \
$filein > ${filein}.sai

bwa-0.7.17/bwa samse ~/mydirectory/inputdata/bwa/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \
 ${filein}.sai $filein | samtools view -S -b - -o ${filein}.bam

#!/bin/bash
#$ -N GenerateMaskStep3
#$ -pe smp 1
#$ -e ~/mydirectory/MappabilityMaskOrenil2
#$ -o ~/mydirectory/MappabilityMaskOrenil2

cd $HOME/Collaborations/TimoThuenken/MappabilityMaskOrenil2

module load samtools/1.8

for f in x*.bam; do samtools view $f | gzip -c >> all.sam.gz; done

gunzip -c all.sam.gz | $HOME/applications/seqbility-20091110/gen_raw_mask.pl > all_rawMask_100.fa

# This will gives you three masks: 50%, 90%, and 100%:
seqbility-20091110/gen_mask -l 100 -r 0.5 all_rawMask_100.fa > all_mask_100_50.fa
seqbility-20091110/gen_mask -l 100 -r 0.9 all_rawMask_100.fa > all_mask_100_90.fa
seqbility-20091110/gen_mask -l 100 -r 1.0 all_rawMask_100.fa > all_mask_100_100.fa

# Then use script provided by Milan Malinsky to create the bed files:
python bedFromMaskedFasta.py all_mask_100_50.fa > all_mask_100_50.bed
python bedFromMaskedFasta.py all_mask_100_90.fa > all_mask_100_90.bed
python bedFromMaskedFasta.py all_mask_100_100.fa > all_mask_100_100.bed
