#!/bin/bash
#$ -N SelectVariants
#$ -e ~/mydirectory/
#$ -o ~/mydirectory
#$ -pe smp 1

module load gatk/4.1.4.1
mkdir ~/mydirectory/hardfiltering/
cd ~/mydirectory/hardfiltering/

###############################################################################
##here we create two different files
##1)genotyped_snps.g.vcf: VariantsOnly file containing only SNPs
##2)genotypedAllSites_snps.g.vcf: AllSites file has every site except INDELs
###############################################################################
gatk SelectVariants \
    -V ~/mydirectory/gatherGVCFs/genotyped_merged.g.vcf \
    -select-type SNP \
    -O genotyped_snps.g.vcf

gatk SelectVariants \
    -V ~/mydirectory/gatherGVCFs/genotypedAllSites_merged.g.vcf \
    --select-type-to-exclude INDEL \
    -O genotypedAllSites_snps.g.vcf

echo "DONE Filtering"
