#!/bin/bash
#$ -N GatheringGVCFs
#$ -e ~/mydirectory
#$ -o ~/mydirectory
#$ -S /bin/bash
#$ -pe smp 1

module load gatk/4.1.4.1
module load picard/2.22.0

mkdir ~/mydirectory/gatherGVCFs/
cd ~/mydirectory/gatherGVCFs/

gatk GatherVcfs \
-R ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \
-I ~/mydirectorygenotypeGVCFs/NC_031965.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031966.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031969.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031970.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031971.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031972.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031973.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031974.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031975.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031976.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031977.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031978.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031979.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031980.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031987.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031981.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031982.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031983.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031984.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031985.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031986.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_031967.2_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/NC_013663_genotyped.g.vcf.gz \
-I ~/mydirectorygenotypeGVCFs/UNPLACED_genotyped.g.vcf.gz \
-O genotyped_merged.g.vcf

gatk GatherVcfs \
-R ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \
-I ~/mydirectory/genotypeGVCFs/NC_031965.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031966.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031969.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031970.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031971.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031972.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031973.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031974.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031975.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031976.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031977.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031978.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031979.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031980.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031987.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031981.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031982.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031983.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031984.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031985.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031986.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_031967.2_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/NC_013663_genotypedAllSites.g.vcf.gz \
-I ~/mydirectory/genotypeGVCFs/UNPLACED_genotypedAllSites.g.vcf.gz \
-O genotypedAllSites_merged.g.vcf

