#!/bin/bash
mkdir ~/mydirectory/genotypeGVCFs/
cd ~/mydirectory/genotypeGVCFs/

for CHROM in $(cat ~/mydirectory/inputdata/ChromNamesOrenil2)
do
                echo $CHROM
                touch ${CHROM}_GenotypeAllSites_Orenil2_tmp1.sh
                cat << EOF > ${CHROM}_GenotypeAllSites_Orenil2_tmp1.sh
#!/bin/bash
#$ -N GenotypeAllSites
#$ -e ~/mydirectory/genotypeGVCFs/
#$ -o ~/mydirectory/genotypeGVCFs/f
#$ -pe smp 1

module load gatk/4.1.4.1

echo $CHROM
cd ~/mydirectory/genotypeGVCFs/

gatk GenotypeGVCFs \\
-R ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \\
--variant ~/mydirectory/combineGVCFs/${CHROM}_combined.g.vcf.gz \\
-O ${CHROM}_genotypedAllSites.g.vcf.gz \\
--include-non-variant-sites 
EOF

		qsub ${CHROM}_GenotypeAllSites_Orenil2_tmp1.sh

                touch ${CHROM}_Genotype_Orenil2_tmp1.sh
                cat << EOF > ${CHROM}_Genotype_Orenil2_tmp1.sh
#!/bin/bash
#$ -N Genotype
#$ -e ~/mydirectory/genotypeGVCFs/
#$ -o ~/mydirectory/genotypeGVCFs/
#$ -pe smp 1

module load gatk/4.1.4.1

echo $CHROM
cd ~/mydirectory/genotypeGVCFs/
gatk GenotypeGVCFs \\
-R ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \\
--variant ~/mydirectory/combineGVCFs/${CHROM}_combined.g.vcf.gz \\
-O ${CHROM}_genotyped.g.vcf.gz
EOF

			qsub ${CHROM}_Genotype_Orenil2_tmp1.sh

done