#!/bin/bash
mkdir ~/mydirectory/combineGVCFs/
cd ~/mydirectory/combineGVCFs/
for CHROM in $(cat ~/mydirectory/inputdata/ChromNamesOrenil2)
do
                echo $CHROM
                touch ${CHROM}_Combine_Orenil2_tmp1.sh
                cat << EOF > ${CHROM}_Combine_Orenil2_tmp1.sh
#!/bin/bash
#$ -N CombineGVCFs
#$ -e ~/mydirectory/combineGVCFs/
#$ -o ~/mydirectory/combineGVCFs/
#$ -pe smp 1

module load gatk/4.1.4.1
cd ~/mydirectory/combineGVCFs/

echo $CHROM

gatk CombineGVCFs \\
-R ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \\
--variant ~/mydirectory/haplotypecaller/12_WC_P_${CHROM}.g.vcf.gz \\
--variant ~/mydirectory/haplotypecaller/1_WC_M_${CHROM}.g.vcf.gz \\
--variant ~/mydirectory/haplotypecaller/2_LB_F1III_${CHROM}.g.vcf.gz \\
--variant ~/mydirectory/haplotypecaller/3_LB_F1III_${CHROM}.g.vcf.gz \\
-O ${CHROM}_combined.g.vcf.gz
EOF

qsub ${CHROM}_Combine_Orenil2_tmp1.sh
done



