#!/bin/bash
mkdir ~/mydirectory/haplotypecaller/
cd ~/mydirectory/haplotypecaller/
for FILE in $(ls ~/mydirectory/mapping/*_Orenil2_dedup.bam)
do
		echo $FILE
		export PREFIX=$(basename $FILE _Orenil2_dedup.bam)
		echo $PREFIX
		touch ${PREFIX}_HC_Orenil2_tmp1.sh
		cat << EOF > ${PREFIX}_HC_Orenil2_tmp1.sh
#!/bin/bash
#$ -N HaplotypeCaller
#$ -pe smp 1
#$ -t 1-24
#$ -e ~/mydirectory/haplotypecaller/
#$ -o ~/mydirectory/haplotypecaller/

cd ~/mydirectory/haplotypecaller/
module load gatk/4.1.4.1
module load samtools/1.8
echo $FILE
samtools index $FILE

export INTERVAL=\$(cat ~/mydirectory/inputdata/ChromNamesOrenil2 | head -n \$SGE_TASK_ID | tail -n 1)
gatk HaplotypeCaller \\
-L \$INTERVAL \\
-R ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \\
--emit-ref-confidence GVCF -I $FILE -O ${PREFIX}_\${INTERVAL}.g.vcf.gz
EOF

qsub ${PREFIX}_HC_Orenil2_tmp1.sh
done
