#!/bin/bash
mkdir ~/mydirectory/mapping
cd  ~/mydirectory/mapping/

##############################################################################################################
# define individual to work on, this can be adapted to run as an array job depending on your system settings
##############################################################################################################
export MYINDIVIDUAL=`cat  ~/mydirectory/inputdata/sampleIDs.txt | head -n 1 | tail -n 1`
export NSLOTS="4"

echo "Mapping started for individual"
echo $MYINDIVIDUAL

module load bwa-mem2/2.2.1
module load picard/2.22.0
module load samtools/1.10
##############################################################################################################
# index the reference genome
##############################################################################################################
bwa-mem2 index ~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna

##############################################################################################################
# map  individual to the reference genome of O. niloticus and define read groups
##############################################################################################################

export library=$(zcat ${HOME}/cichlid_project/trimming/${MYINDIVIDUAL}_trim_1.fq.gz| head -n1  | sed -e 's/@//' | cut -d" " -f1)

bwa mem -t $NSLOTS -M -R "@RG\tID:${library}\tSM:${MYINDIVIDUAL}\tPL:ILLUMINA\tLB:${library}" \
~/mydirectory/inputdata/GCF_001858045.2_O_niloticus_UMD_NMBU_genomic_edit.fna \
~/mydirectory/trimming/${MYINDIVIDUAL}_trim_1.fq.gz \
~/mydirectory/trimming/${MYINDIVIDUAL}_trim_2.fq.gz \
| samtools fixmate -O sam - - | samtools sort -@ $NSLOTS -T tmp_${MYINDIVIDUAL} -O bam -o ${MYINDIVIDUAL}_Orenil2_sorted.bam -

##############################################################################################################
# mark duplicates
##############################################################################################################
java -jar $EBROOTPICARD/picard.jar MarkDuplicates \
INPUT=${MYINDIVIDUAL}_Orenil2_sorted.bam OUTPUT=${MYINDIVIDUAL}_Orenil2_dedup.bam METRICS_FILE=${MYINDIVIDUAL}_dedup_metrics_Orenil2.txt

##############################################################################################################
# calculate mapping statistics
##############################################################################################################
samtools flagstat ${MYINDIVIDUAL}_Orenil2_dedup.bam > ${MYINDIVIDUAL}_stats_backmapped
samtools depth -a ${MYINDIVIDUAL}_Orenil2_dedup.bam | awk '{c++;s+=$3}END{print s/c}'
samtools depth -a ${MYINDIVIDUAL}_Orenil2_dedup.bam | awk '{c++; if($3>0) total+=1}END{print (total/c)*100}'
