#!/bin/bash

#Example script of trimming for a single file

mkdir ~/mydirectory/trimming
cd  ~/mydirectory/trimming

#define individuals that analysis will run on over a list of unique IDs to be used across the analysis
export MYINDIVIDUAL=`cat ~/mydirectory/inputdata/sampleIDs.txt | head -n 1 | tail -n 1`

echo "Job calculation started for individual"
echo $MYINDIVIDUAL

module load trimmomatic/0.39

##############################################################################################################
# adapter removal for PE data
##############################################################################################################
java -jar $TRIMMOMATIC/trimmomatic-0.39.jar PE \
~/mydirectory/inputdata/${MYINDIVIDUAL}_R1.fastq.gz ~/mydirectory/inputdata/${MYINDIVIDUAL}_R2.fastq.gz \
~/mydirectory/trimming/${MYINDIVIDUAL}_trim_1.fq.gz ~/mydirectory/trimming/${MYINDIVIDUAL}_trim_1_unp.fq.gz \
~/mydirectory/trimming/${MYINDIVIDUAL}_trim_2.fq.gz ~/mydirectory/trimming/${MYINDIVIDUAL}_trim_2_unp.fq.gz \
ILLUMINACLIP:~/mydirectory/inputdata/TruSeq_PE_Primer_Multiplex.fasta:2:30:10:8:keepBothReads \
MINLEN:100


##############################################################################################################
# fastQC on output files
##############################################################################################################
fastqc ~/mydirectory/trimming/${MYINDIVIDUAL}_trim_1.fq.gz
fastqc ~/mydirectorytrimming/${MYINDIVIDUAL}_trim_2.fq.gz

