#!/bin/bash

#create a working directory
mkdir ~/mydirectory/qualcheck
cd  ~/mydirectory/qualcheck


# define your input files
# define the directory where they are
# define individuals that analysis will run on over a list of unique IDs to be used across the analysis
export MYINDIVIDUAL=`cat ~/mydirectory/sampleIDs.txt | head -n 1 | tail -n 1`


#define the path of read 1
export R1="~/mydirectory/inputdata/${MYINDIVIDUAL}_R1.fastq.gz"
#define the path of read 2
export R2="~/mydirectory/inputdata/${MYINDIVIDUAL}_R2.fastq.gz"

module load fastQValidator
fastQValidator \
--file $R1 > R1.validation.txt

echo -n "Finished fastqvalidator R1"
echo `date`

fastQValidator \
--file $R2 > R2.validation.txt
echo -n "Finished fastqvalidator R2"
echo `date`

module load fastqc
#run software
fastqc $R1 

echo -n "Finished fastqc read1"
echo `date`

fastqc $R2 
echo -n "Finished fastqc read2"
echo `date`



















