set t po eps co so "Helvetica,20"

set style line 1 lt 4 lc rgb "#FF0000" lw 2;
set style line 2 lt 1 lc rgb "#00C000" lw 2;
set style line 3 lt 8 lc rgb "#0080FF" lw 2;
set style line 4 lt 1 lc rgb "#C000FF" lw 2;
set style line 5 lt 1 lc rgb "#00EEEE" lw 2;
set style line 6 lt 1 lc rgb "#C04000" lw 2;
set style line 7 lt 1 lc rgb "#C8C800" lw 2;
set style line 8 lt 1 lc rgb "#FF80FF" lw 2;
set style line 9 lt 1 lc rgb "#4E642E" lw 2;
set style line 10 lt 1 lc rgb "#800000" lw 2;
set style line 11 lt 1 lc rgb "#67B7F7" lw 2;
set style line 12 lt 1 lc rgb "#FFC127" lw 2;

set size 1.6,0.8

set xlab "Chromosome position (Mb)"
set ylab "Read depth"
set yran [0:120]
set xtics 2

set out "dp-chr1.eps"
set style rect fc lt -1 fs solid 0.15 noborder
set obj rect from 14.377224, graph 0 to 17.129850, graph 1
plot '<grep OX298802.1 x-a2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0R" ls 2, \
	'<grep OX298802.1 x-c2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0W" ls 1, \
	'<grep OX298802.1 x-b2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0N" ls 3
unset obj

set out "dp-chr2.eps"
plot '<grep OX298803.1 x-a2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0R" ls 2, \
	'<grep OX298803.1 x-c2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0W" ls 1, \
	'<grep OX298803.1 x-b2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0N" ls 3

set out "dp-chr3.eps"
plot '<grep OX298804.1 x-c2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0W" ls 1, \
	'<grep OX298804.1 x-b2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0N" ls 3

set out "dp-chr4.eps"
plot '<grep OX298805.1 x-c2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0W" ls 1, \
	'<grep OX298805.1 x-b2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0N" ls 3

set out "dp-chr5.eps"
plot '<grep OX298806.1 x-c2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0W" ls 1, \
	'<grep OX298806.1 x-b2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0N" ls 3

set out "dp-chr1-full.eps"
set yran [0:*]
set style rect fc lt -1 fs solid 0.15 noborder
set obj rect from 14.377224, graph 0 to 17.129850, graph 1
plot '<grep OX298802.1 y-c2a.hifi.dp100.bed' u (($2+$3)/2*1e-6):($6/$5) t "Col-0W" ls 1
