from experiment_paths.experiment_paths import *


import subprocess
import os
from datetime import datetime




input_file_name_list = list()
input_file_name_list.append([1,"1_ETF_S1_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([2,"2_ETF_cleaned_S9_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([3,"3_ETF_cleaned_S10_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([4,"4_ETF_cleaned_S11_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([5,"5_ETF_cleaned_S12_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([6,"6_ETF_S2_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([7,"7_ETF_cleaned_S13_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([8,"8_ETF_cleaned_S14_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([9,"9_ETF_S3_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([10,"10_ETF_cleaned_S15_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([11,"11_ETF_S4_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([12,"12_ETF_cleaned_S16_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([13,"13_ETF_cleaned_S17_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([14,"14_ETF_cleaned_S18_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([15,"15_ETF_S5_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([16,"16_ETF_cleaned_S19_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([17,"17_ETF_cleaned_S20_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([18,"18_ETF_S6_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([19,"19_ETF_cleaned_S21_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([20,"20_ETF_cleaned_S7_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([21,"21_ETF_cleaned_S8_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([22,"22_ETF_cleaned_S22_L00%d_R%d_001.fastq.gz"])
input_file_name_list.append([23,"23_ETF_cleaned_S23_L00%d_R%d_001.fastq.gz"])

   
backbone_dict = {1:'T3',2:'T3',3:'T3',4:'T3',5:'T3',6:'T4',7:'T4',8:'T5',9:'T5',10:'T5',11:'T5',12:'T5',13:'T5',14:'T5',15:'T5',16:'T5',17:'T5',18:'T5',19:'T5',20:'T5',21:'T4',22:'T4',23:'T5'}



reads_path = exp_output_path.initial_fastq_input_files  #'/mnt/hgfs/Sequencing_data/L8YVI8X/STE15968.20210202/210127_A00987_0132_AHTLTVDSXY/'





def run_process_reads_for_library(input_file_name_list, backbone_dict, reads_path, lib_index):
    
    lib_number, file_string = input_file_name_list[lib_index]
    
    R1_var_1 = reads_path + file_string % (1,1)
    R1_var_2 = reads_path + file_string % (2,1)
    R1_var_3 = reads_path + file_string % (3,1)
    R1_var_4 = reads_path + file_string % (4,1)
    
    R2_var_1 = reads_path + file_string % (1,2)
    R2_var_2 = reads_path + file_string % (2,2)
    R2_var_3 = reads_path + file_string % (3,2)
    R2_var_4 = reads_path + file_string % (4,2)
    
    lib_num = lib_number
    backbone = backbone_dict[lib_number]
    
    
    
    R1_var = f"{R1_var_1}_all.fastq.gz"
    R2_var = f"{R2_var_1}_all.fastq.gz"
    
    start_time = datetime.now()
    
    print('begin concatenate library {:}'.format(lib_num) )
    subprocess.run(f"cat {R1_var_1} {R1_var_2} {R1_var_3} {R1_var_4} > {R1_var}", shell=True)
    subprocess.run(f"cat {R2_var_1} {R2_var_2} {R2_var_3} {R2_var_4} > {R2_var}", shell=True)
    print('end concatenate library {:}'.format(lib_num) )
    
    end_time = datetime.now()
    execution_time = end_time - start_time
    print(f"\n\nConcatenate took {execution_time.seconds} seconds to complete "
          f"({execution_time.seconds // 3600} hours {execution_time.seconds % 3600 // 60} minutes).\n\n")
    
    
    repo_path = exp_output_path.git_repo 
    print('exp_output_path.git_repo',exp_output_path.git_repo)
    subprocess.run(f"python {repo_path}prepare_reads_for_alignment_dark_cycle.py {R1_var} {R2_var} {lib_num} {backbone}", shell=True)

    subprocess.run(f"python {repo_path}align_exon_trapping_data.py {R1_var} {R2_var} {lib_num} {backbone}", shell=True)
    
    subprocess.run(f"python {repo_path}build_exon_interval_from_SAM_1.py {R1_var} {R2_var} {lib_num} {backbone}", shell=True)

    
    end_time = datetime.now()
    execution_time = end_time - start_time
    
    print(f"\n\nPython script took {execution_time.seconds} seconds to complete "
          f"({execution_time.seconds // 3600} hours {execution_time.seconds % 3600 // 60} minutes).\n\n")
    
    #os.remove(R1_var)
    #os.remove(R2_var)




    
lib_index=0

run_process_reads_for_library(input_file_name_list, backbone_dict, reads_path, lib_index)











params = [(input_file_name_list, backbone_dict, reads_path, index) for index in range(23)]

'''

from concurrent.futures import ProcessPoolExecutor


with ProcessPoolExecutor(max_workers=4) as executor:
    results = executor.map(lambda p: run_process_reads_for_library(*p), params)


for result in results:
    1

input_file_name_list, backbone_dict, reads_path, lib_index

'''




from concurrent.futures import ThreadPoolExecutor



with ThreadPoolExecutor(max_workers=4) as executor:
    results = executor.map(lambda p: run_process_reads_for_library(*p), params)

print(list(results))










