#!/bin/bash

PATH=/gpool/galentm/LinearPartition-master:$PATH

cd /gpool/galentm/structure/Zm
##Loop that calculates BPP for each terminal_inverted_repeat_element and makes a separate file for each
### f is a loop index that keeps track of iterations
### length is terminal_inverted_repeat_element nt length
### ID is terminal_inverted_repeat_element ID
### Also adds coefficient to file

rm terminal_inverted_repeat_element_partitioncoefficient.txt

f=0
for i in $(cat uq_terminal_inverted_repeat_element.seq | head -n 10) #head -n 100 first to test
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f terminal_inverted_repeat_element_IDs.txt | tail -n 1 )
	echo $i | linearpartition -r ${f}_${length}_${ID}_terminal_inverted_repeat_element.bpp 2>> terminal_inverted_repeat_element_partitioncoefficient.txt
done

rm terminal_inverted_repeat_element_coefficients.txt
f=0
for i in $(cat uq_terminal_inverted_repeat_element.seq)
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f terminal_inverted_repeat_element_IDs.txt | tail -n 1 )
    coeff=$(awk -F " "  '{print $4}' all_partitioncoefficient.txt | head -n $f  | tail -n 1 )
    echo ${length} ${ID} ${coeff} >> terminal_inverted_repeat_element_coefficients.txt 
done

