#!/bin/bash

PATH=/gpool/galentm/LinearPartition-master:$PATH

cd /gpool/galentm/structure/Zm
##Loop that calculates BPP for each solo_LTR and makes a separate file for each
### f is a loop index that keeps track of iterations
### length is solo_LTR nt length
### ID is solo_LTR ID
### Also adds coefficient to file

rm solo_LTR_partitioncoefficient.txt

f=0
for i in $(cat uq_solo_LTR.seq | head -n 10) #head -n 100 first to test
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f solo_LTR_IDs.txt | tail -n 1 )
	echo $i | linearpartition -r ${f}_${length}_${ID}_solo_LTR.bpp 2>> solo_LTR_partitioncoefficient.txt
done

rm solo_LTR_coefficients.txt
f=0
for i in $(cat uq_solo_LTR.seq)
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f solo_LTR_IDs.txt | tail -n 1 )
    coeff=$(awk -F " "  '{print $4}' all_partitioncoefficient.txt | head -n $f  | tail -n 1 )
    echo ${length} ${ID} ${coeff} >> solo_LTR_coefficients.txt 
done

