#!/bin/bash

PATH=/gpool/galentm/LinearPartition-master:$PATH

cd /gpool/galentm/structure/Zm
##Loop that calculates BPP for each helitron and makes a separate file for each
### f is a loop index that keeps track of iterations
### length is helitron nt length
### ID is helitron ID
### Also adds coefficient to file

rm helitron_partitioncoefficient.txt

f=0
for i in $(cat uq_helitron.seq | head -n 10) #head -n 100 first to test
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f helitron_IDs.txt | tail -n 1 )
	echo $i | linearpartition -r ${f}_${length}_${ID}_helitron.bpp 2>> helitron_partitioncoefficient.txt
done

rm helitron_coefficients.txt
f=0
for i in $(cat uq_helitron.seq)
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f helitron_IDs.txt | tail -n 1 )
    coeff=$(awk -F " "  '{print $4}' all_partitioncoefficient.txt | head -n $f  | tail -n 1 )
    echo ${length} ${ID} ${coeff} >> helitron_coefficients.txt 
done

