#!/bin/bash

PATH=/gpool/galentm/LinearPartition-master:$PATH

cd /gpool/galentm/structure/Zm
##Loop that calculates BPP for each SINE_element and makes a separate file for each
### f is a loop index that keeps track of iterations
### length is SINE_element nt length
### ID is SINE_element ID
### Also adds coefficient to file

rm SINE_element_partitioncoefficient.txt

f=0
for i in $(cat uq_SINE_element.seq | head -n 10) #head -n 100 first to test
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f SINE_element_IDs.txt | tail -n 1 )
	echo $i | linearpartition -r ${f}_${length}_${ID}_SINE_element.bpp 2>> SINE_element_partitioncoefficient.txt
done

rm SINE_element_coefficients.txt
f=0
for i in $(cat uq_SINE_element.seq)
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f SINE_element_IDs.txt | tail -n 1 )
    coeff=$(awk -F " "  '{print $4}' all_partitioncoefficient.txt | head -n $f  | tail -n 1 )
    echo ${length} ${ID} ${coeff} >> SINE_element_coefficients.txt 
done

