#!/bin/bash

PATH=/gpool/galentm/LinearPartition-master:$PATH

cd /gpool/galentm/structure/Zm
##Loop that calculates BPP for each LTR_retrotransposon and makes a separate file for each
### f is a loop index that keeps track of iterations
### length is LTR_retrotransposon nt length
### ID is LTR_retrotransposon ID
### Also adds coefficient to file

rm LTR_retrotransposon_partitioncoefficient.txt

f=0
for i in $(cat uq_LTR_retrotransposon.seq | head -n 10) #head -n 100 first to test
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f LTR_retrotransposon_IDs.txt | tail -n 1 )
	echo $i | linearpartition -r ${f}_${length}_${ID}_LTR_retrotransposon.bpp 2>> LTR_retrotransposon_partitioncoefficient.txt
done

rm LTR_retrotransposon_coefficients.txt
f=0
for i in $(cat uq_LTR_retrotransposon.seq)
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f LTR_retrotransposon_IDs.txt | tail -n 1 )
    coeff=$(awk -F " "  '{print $4}' all_partitioncoefficient.txt | head -n $f  | tail -n 1 )
    echo ${length} ${ID} ${coeff} >> LTR_retrotransposon_coefficients.txt 
done

