#!/bin/bash

PATH=/gpool/galentm/LinearPartition-master:$PATH

cd /gpool/galentm/structure/Zm
##Loop that calculates BPP for each gene and makes a separate file for each
### f is a loop index that keeps track of iterations
### length is gene nt length
### ID is gene ID
### Also adds coefficient to file

rm gene_partitioncoefficient.txt

f=0
for i in $(cat uq_gene.seq | head -n 10) #head -n 100 first to test
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f gene_IDs.txt | tail -n 1 )
	echo $i | linearpartition -r ${f}_${length}_${ID}_gene.bpp 2>> gene_partitioncoefficient.txt
done

rm gene_coefficients.txt
f=0
for i in $(cat uq_gene.seq)
do
    f=$(($f + 1))
    length=$(echo $i | wc -c | awk '{print $1}')
    ID=$(head -n $f gene_IDs.txt | tail -n 1 )
    coeff=$(awk -F " "  '{print $4}' all_partitioncoefficient.txt | head -n $f  | tail -n 1 )
    echo ${length} ${ID} ${coeff} >> gene_coefficients.txt 
done

