% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunscSeqComm}
\alias{RunscSeqComm}
\title{Run scSeqComm method to infer cell-cell communication (CCC).}
\usage{
RunscSeqComm(
  ser,
  species = NULL,
  priorDatabase = NULL,
  origin_lr = NULL,
  origin_rectf = NULL,
  origin_tftg = NULL,
  S_inter_cutoff = 0.8,
  S_intra_cutoff = 0.8,
  ...
)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{'human' or 'mouse'}

\item{priorDatabase}{If NULL, run with default LR prior database (origin_lr)}

\item{origin_lr}{see details in data('scSeqComm'); If NULL, scSeqComm::LR_pairs_Jin_2020 or scSeqComm::LR_pairs_Jin_2020_mouse is used.}

\item{origin_rectf}{see details in data('scSeqComm'); If NULL, scSeqComm::TF_PPR_KEGG_human or scSeqComm::TF_PPR_KEGG_mouse is used.}

\item{origin_tftg}{see details in data('scSeqComm'); If NULL, scSeqComm::TF_TG_RegNetwork_High or scSeqComm::TF_TG_RegNetwork_High_mouse is used.}

\item{S_inter_cutoff}{Numeric between 0 to 1. The cutoff of S_inter is used to filter the L-R pairs.}

\item{S_intra_cutoff}{Numeric between 0 to 1. The cutoff of S_intra is used to filter the L-R-Pathway links.}

\item{...}{other parameters in \code{\link[scSeqComm]{scSeqComm_analyze}}, except for the following parameters: gene_expr, cell_metadata, LR_pairs_DB, TF_reg_DB, R_TF_association}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run scSeqComm method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunscSeqComm(ser, species = 'human')

# Run with other LR prior database
db <- ChangescSeqCommDB(priorDatabase=priorDatabase)
result <- RunscSeqComm(ser, species = 'human', priorDatabase = db)
}

}
\seealso{
\code{\link[scSeqComm]{scSeqComm_analyze}}
}
\author{
Jiaxin Luo
}
