% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunscMLnet}
\alias{RunscMLnet}
\title{Run scMLnet method to infer cell-cell communication (CCC).}
\usage{
RunscMLnet(
  ser,
  sender = NULL,
  receiver = NULL,
  LigRecLib = NULL,
  RecTFLib = NULL,
  TFTarLib = NULL
)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{sender}{Character, cell types as sender clusters to infer CCC. If NULL, all cell types are used.}

\item{receiver}{Character, cell types as receiver clusters to infer CCC. If NULL, all cell types are used.}

\item{LigRecLib}{Dataframe, LR prior database which contains 'source' and 'target' columns. If NULL, the default LR prior database is used.}

\item{RecTFLib}{Dataframe, R-TF prior database which contains 'source' and 'target' columns. If NULL, the default R-TF prior database is used.}

\item{TFTarLib}{Dataframe, TF-TG prior database which contains 'source' and 'target' columns. If NULL, the default TF-TG prior database is used.}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender' and 'Receiver' four colunms.
}
\description{
This function is to run scMLnet method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunscMLnet(ser)

# Run with other LR prior database
db <- ChangescMLnetDB(priorDatabase=priorDatabase, extension=FALSE, keep_complexes = TRUE)
result <- RunscMLnet(ser, LigRecLib = db)

# Run with default and other LR prior databases
db <- ChangescMLnetDB(priorDatabase=priorDatabase, extension=TRUE, keep_complexes = TRUE)
result <- RunscMLnet(ser, LigRecLib = db)
}
}
\author{
Jiaxin Luo
}
