% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunscConnect}
\alias{RunscConnect}
\title{Run scConnect method to infer cell-cell communication (CCC).}
\usage{
RunscConnect(ser, species = NULL, PyHome = NULL, p_cutoff = 0.05)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{'human', 'mouse' and others}

\item{PyHome}{The execution file path of python, which has installed scConnect. If NULL, python installed in systems will be found and install scConnect}

\item{p_cutoff}{The cutoff of p.value of ligands and receptors. Defaults to 0.05}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run scConnect method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunscConnect(ser, species ='human')

# Run with other LR prior database
PyHome <- ChangescConnectDB(priorDatabase=priorDatabase, extension=FALSE, 
                            keep_complexes = TRUE, species = 'human')
result <- RunscConnect(ser, species ='human', PyHome = PyHome)

# Run with default and other LR prior databases
PyHome <- ChangescConnectDB(priorDatabase=priorDatabase, extension=TRUE, 
                            keep_complexes = TRUE, species = 'human')
result <- RunscConnect(ser, species ='human', PyHome = PyHome)
}

}
\author{
Jiaxin Luo
}
