% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunSCSR}
\alias{RunSCSR}
\title{Run SingleCellSignalR method to infer cell-cell communication (CCC).}
\usage{
RunSCSR(ser, species = NULL, priorDatabase = NULL, ...)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{'human' or 'mouse'}

\item{priorDatabase}{If NULL, run with default LR prior database}

\item{...}{other parameters in \code{\link[SingleCellSignalR]{cell_signaling}}, except for the following parameters: data, genes, cluster, c.names, species, write}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run SingleCellSignalR method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunSCSR(ser, species = 'human')

# Run with other LR prior database
db <- ChangeSCSRDB(priorDatabase=priorDatabase, extension=FALSE, keep_complexes = TRUE)
result <- RunSCSR(ser, species = 'human', priorDatabase = db)

# Run with default and other LR prior databases
db <- ChangeSCSRDB(priorDatabase=priorDatabase, extension=TRUE, keep_complexes = TRUE)
result <- RunSCSR(ser, species = 'human', priorDatabase = db)
}
}
\seealso{
\code{\link[SingleCellSignalR]{cell_signaling}}
}
\author{
Jiaxin Luo
}
