% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunRNAMagnet}
\alias{RunRNAMagnet}
\title{Run RNAMagnet method to infer cell-cell communication (CCC).}
\usage{
RunRNAMagnet(
  ser,
  priorDatabase = NULL,
  .version = "2.0.0",
  .cellularCompartment = c("Membrane", "ECM", "Both", "Secreted"),
  ...
)
}
\arguments{
\item{ser}{Seurat object, contains raw data stored in 'counts' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{priorDatabase}{If NULL, run with default LR prior database}

\item{.version}{see details in \code{\link[RNAMagnet]{getLigandsReceptors}}}

\item{.cellularCompartment}{see details in \code{\link[RNAMagnet]{RNAMagnetBase}}}

\item{...}{other parameters in \code{\link[RNAMagnet]{RNAMagnetBase}}, except for the following parameters: seurat, .version, .cellularCompartment}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run RNAMagnet method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunRNAMagnet(ser)

# Run with other LR prior database
db <- ChangeRNAMagnetDB(priorDatabase=priorDatabase, extension=FALSE)
result <- RunRNAMagnet(ser, priorDatabase = db)

# Run with default and other LR prior databases
db <- ChangeRNAMagnetDB(priorDatabase=priorDatabase, extension=TRUE)
result <- RunRNAMagnet(ser, priorDatabase = db)
}
}
\seealso{
\code{\link[RNAMagnet]{RNAMagnetBase}}

\code{\link[RNAMagnet]{getLigandsReceptors}}
}
\author{
Jiaxin Luo
}
