% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunNATMI}
\alias{RunNATMI}
\title{Run NATMI method to infer cell-cell communication (CCC).}
\usage{
RunNATMI(
  ser,
  species = NULL,
  cores = NULL,
  filter.perc = 0.05,
  priorDatabase = FALSE,
  NATMI_dir = NA,
  PyHome = NULL
)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{"human", "mouse" and more(21 species)}

\item{cores}{Number of cores used to run in parallel. Defaults to NULL}

\item{filter.perc}{Numeric, filtering ligands and receptors expressed in less than filter.perc*100 percentage of cells. Defaults to 0.05}

\item{priorDatabase}{Logic. If FALSE, using default LR prior database to infer CCC}

\item{NATMI_dir}{Folder path of source code of NATMI. If NA, it will download the source code of NATMI from github in the current directory.}

\item{PyHome}{The execution file path of python}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run NATMI method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunNATMI(ser, species ='human', priorDatabase = FALSE)

# Run with other LR prior database
NATMI_dir <- ChangeNATMIDB(priorDatabase=NULL, extension=FALSE, keep_complexes = TRUE)
result <- RunNATMI(ser, species ='human', priorDatabase = TRUE, NATMI_dir = NATMI_dir)

# Run with default and other LR prior databases
NATMI_dir <- ChangeNATMIDB(priorDatabase=NULL, extension=FALSE, keep_complexes = TRUE)
result <- RunNATMI(ser, species ='human', priorDatabase = TRUE, NATMI_dir = NATMI_dir)
}

}
\seealso{
\code{\link[domino]{build_domino}}
}
\author{
Jiaxin Luo
}
