% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunDomino}
\alias{RunDomino}
\title{Run Domino method to infer cell-cell communication (CCC).}
\usage{
RunDomino(ser, db_path = NULL, fpath.auc = NULL, fpath.reg = NULL, ...)
}
\arguments{
\item{ser}{Seurat object, contains raw and normalized data stored in 'counts' and 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{db_path}{Folder for storing database. If NULL, using the default database of CellPhoneDB}

\item{fpath.auc}{File path of the output when running pyscenic}

\item{fpath.reg}{File path of the output when running pyscenic}

\item{...}{other parameters in \code{\link[domino]{build_domino}}, except for the following parameters: dom}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run Domino method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunDomino(ser, fpath.auc=fpath.auc, fpath.reg=fpath.auc)

# Run with other LR prior database
db_path <- ChangeDominoDB(priorDatabase=priorDatabase)
result <- RunDomino(ser, db_path = db_path, fpath.auc=fpath.auc, fpath.reg=fpath.auc)
}

}
\seealso{
\code{\link[domino]{build_domino}}
}
\author{
Jiaxin Luo
}
