% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunCytoTalk}
\alias{RunCytoTalk}
\title{Run CytoTalk method to infer cell-cell communication (CCC).}
\usage{
RunCytoTalk(ser, species = NULL, priorDatabase = NULL, celltypes = NULL, ...)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{'human' or 'mouse'}

\item{priorDatabase}{If NULL, run with default LR prior database}

\item{celltypes}{Character, cell types used to infer CCC. If NULL, all cell types are used}

\item{...}{other parameters in \code{\link[CytoTalk]{run_cytotalk}}, except for the following parameters: lst_scrna, cell_type_a, cell_type_b, pcg, lrp}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run CytoTalk method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunCytoTalk(ser, species = 'human')

# Run with other LR prior database
db <- ChangeCytoTalkDB(priorDatabase=priorDatabase, extension=FALSE, 
                       keep_complexes = TRUE, species = 'human')
result <- RunCytoTalk(ser, species = 'human', priorDatabase = db)

# Run with default and other LR prior databases
db <- ChangeCytoTalkDB(priorDatabase=priorDatabase, extension=TRUE, 
                       keep_complexes = TRUE, species = 'human')
result <- RunCytoTalk(ser, species = 'human', priorDatabase = db)
}
}
\seealso{
\code{\link[CytoTalk]{run_cytotalk}}
}
\author{
Jiaxin Luo
}
