% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunConnectome}
\alias{RunConnectome}
\title{Run Connectome method to infer cell-cell communication (CCC).}
\usage{
RunConnectome(ser, species = NULL, priorDatabase = NULL, ...)
}
\arguments{
\item{ser}{Seurat object, contains raw and normalized stored in 'counts' and 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{'human', 'mouse', 'rat' or 'pig'. If provide priorDatabase, species are not limited}

\item{priorDatabase}{If NULL, run with default LR prior database}

\item{...}{other parameters in \code{\link[Connectome]{FilterConnectome}}, except for the following parameter: connectome}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run Connectome method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunConnectome(ser, species = 'human')

# Run with other LR prior database
db <- ChangeConnectomeDB(priorDatabase=priorDatabase, extension=FALSE, 
                         keep_complexes = TRUE, species = 'human')
result <- RunConnectome(ser, species = 'human', priorDatabase = db)

# Run with default and other LR prior databases
db <- ChangeConnectomeDB(priorDatabase=priorDatabase, extension=TRUE, 
                         keep_complexes = TRUE, species = 'human')
result <- RunConnectome(ser, species = 'human', priorDatabase = db)
}
}
\seealso{
\code{\link[Connectome]{FilterConnectome}}
}
\author{
Jiaxin Luo
}
