% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunCellTalker}
\alias{RunCellTalker}
\title{Run CellTalker method to infer cell-cell communication (CCC).}
\usage{
RunCellTalker(ser, priorDatabase = NULL, ...)
}
\arguments{
\item{ser}{Seurat object, contains raw and normalized data stored in 'counts' and 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{priorDatabase}{If NULL, run with default LR prior database}

\item{...}{Other parameters in \code{\link[celltalker]{celltalk}} function, except for the following parameters: input_object, metadata_grouping, ligand_receptor_pairs}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run CellTalker method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunCellTalker(ser)

# Run with other LR prior database
db <- ChangeCellTalkerDB(priorDatabase=priorDatabase, extension=FALSE, keep_complexes = TRUE)
result <- RunCellTalker(ser, priorDatabase = db)

# Run with default and other LR prior databases
db <- ChangeCellTalkerDB(priorDatabase=priorDatabase, extension=TRUE, keep_complexes = TRUE)
result <- RunCellTalker(ser, priorDatabase = db)
}
}
\seealso{
\code{\link[celltalker]{celltalk}}
}
\author{
Jiaxin Luo
}
