% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunCellPhoneDB3}
\alias{RunCellPhoneDB3}
\title{Run CellPhoneDB3 method to infer cell-cell communication (CCC).}
\usage{
RunCellPhoneDB3(ser, db_path = NULL, cores = 1)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{db_path}{Folder for storing database. If using default database of CellPhoneDB, the db_path should be set to NULL}

\item{cores}{Number of cores used to run in parallel. Defaults to 1}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run CellPhoneDB3 method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunCellPhoneDB3(ser)

# Run with other LR prior database
db_path <- ChangeCellPhoneDB(priorDatabase=priorDatabase, extension=FALSE)
result <- RunCellPhoneDB3(ser, db_path = db_path, condaName = 'cpdb')

# Run with default and other LR prior databases
db_path <- ChangeCellPhoneDB(priorDatabase=priorDatabase, extension=TRUE)
result <- RunCellPhoneDB3(ser, db_path = db_path, condaName = 'cpdb')
}

}
\author{
Jiaxin Luo
}
