% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCCCFunction.R
\name{RunCellChat}
\alias{RunCellChat}
\title{Run CellChat method to infer cell-cell communication (CCC).}
\usage{
RunCellChat(ser, species = NULL, priorDatabase = NULL, ...)
}
\arguments{
\item{ser}{Seurat object, contains normalized data stored in 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'}

\item{species}{'human', 'mouse' or 'zebrafish'}

\item{priorDatabase}{If NA, run with default LR prior database}

\item{...}{other parameters in \code{\link[CellChat]{computeCommunProb}}, except for the following parameter: object}
}
\value{
Dataframe, contains  'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
This function is to run CellChat method to infer CCC.
}
\examples{
\dontrun{
# Run with default LR prior database
result <- RunCellChat(ser, species = 'human')

# Run with other LR prior database
db <- ChangeCellChatDB(priorDatabase=priorDatabase, extension=FALSE, species = 'human')
result <- RunCellChat(ser, species = 'human', priorDatabase = db)

# Run with default and other LR prior databases
db <- ChangeCellChatDB(priorDatabase=priorDatabase, extension=TRUE, species = 'human')
result <- RunCellChat(ser, species = 'human', priorDatabase = db)
}
}
\seealso{
\code{\link[CellChat]{computeCommunProb}}
}
\author{
Jiaxin Luo
}
