% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCCbank.R
\name{CCCbank}
\alias{CCCbank}
\title{Infer cell-cell communication (CCC) with any combination of methods and database}
\usage{
CCCbank(
  ser,
  method,
  species = "human",
  databases = NULL,
  extension = FALSE,
  keep_complexes = TRUE,
  ...
)
}
\arguments{
\item{ser}{Seurat object, contains raw and normalized data stored in 'counts' and 'data' slot of 'RNA' assay, and cell type metadata stored in meta.data as 'celltype'.}

\item{method}{Character, select one method to infer CCC, and 16 methods are supported.}

\item{species}{human, mouse or other species.}

\item{databases}{Character, select one or more LR prior databases of 13 databases. Also, it can be dataframe with two colunms: ligand, receptor. If NULL, the default LR prior database of method will be used.}

\item{extension}{Logic. When the parameter 'databases' is not NULL, whether use the combination of default database of method and other databases?}

\item{keep_complexes}{Logic. If TRUE, multi-subunit of ligand and receptor will be splited into single-subunit, when the parameter 'databases' is not NULL and the method doesn't consider multi-subunit of ligand and receptor. Otherwise, the interactions containing multi-subunit will be filtered out.}

\item{...}{Other parameters in the corresponding method function.}
}
\value{
Dataframe, contains 'Ligand', 'Receptor', 'Sender', 'Receiver' and 'LRscore' five colunms.
}
\description{
Infer cell-cell communication (CCC) with any combination of methods and database
}
\examples{
\dontrun{
# Run CellChat with its default LR prior database
result <- CCCbank(ser, method = 'CellChat', species = 'human')

# Run CellChat with database of CellPhoneDBLR
result <- CCCbank(ser, method = 'CellChat', species = 'human', 
                  database = 'CellPhoneDBLR', extension =FALSE)

# Run CellChat with the combination of its default LR prior database 
# and database of CellPhoneDBLR
result <- CCCbank(ser, method = 'CellChat', species = 'human', 
                  database = 'CellPhoneDBLR', extension =TRUE)

# Run CellChat with the combination of its default LR prior database 
# and databases of CellPhoneDB and FANTOM5
result <- CCCbank(ser, method = 'CellChat', species = 'human', 
                  database = c('CellPhoneDBLR', 'FAMTOM5'), extension =TRUE)

# Run CellChat with user-defined database
database <- data.frame(ligand = c('A', 'B', 'C'), 
                       receptor = c('D', 'E', 'F'))
result <- CCCbank(ser, method = 'CellChat', species = 'human', 
                  database = database, extension =FALSE)
}
}
\author{
Jiaxin Luo
}
