###the following code generates plots from Supplemental Fig 3

install.packages("ggplot2")
library (ggplot2)

in_data5<-read.table("regression_LR_90_tech.txt", header = TRUE)
print(in_data5)


ggp <- ggplot(data = in_data5, aes(x = Assembly_Length, y = all_repeats_proportion)) +
  geom_point() #+ coord_flip() + theme_minimal()

ggp

ggp + scale_x_continuous(trans='log2') + scale_y_continuous(trans='log2') +
    geom_smooth(method = "lm", level = 0.99, se = TRUE)

ggp +
  geom_smooth(method = "lm", level = 0.99, se = TRUE)



ggplot(data = in_data5, aes(x = Order, y = SINEs_proportion)) +
  geom_boxplot() + geom_jitter(width = 0.2, (aes(colour = Tech_coarse, alpha = 0.9))) #+ coord_flip() + theme_minimal() 
ggplot(data = in_data5, aes(x = Order, y = tandem_repeats_proportion)) +
  geom_boxplot() + geom_jitter(width = 0.2, (aes(colour = Tech_coarse, alpha = 0.9))) #+ coord_flip() + theme_minimal()
ggplot(data = in_data5, aes(x = Order, y = other_repeats_proportion)) +
  geom_boxplot() + geom_jitter(width = 0.2, (aes(colour = Tech_coarse, alpha = 0.9)))#+ coord_flip() + theme_minimal()


