#!/bin/sh
#SBATCH --job-name=count_known_kmers
#SBATCH --partition=owners
#SBATCH --array=1-2
#SBATCH --output=/scratch/users/briannac/logs/count_known_kmers_%a.out
#SBATCH --error=/scratch/users/briannac/logs/count_known_kmers_%a.err
#SBATCH --time=3:00:00
#SBATCH --mem=10G
#SBATCH --mail-type=ALL
#SBATCH --mail-user=briannac@stanford.edu


module load biology jellyfish bedtools samtools

# Note: Copy data file to intermediate file in $SCRATCH directory for faster xargs access.
# cp $MY_HOME/alt_haplotypes/data/known_alt_haplotype_kmers.txt  /home/groups/dpwall/briannac/alt_haplotypes/intermediate_files/ground_truth/sample_kmer_counts/known_alt_haplotype_kmers.txt


### file at /home/groups/dpwall/briannac/alt_haplotypes/src/ground_truth/count_known_kmers.sh
unfinished_samples=$MY_HOME/alt_haplotypes/intermediate_files/ground_truth/sample_kmer_counts/unfinished.txt
cd $SCRATCH/tmp
for I_TO_ADD in 0 ; do # 1000 2000 3000 4000; do
    N=$((SLURM_ARRAY_TASK_ID + I_TO_ADD))
    head -n $N $unfinished_samples | tail -n 1 > $SCRATCH/tmp/tmp_kmers_from_unmapped_reads_$SLURM_ARRAY_TASK_ID.txt
    while read SAMPLE; do
        echo $SAMPLE
        mkdir $MY_HOME/alt_haplotypes/intermediate_files/ground_truth/sample_kmer_counts/$SAMPLE
        cd $MY_HOME/alt_haplotypes/intermediate_files/ground_truth/sample_kmer_counts/$SAMPLE
        
        echo "Making fastq from reads mapped to alt_haps..."
        for contig in chr1_KI270706v1_random chr1_KI270707v1_random chr1_KI270708v1_random chr1_KI270709v1_random chr1_KI270710v1_random chr1_KI270711v1_random chr1_KI270712v1_random chr1_KI270713v1_random chr1_KI270714v1_random chr2_KI270715v1_random chr2_KI270716v1_random chr3_GL000221v1_random chr4_GL000008v2_random chr5_GL000208v1_random chr9_KI270717v1_random chr9_KI270718v1_random chr9_KI270719v1_random chr9_KI270720v1_random chr11_KI270721v1_random chr14_GL000009v2_random chr14_GL000225v1_random chr14_KI270722v1_random chr14_GL000194v1_random chr14_KI270723v1_random chr14_KI270724v1_random chr14_KI270725v1_random chr14_KI270726v1_random chr15_KI270727v1_random chr16_KI270728v1_random chr17_GL000205v2_random chr17_KI270729v1_random chr17_KI270730v1_random chr22_KI270731v1_random chr22_KI270732v1_random chr22_KI270733v1_random chr22_KI270734v1_random chr22_KI270735v1_random chr22_KI270736v1_random chr22_KI270737v1_random chr22_KI270738v1_random chr22_KI270739v1_random chrY_KI270740v1_random chrUn_KI270302v1 chrUn_KI270304v1 chrUn_KI270303v1 chrUn_KI270305v1 chrUn_KI270322v1 chrUn_KI270320v1 chrUn_KI270310v1 chrUn_KI270316v1 chrUn_KI270315v1 chrUn_KI270312v1 chrUn_KI270311v1 chrUn_KI270317v1 chrUn_KI270412v1 chrUn_KI270411v1 chrUn_KI270414v1 chrUn_KI270419v1 chrUn_KI270418v1 chrUn_KI270420v1 chrUn_KI270424v1 chrUn_KI270417v1 chrUn_KI270422v1 chrUn_KI270423v1 chrUn_KI270425v1 chrUn_KI270429v1 chrUn_KI270442v1 chrUn_KI270466v1 chrUn_KI270465v1 chrUn_KI270467v1 chrUn_KI270435v1 chrUn_KI270438v1 chrUn_KI270468v1 chrUn_KI270510v1 chrUn_KI270509v1 chrUn_KI270518v1 chrUn_KI270508v1 chrUn_KI270516v1 chrUn_KI270512v1 chrUn_KI270519v1 chrUn_KI270522v1 chrUn_KI270511v1 chrUn_KI270515v1 chrUn_KI270507v1 chrUn_KI270517v1 chrUn_KI270529v1 chrUn_KI270528v1 chrUn_KI270530v1 chrUn_KI270539v1 chrUn_KI270538v1 chrUn_KI270544v1 chrUn_KI270548v1 chrUn_KI270583v1 chrUn_KI270587v1 chrUn_KI270580v1 chrUn_KI270581v1 chrUn_KI270579v1 chrUn_KI270589v1 chrUn_KI270590v1 chrUn_KI270584v1 chrUn_KI270582v1 chrUn_KI270588v1 chrUn_KI270593v1 chrUn_KI270591v1 chrUn_KI270330v1 chrUn_KI270329v1 chrUn_KI270334v1 chrUn_KI270333v1 chrUn_KI270335v1 chrUn_KI270338v1 chrUn_KI270340v1 chrUn_KI270336v1 chrUn_KI270337v1 chrUn_KI270363v1 chrUn_KI270364v1 chrUn_KI270362v1 chrUn_KI270366v1 chrUn_KI270378v1 chrUn_KI270379v1 chrUn_KI270389v1 chrUn_KI270390v1 chrUn_KI270387v1 chrUn_KI270395v1 chrUn_KI270396v1 chrUn_KI270388v1 chrUn_KI270394v1 chrUn_KI270386v1 chrUn_KI270391v1 chrUn_KI270383v1 chrUn_KI270393v1 chrUn_KI270384v1 chrUn_KI270392v1 chrUn_KI270381v1 chrUn_KI270385v1 chrUn_KI270382v1 chrUn_KI270376v1 chrUn_KI270374v1 chrUn_KI270372v1 chrUn_KI270373v1 chrUn_KI270375v1 chrUn_KI270371v1 chrUn_KI270448v1 chrUn_KI270521v1 chrUn_GL000195v1 chrUn_GL000219v1 chrUn_GL000220v1 chrUn_GL000224v1 chrUn_KI270741v1 chrUn_GL000226v1 chrUn_GL000213v1 chrUn_KI270743v1 chrUn_KI270744v1 chrUn_KI270745v1 chrUn_KI270746v1 chrUn_KI270747v1 chrUn_KI270748v1 chrUn_KI270749v1 chrUn_KI270750v1 chrUn_KI270751v1 chrUn_KI270752v1 chrUn_KI270753v1 chrUn_KI270754v1 chrUn_KI270755v1 chrUn_KI270756v1 chrUn_KI270757v1 chrUn_GL000214v1 chrUn_KI270742v1 chrUn_GL000216v2 chrUn_GL000218v1 chrUn_KN707606v1_decoy chrUn_KN707607v1_decoy chrUn_KN707608v1_decoy chrUn_KN707609v1_decoy chrUn_KN707610v1_decoy chrUn_KN707611v1_decoy chrUn_KN707612v1_decoy chrUn_KN707613v1_decoy chrUn_KN707614v1_decoy chrUn_KN707615v1_decoy chrUn_KN707616v1_decoy chrUn_KN707617v1_decoy chrUn_KN707618v1_decoy chrUn_KN707619v1_decoy chrUn_KN707620v1_decoy chrUn_KN707621v1_decoy chrUn_KN707622v1_decoy chrUn_KN707623v1_decoy chrUn_KN707624v1_decoy chrUn_KN707625v1_decoy chrUn_KN707626v1_decoy chrUn_KN707627v1_decoy chrUn_KN707628v1_decoy chrUn_KN707629v1_decoy chrUn_KN707630v1_decoy chrUn_KN707631v1_decoy chrUn_KN707632v1_decoy chrUn_KN707633v1_decoy chrUn_KN707634v1_decoy chrUn_KN707635v1_decoy chrUn_KN707636v1_decoy chrUn_KN707637v1_decoy chrUn_KN707638v1_decoy chrUn_KN707639v1_decoy chrUn_KN707640v1_decoy chrUn_KN707641v1_decoy chrUn_KN707642v1_decoy chrUn_KN707643v1_decoy chrUn_KN707644v1_decoy chrUn_KN707645v1_decoy chrUn_KN707646v1_decoy chrUn_KN707647v1_decoy chrUn_KN707648v1_decoy chrUn_KN707649v1_decoy chrUn_KN707650v1_decoy chrUn_KN707651v1_decoy chrUn_KN707652v1_decoy chrUn_KN707653v1_decoy chrUn_KN707654v1_decoy chrUn_KN707655v1_decoy chrUn_KN707656v1_decoy chrUn_KN707657v1_decoy chrUn_KN707658v1_decoy chrUn_KN707659v1_decoy chrUn_KN707660v1_decoy chrUn_KN707661v1_decoy chrUn_KN707662v1_decoy chrUn_KN707663v1_decoy chrUn_KN707664v1_decoy chrUn_KN707665v1_decoy chrUn_KN707666v1_decoy chrUn_KN707667v1_decoy chrUn_KN707668v1_decoy chrUn_KN707669v1_decoy chrUn_KN707670v1_decoy chrUn_KN707671v1_decoy chrUn_KN707672v1_decoy chrUn_KN707673v1_decoy chrUn_KN707674v1_decoy chrUn_KN707675v1_decoy chrUn_KN707676v1_decoy chrUn_KN707677v1_decoy chrUn_KN707678v1_decoy chrUn_KN707679v1_decoy chrUn_KN707680v1_decoy chrUn_KN707681v1_decoy chrUn_KN707682v1_decoy chrUn_KN707683v1_decoy chrUn_KN707684v1_decoy chrUn_KN707685v1_decoy chrUn_KN707686v1_decoy chrUn_KN707687v1_decoy chrUn_KN707688v1_decoy chrUn_KN707689v1_decoy chrUn_KN707690v1_decoy chrUn_KN707691v1_decoy chrUn_KN707692v1_decoy chrUn_KN707693v1_decoy chrUn_KN707694v1_decoy chrUn_KN707695v1_decoy chrUn_KN707696v1_decoy chrUn_KN707697v1_decoy chrUn_KN707698v1_decoy chrUn_KN707699v1_decoy chrUn_KN707700v1_decoy chrUn_KN707701v1_decoy chrUn_KN707702v1_decoy chrUn_KN707703v1_decoy chrUn_KN707704v1_decoy chrUn_KN707705v1_decoy chrUn_KN707706v1_decoy chrUn_KN707707v1_decoy chrUn_KN707708v1_decoy chrUn_KN707709v1_decoy chrUn_KN707710v1_decoy chrUn_KN707711v1_decoy chrUn_KN707712v1_decoy chrUn_KN707713v1_decoy chrUn_KN707714v1_decoy chrUn_KN707715v1_decoy chrUn_KN707716v1_decoy chrUn_KN707717v1_decoy chrUn_KN707718v1_decoy chrUn_KN707719v1_decoy chrUn_KN707720v1_decoy chrUn_KN707721v1_decoy chrUn_KN707722v1_decoy chrUn_KN707723v1_decoy chrUn_KN707724v1_decoy chrUn_KN707725v1_decoy chrUn_KN707726v1_decoy chrUn_KN707727v1_decoy chrUn_KN707728v1_decoy chrUn_KN707729v1_decoy chrUn_KN707730v1_decoy chrUn_KN707731v1_decoy chrUn_KN707732v1_decoy chrUn_KN707733v1_decoy chrUn_KN707734v1_decoy chrUn_KN707735v1_decoy chrUn_KN707736v1_decoy chrUn_KN707737v1_decoy chrUn_KN707738v1_decoy chrUn_KN707739v1_decoy chrUn_KN707740v1_decoy chrUn_KN707741v1_decoy chrUn_KN707742v1_decoy chrUn_KN707743v1_decoy chrUn_KN707744v1_decoy chrUn_KN707745v1_decoy chrUn_KN707746v1_decoy chrUn_KN707747v1_decoy chrUn_KN707748v1_decoy chrUn_KN707749v1_decoy chrUn_KN707750v1_decoy chrUn_KN707751v1_decoy chrUn_KN707752v1_decoy chrUn_KN707753v1_decoy chrUn_KN707754v1_decoy chrUn_KN707755v1_decoy chrUn_KN707756v1_decoy chrUn_KN707757v1_decoy chrUn_KN707758v1_decoy chrUn_KN707759v1_decoy chrUn_KN707760v1_decoy chrUn_KN707761v1_decoy chrUn_KN707762v1_decoy chrUn_KN707763v1_decoy chrUn_KN707764v1_decoy chrUn_KN707765v1_decoy chrUn_KN707766v1_decoy chrUn_KN707767v1_decoy chrUn_KN707768v1_decoy chrUn_KN707769v1_decoy chrUn_KN707770v1_decoy chrUn_KN707771v1_decoy chrUn_KN707772v1_decoy chrUn_KN707773v1_decoy chrUn_KN707774v1_decoy chrUn_KN707775v1_decoy chrUn_KN707776v1_decoy chrUn_KN707777v1_decoy chrUn_KN707778v1_decoy chrUn_KN707779v1_decoy chrUn_KN707780v1_decoy chrUn_KN707781v1_decoy chrUn_KN707782v1_decoy chrUn_KN707783v1_decoy chrUn_KN707784v1_decoy chrUn_KN707785v1_decoy chrUn_KN707786v1_decoy chrUn_KN707787v1_decoy chrUn_KN707788v1_decoy chrUn_KN707789v1_decoy chrUn_KN707790v1_decoy chrUn_KN707791v1_decoy chrUn_KN707792v1_decoy chrUn_KN707793v1_decoy chrUn_KN707794v1_decoy chrUn_KN707795v1_decoy chrUn_KN707796v1_decoy chrUn_KN707797v1_decoy chrUn_KN707798v1_decoy chrUn_KN707799v1_decoy chrUn_KN707800v1_decoy chrUn_KN707801v1_decoy chrUn_KN707802v1_decoy chrUn_KN707803v1_decoy chrUn_KN707804v1_decoy chrUn_KN707805v1_decoy chrUn_KN707806v1_decoy chrUn_KN707807v1_decoy chrUn_KN707808v1_decoy chrUn_KN707809v1_decoy chrUn_KN707810v1_decoy chrUn_KN707811v1_decoy chrUn_KN707812v1_decoy chrUn_KN707813v1_decoy chrUn_KN707814v1_decoy chrUn_KN707815v1_decoy chrUn_KN707816v1_decoy chrUn_KN707817v1_decoy chrUn_KN707818v1_decoy chrUn_KN707819v1_decoy chrUn_KN707820v1_decoy chrUn_KN707821v1_decoy chrUn_KN707822v1_decoy chrUn_KN707823v1_decoy chrUn_KN707824v1_decoy chrUn_KN707825v1_decoy chrUn_KN707826v1_decoy chrUn_KN707827v1_decoy chrUn_KN707828v1_decoy chrUn_KN707829v1_decoy chrUn_KN707830v1_decoy chrUn_KN707831v1_decoy chrUn_KN707832v1_decoy chrUn_KN707833v1_decoy chrUn_KN707834v1_decoy chrUn_KN707835v1_decoy chrUn_KN707836v1_decoy chrUn_KN707837v1_decoy chrUn_KN707838v1_decoy chrUn_KN707839v1_decoy chrUn_KN707840v1_decoy chrUn_KN707841v1_decoy chrUn_KN707842v1_decoy chrUn_KN707843v1_decoy chrUn_KN707844v1_decoy chrUn_KN707845v1_decoy chrUn_KN707846v1_decoy chrUn_KN707847v1_decoy chrUn_KN707848v1_decoy chrUn_KN707849v1_decoy chrUn_KN707850v1_decoy chrUn_KN707851v1_decoy chrUn_KN707852v1_decoy chrUn_KN707853v1_decoy chrUn_KN707854v1_decoy chrUn_KN707855v1_decoy chrUn_KN707856v1_decoy chrUn_KN707857v1_decoy chrUn_KN707858v1_decoy chrUn_KN707859v1_decoy chrUn_KN707860v1_decoy chrUn_KN707861v1_decoy chrUn_KN707862v1_decoy chrUn_KN707863v1_decoy chrUn_KN707864v1_decoy chrUn_KN707865v1_decoy chrUn_KN707866v1_decoy chrUn_KN707867v1_decoy chrUn_KN707868v1_decoy chrUn_KN707869v1_decoy chrUn_KN707870v1_decoy chrUn_KN707871v1_decoy chrUn_KN707872v1_decoy chrUn_KN707873v1_decoy chrUn_KN707874v1_decoy chrUn_KN707875v1_decoy chrUn_KN707876v1_decoy chrUn_KN707877v1_decoy chrUn_KN707878v1_decoy chrUn_KN707879v1_decoy chrUn_KN707880v1_decoy chrUn_KN707881v1_decoy chrUn_KN707882v1_decoy chrUn_KN707883v1_decoy chrUn_KN707884v1_decoy chrUn_KN707885v1_decoy chrUn_KN707886v1_decoy chrUn_KN707887v1_decoy chrUn_KN707888v1_decoy chrUn_KN707889v1_decoy chrUn_KN707890v1_decoy chrUn_KN707891v1_decoy chrUn_KN707892v1_decoy chrUn_KN707893v1_decoy chrUn_KN707894v1_decoy chrUn_KN707895v1_decoy chrUn_KN707896v1_decoy chrUn_KN707897v1_decoy chrUn_KN707898v1_decoy chrUn_KN707899v1_decoy chrUn_KN707900v1_decoy chrUn_KN707901v1_decoy chrUn_KN707902v1_decoy chrUn_KN707903v1_decoy chrUn_KN707904v1_decoy chrUn_KN707905v1_decoy chrUn_KN707906v1_decoy chrUn_KN707907v1_decoy chrUn_KN707908v1_decoy chrUn_KN707909v1_decoy chrUn_KN707910v1_decoy chrUn_KN707911v1_decoy chrUn_KN707912v1_decoy chrUn_KN707913v1_decoy chrUn_KN707914v1_decoy chrUn_KN707915v1_decoy chrUn_KN707916v1_decoy chrUn_KN707917v1_decoy chrUn_KN707918v1_decoy chrUn_KN707919v1_decoy chrUn_KN707920v1_decoy chrUn_KN707921v1_decoy chrUn_KN707922v1_decoy chrUn_KN707923v1_decoy chrUn_KN707924v1_decoy chrUn_KN707925v1_decoy chrUn_KN707926v1_decoy chrUn_KN707927v1_decoy chrUn_KN707928v1_decoy chrUn_KN707929v1_decoy chrUn_KN707930v1_decoy chrUn_KN707931v1_decoy chrUn_KN707932v1_decoy chrUn_KN707933v1_decoy chrUn_KN707934v1_decoy chrUn_KN707935v1_decoy chrUn_KN707936v1_decoy chrUn_KN707937v1_decoy chrUn_KN707938v1_decoy chrUn_KN707939v1_decoy chrUn_KN707940v1_decoy chrUn_KN707941v1_decoy chrUn_KN707942v1_decoy chrUn_KN707943v1_decoy chrUn_KN707944v1_decoy chrUn_KN707945v1_decoy chrUn_KN707946v1_decoy chrUn_KN707947v1_decoy chrUn_KN707948v1_decoy chrUn_KN707949v1_decoy chrUn_KN707950v1_decoy chrUn_KN707951v1_decoy chrUn_KN707952v1_decoy chrUn_KN707953v1_decoy chrUn_KN707954v1_decoy chrUn_KN707955v1_decoy chrUn_KN707956v1_decoy chrUn_KN707957v1_decoy chrUn_KN707958v1_decoy chrUn_KN707959v1_decoy chrUn_KN707960v1_decoy chrUn_KN707961v1_decoy chrUn_KN707962v1_decoy chrUn_KN707963v1_decoy chrUn_KN707964v1_decoy chrUn_KN707965v1_decoy chrUn_KN707966v1_decoy chrUn_KN707967v1_decoy chrUn_KN707968v1_decoy chrUn_KN707969v1_decoy chrUn_KN707970v1_decoy chrUn_KN707971v1_decoy chrUn_KN707972v1_decoy chrUn_KN707973v1_decoy chrUn_KN707974v1_decoy chrUn_KN707975v1_decoy chrUn_KN707976v1_decoy chrUn_KN707977v1_decoy chrUn_KN707978v1_decoy chrUn_KN707979v1_decoy chrUn_KN707980v1_decoy chrUn_KN707981v1_decoy chrUn_KN707982v1_decoy chrUn_KN707983v1_decoy chrUn_KN707984v1_decoy chrUn_KN707985v1_decoy chrUn_KN707986v1_decoy chrUn_KN707987v1_decoy chrUn_KN707988v1_decoy chrUn_KN707989v1_decoy chrUn_KN707990v1_decoy chrUn_KN707991v1_decoy chrUn_KN707992v1_decoy chrUn_JTFH01000001v1_decoy chrUn_JTFH01000002v1_decoy chrUn_JTFH01000003v1_decoy chrUn_JTFH01000004v1_decoy chrUn_JTFH01000005v1_decoy chrUn_JTFH01000006v1_decoy chrUn_JTFH01000007v1_decoy chrUn_JTFH01000008v1_decoy chrUn_JTFH01000009v1_decoy chrUn_JTFH01000010v1_decoy chrUn_JTFH01000011v1_decoy chrUn_JTFH01000012v1_decoy chrUn_JTFH01000013v1_decoy chrUn_JTFH01000014v1_decoy chrUn_JTFH01000015v1_decoy chrUn_JTFH01000016v1_decoy chrUn_JTFH01000017v1_decoy chrUn_JTFH01000018v1_decoy chrUn_JTFH01000019v1_decoy chrUn_JTFH01000020v1_decoy chrUn_JTFH01000021v1_decoy chrUn_JTFH01000022v1_decoy chrUn_JTFH01000023v1_decoy chrUn_JTFH01000024v1_decoy chrUn_JTFH01000025v1_decoy chrUn_JTFH01000026v1_decoy chrUn_JTFH01000027v1_decoy chrUn_JTFH01000028v1_decoy chrUn_JTFH01000029v1_decoy chrUn_JTFH01000030v1_decoy chrUn_JTFH01000031v1_decoy chrUn_JTFH01000032v1_decoy chrUn_JTFH01000033v1_decoy chrUn_JTFH01000034v1_decoy chrUn_JTFH01000035v1_decoy chrUn_JTFH01000036v1_decoy chrUn_JTFH01000037v1_decoy chrUn_JTFH01000038v1_decoy chrUn_JTFH01000039v1_decoy chrUn_JTFH01000040v1_decoy chrUn_JTFH01000041v1_decoy chrUn_JTFH01000042v1_decoy chrUn_JTFH01000043v1_decoy chrUn_JTFH01000044v1_decoy chrUn_JTFH01000045v1_decoy chrUn_JTFH01000046v1_decoy chrUn_JTFH01000047v1_decoy chrUn_JTFH01000048v1_decoy chrUn_JTFH01000049v1_decoy chrUn_JTFH01000050v1_decoy chrUn_JTFH01000051v1_decoy chrUn_JTFH01000052v1_decoy chrUn_JTFH01000053v1_decoy chrUn_JTFH01000054v1_decoy chrUn_JTFH01000055v1_decoy chrUn_JTFH01000056v1_decoy chrUn_JTFH01000057v1_decoy chrUn_JTFH01000058v1_decoy chrUn_JTFH01000059v1_decoy chrUn_JTFH01000060v1_decoy chrUn_JTFH01000061v1_decoy chrUn_JTFH01000062v1_decoy chrUn_JTFH01000063v1_decoy chrUn_JTFH01000064v1_decoy chrUn_JTFH01000065v1_decoy chrUn_JTFH01000066v1_decoy chrUn_JTFH01000067v1_decoy chrUn_JTFH01000068v1_decoy chrUn_JTFH01000069v1_decoy chrUn_JTFH01000070v1_decoy chrUn_JTFH01000071v1_decoy chrUn_JTFH01000072v1_decoy chrUn_JTFH01000073v1_decoy chrUn_JTFH01000074v1_decoy chrUn_JTFH01000075v1_decoy chrUn_JTFH01000076v1_decoy chrUn_JTFH01000077v1_decoy chrUn_JTFH01000078v1_decoy chrUn_JTFH01000079v1_decoy chrUn_JTFH01000080v1_decoy chrUn_JTFH01000081v1_decoy chrUn_JTFH01000082v1_decoy chrUn_JTFH01000083v1_decoy chrUn_JTFH01000084v1_decoy chrUn_JTFH01000085v1_decoy chrUn_JTFH01000086v1_decoy chrUn_JTFH01000087v1_decoy chrUn_JTFH01000088v1_decoy chrUn_JTFH01000089v1_decoy chrUn_JTFH01000090v1_decoy chrUn_JTFH01000091v1_decoy chrUn_JTFH01000092v1_decoy chrUn_JTFH01000093v1_decoy chrUn_JTFH01000094v1_decoy chrUn_JTFH01000095v1_decoy chrUn_JTFH01000096v1_decoy chrUn_JTFH01000097v1_decoy chrUn_JTFH01000098v1_decoy chrUn_JTFH01000099v1_decoy chrUn_JTFH01000100v1_decoy chrUn_JTFH01000101v1_decoy chrUn_JTFH01000102v1_decoy chrUn_JTFH01000103v1_decoy chrUn_JTFH01000104v1_decoy chrUn_JTFH01000105v1_decoy chrUn_JTFH01000106v1_decoy chrUn_JTFH01000107v1_decoy chrUn_JTFH01000108v1_decoy chrUn_JTFH01000109v1_decoy chrUn_JTFH01000110v1_decoy chrUn_JTFH01000111v1_decoy chrUn_JTFH01000112v1_decoy chrUn_JTFH01000113v1_decoy chrUn_JTFH01000114v1_decoy chrUn_JTFH01000115v1_decoy chrUn_JTFH01000116v1_decoy chrUn_JTFH01000117v1_decoy chrUn_JTFH01000118v1_decoy chrUn_JTFH01000119v1_decoy chrUn_JTFH01000120v1_decoy chrUn_JTFH01000121v1_decoy chrUn_JTFH01000122v1_decoy chrUn_JTFH01000123v1_decoy chrUn_JTFH01000124v1_decoy chrUn_JTFH01000125v1_decoy chrUn_JTFH01000126v1_decoy chrUn_JTFH01000127v1_decoy chrUn_JTFH01000128v1_decoy chrUn_JTFH01000129v1_decoy chrUn_JTFH01000130v1_decoy chrUn_JTFH01000131v1_decoy chrUn_JTFH01000132v1_decoy chrUn_JTFH01000133v1_decoy chrUn_JTFH01000134v1_decoy chrUn_JTFH01000135v1_decoy chrUn_JTFH01000136v1_decoy chrUn_JTFH01000137v1_decoy chrUn_JTFH01000138v1_decoy chrUn_JTFH01000139v1_decoy chrUn_JTFH01000140v1_decoy chrUn_JTFH01000141v1_decoy chrUn_JTFH01000142v1_decoy chrUn_JTFH01000143v1_decoy chrUn_JTFH01000144v1_decoy chrUn_JTFH01000145v1_decoy chrUn_JTFH01000146v1_decoy chrUn_JTFH01000147v1_decoy chrUn_JTFH01000148v1_decoy chrUn_JTFH01000149v1_decoy chrUn_JTFH01000150v1_decoy chrUn_JTFH01000151v1_decoy chrUn_JTFH01000152v1_decoy chrUn_JTFH01000153v1_decoy chrUn_JTFH01000154v1_decoy chrUn_JTFH01000155v1_decoy chrUn_JTFH01000156v1_decoy chrUn_JTFH01000157v1_decoy chrUn_JTFH01000158v1_decoy chrUn_JTFH01000159v1_decoy chrUn_JTFH01000160v1_decoy chrUn_JTFH01000161v1_decoy chrUn_JTFH01000162v1_decoy chrUn_JTFH01000163v1_decoy chrUn_JTFH01000164v1_decoy chrUn_JTFH01000165v1_decoy chrUn_JTFH01000166v1_decoy chrUn_JTFH01000167v1_decoy chrUn_JTFH01000168v1_decoy chrUn_JTFH01000169v1_decoy chrUn_JTFH01000170v1_decoy chrUn_JTFH01000171v1_decoy chrUn_JTFH01000172v1_decoy chrUn_JTFH01000173v1_decoy chrUn_JTFH01000174v1_decoy chrUn_JTFH01000175v1_decoy chrUn_JTFH01000176v1_decoy chrUn_JTFH01000177v1_decoy chrUn_JTFH01000178v1_decoy chrUn_JTFH01000179v1_decoy chrUn_JTFH01000180v1_decoy chrUn_JTFH01000181v1_decoy chrUn_JTFH01000182v1_decoy chrUn_JTFH01000183v1_decoy chrUn_JTFH01000184v1_decoy chrUn_JTFH01000185v1_decoy chrUn_JTFH01000186v1_decoy chrUn_JTFH01000187v1_decoy chrUn_JTFH01000188v1_decoy chrUn_JTFH01000189v1_decoy chrUn_JTFH01000190v1_decoy chrUn_JTFH01000191v1_decoy chrUn_JTFH01000192v1_decoy chrUn_JTFH01000193v1_decoy chrUn_JTFH01000194v1_decoy chrUn_JTFH01000195v1_decoy chrUn_JTFH01000196v1_decoy chrUn_JTFH01000197v1_decoy chrUn_JTFH01000198v1_decoy chrUn_JTFH01000199v1_decoy chrUn_JTFH01000200v1_decoy chrUn_JTFH01000201v1_decoy chrUn_JTFH01000202v1_decoy chrUn_JTFH01000203v1_decoy chrUn_JTFH01000204v1_decoy chrUn_JTFH01000205v1_decoy chrUn_JTFH01000206v1_decoy chrUn_JTFH01000207v1_decoy chrUn_JTFH01000208v1_decoy chrUn_JTFH01000209v1_decoy chrUn_JTFH01000210v1_decoy chrUn_JTFH01000211v1_decoy chrUn_JTFH01000212v1_decoy chrUn_JTFH01000213v1_decoy chrUn_JTFH01000214v1_decoy chrUn_JTFH01000215v1_decoy chrUn_JTFH01000216v1_decoy chrUn_JTFH01000217v1_decoy chrUn_JTFH01000218v1_decoy chrUn_JTFH01000219v1_decoy chrUn_JTFH01000220v1_decoy chrUn_JTFH01000221v1_decoy chrUn_JTFH01000222v1_decoy chrUn_JTFH01000223v1_decoy chrUn_JTFH01000224v1_decoy chrUn_JTFH01000225v1_decoy chrUn_JTFH01000226v1_decoy chrUn_JTFH01000227v1_decoy chrUn_JTFH01000228v1_decoy chrUn_JTFH01000229v1_decoy chrUn_JTFH01000230v1_decoy chrUn_JTFH01000231v1_decoy chrUn_JTFH01000232v1_decoy chrUn_JTFH01000233v1_decoy chrUn_JTFH01000234v1_decoy chrUn_JTFH01000235v1_decoy chrUn_JTFH01000236v1_decoy chrUn_JTFH01000237v1_decoy chrUn_JTFH01000238v1_decoy chrUn_JTFH01000239v1_decoy chrUn_JTFH01000240v1_decoy chrUn_JTFH01000241v1_decoy chrUn_JTFH01000242v1_decoy chrUn_JTFH01000243v1_decoy chrUn_JTFH01000244v1_decoy chrUn_JTFH01000245v1_decoy chrUn_JTFH01000246v1_decoy chrUn_JTFH01000247v1_decoy chrUn_JTFH01000248v1_decoy chrUn_JTFH01000249v1_decoy chrUn_JTFH01000250v1_decoy chrUn_JTFH01000251v1_decoy chrUn_JTFH01000252v1_decoy chrUn_JTFH01000253v1_decoy chrUn_JTFH01000254v1_decoy chrUn_JTFH01000255v1_decoy chrUn_JTFH01000256v1_decoy chrUn_JTFH01000257v1_decoy chrUn_JTFH01000258v1_decoy chrUn_JTFH01000259v1_decoy chrUn_JTFH01000260v1_decoy chrUn_JTFH01000261v1_decoy chrUn_JTFH01000262v1_decoy chrUn_JTFH01000263v1_decoy chrUn_JTFH01000264v1_decoy chrUn_JTFH01000265v1_decoy chrUn_JTFH01000266v1_decoy chrUn_JTFH01000267v1_decoy chrUn_JTFH01000268v1_decoy chrUn_JTFH01000269v1_decoy chrUn_JTFH01000270v1_decoy chrUn_JTFH01000271v1_decoy chrUn_JTFH01000272v1_decoy chrUn_JTFH01000273v1_decoy chrUn_JTFH01000274v1_decoy chrUn_JTFH01000275v1_decoy chrUn_JTFH01000276v1_decoy chrUn_JTFH01000277v1_decoy chrUn_JTFH01000278v1_decoy chrUn_JTFH01000279v1_decoy chrUn_JTFH01000280v1_decoy chrUn_JTFH01000281v1_decoy chrUn_JTFH01000282v1_decoy chrUn_JTFH01000283v1_decoy chrUn_JTFH01000284v1_decoy chrUn_JTFH01000285v1_decoy chrUn_JTFH01000286v1_decoy chrUn_JTFH01000287v1_decoy chrUn_JTFH01000288v1_decoy chrUn_JTFH01000289v1_decoy chrUn_JTFH01000290v1_decoy chrUn_JTFH01000291v1_decoy chrUn_JTFH01000292v1_decoy chrUn_JTFH01000293v1_decoy chrUn_JTFH01000294v1_decoy chrUn_JTFH01000295v1_decoy chrUn_JTFH01000296v1_decoy chrUn_JTFH01000297v1_decoy chrUn_JTFH01000298v1_decoy chrUn_JTFH01000299v1_decoy chrUn_JTFH01000300v1_decoy chrUn_JTFH01000301v1_decoy chrUn_JTFH01000302v1_decoy chrUn_JTFH01000303v1_decoy chrUn_JTFH01000304v1_decoy chrUn_JTFH01000305v1_decoy chrUn_JTFH01000306v1_decoy chrUn_JTFH01000307v1_decoy chrUn_JTFH01000308v1_decoy chrUn_JTFH01000309v1_decoy chrUn_JTFH01000310v1_decoy chrUn_JTFH01000311v1_decoy chrUn_JTFH01000312v1_decoy chrUn_JTFH01000313v1_decoy chrUn_JTFH01000314v1_decoy chrUn_JTFH01000315v1_decoy chrUn_JTFH01000316v1_decoy chrUn_JTFH01000317v1_decoy chrUn_JTFH01000318v1_decoy chrUn_JTFH01000319v1_decoy chrUn_JTFH01000320v1_decoy chrUn_JTFH01000321v1_decoy chrUn_JTFH01000322v1_decoy chrUn_JTFH01000323v1_decoy chrUn_JTFH01000324v1_decoy chrUn_JTFH01000325v1_decoy chrUn_JTFH01000326v1_decoy chrUn_JTFH01000327v1_decoy chrUn_JTFH01000328v1_decoy chrUn_JTFH01000329v1_decoy chrUn_JTFH01000330v1_decoy chrUn_JTFH01000331v1_decoy chrUn_JTFH01000332v1_decoy chrUn_JTFH01000333v1_decoy chrUn_JTFH01000334v1_decoy chrUn_JTFH01000335v1_decoy chrUn_JTFH01000336v1_decoy chrUn_JTFH01000337v1_decoy chrUn_JTFH01000338v1_decoy chrUn_JTFH01000339v1_decoy chrUn_JTFH01000340v1_decoy chrUn_JTFH01000341v1_decoy chrUn_JTFH01000342v1_decoy chrUn_JTFH01000343v1_decoy chrUn_JTFH01000344v1_decoy chrUn_JTFH01000345v1_decoy chrUn_JTFH01000346v1_decoy chrUn_JTFH01000347v1_decoy chrUn_JTFH01000348v1_decoy chrUn_JTFH01000349v1_decoy chrUn_JTFH01000350v1_decoy chrUn_JTFH01000351v1_decoy chrUn_JTFH01000352v1_decoy chrUn_JTFH01000353v1_decoy chrUn_JTFH01000354v1_decoy chrUn_JTFH01000355v1_decoy chrUn_JTFH01000356v1_decoy chrUn_JTFH01000357v1_decoy chrUn_JTFH01000358v1_decoy chrUn_JTFH01000359v1_decoy chrUn_JTFH01000360v1_decoy chrUn_JTFH01000361v1_decoy chrUn_JTFH01000362v1_decoy chrUn_JTFH01000363v1_decoy chrUn_JTFH01000364v1_decoy chrUn_JTFH01000365v1_decoy chrUn_JTFH01000366v1_decoy chrUn_JTFH01000367v1_decoy chrUn_JTFH01000368v1_decoy chrUn_JTFH01000369v1_decoy chrUn_JTFH01000370v1_decoy chrUn_JTFH01000371v1_decoy chrUn_JTFH01000372v1_decoy chrUn_JTFH01000373v1_decoy chrUn_JTFH01000374v1_decoy chrUn_JTFH01000375v1_decoy chrUn_JTFH01000376v1_decoy chrUn_JTFH01000377v1_decoy chrUn_JTFH01000378v1_decoy chrUn_JTFH01000379v1_decoy chrUn_JTFH01000380v1_decoy chrUn_JTFH01000381v1_decoy chrUn_JTFH01000382v1_decoy chrUn_JTFH01000383v1_decoy chrUn_JTFH01000384v1_decoy chrUn_JTFH01000385v1_decoy chrUn_JTFH01000386v1_decoy chrUn_JTFH01000387v1_decoy chrUn_JTFH01000388v1_decoy chrUn_JTFH01000389v1_decoy chrUn_JTFH01000390v1_decoy chrUn_JTFH01000391v1_decoy chrUn_JTFH01000392v1_decoy chrUn_JTFH01000393v1_decoy chrUn_JTFH01000394v1_decoy chrUn_JTFH01000395v1_decoy chrUn_JTFH01000396v1_decoy chrUn_JTFH01000397v1_decoy chrUn_JTFH01000398v1_decoy chrUn_JTFH01000399v1_decoy chrUn_JTFH01000400v1_decoy chrUn_JTFH01000401v1_decoy chrUn_JTFH01000402v1_decoy chrUn_JTFH01000403v1_decoy chrUn_JTFH01000404v1_decoy chrUn_JTFH01000405v1_decoy chrUn_JTFH01000406v1_decoy chrUn_JTFH01000407v1_decoy chrUn_JTFH01000408v1_decoy chrUn_JTFH01000409v1_decoy chrUn_JTFH01000410v1_decoy chrUn_JTFH01000411v1_decoy chrUn_JTFH01000412v1_decoy chrUn_JTFH01000413v1_decoy chrUn_JTFH01000414v1_decoy chrUn_JTFH01000415v1_decoy chrUn_JTFH01000416v1_decoy chrUn_JTFH01000417v1_decoy chrUn_JTFH01000418v1_decoy chrUn_JTFH01000419v1_decoy chrUn_JTFH01000420v1_decoy chrUn_JTFH01000421v1_decoy chrUn_JTFH01000422v1_decoy chrUn_JTFH01000423v1_decoy chrUn_JTFH01000424v1_decoy chrUn_JTFH01000425v1_decoy chrUn_JTFH01000426v1_decoy chrUn_JTFH01000427v1_decoy chrUn_JTFH01000428v1_decoy chrUn_JTFH01000429v1_decoy chrUn_JTFH01000430v1_decoy chrUn_JTFH01000431v1_decoy chrUn_JTFH01000432v1_decoy chrUn_JTFH01000433v1_decoy chrUn_JTFH01000434v1_decoy chrUn_JTFH01000435v1_decoy chrUn_JTFH01000436v1_decoy chrUn_JTFH01000437v1_decoy chrUn_JTFH01000438v1_decoy chrUn_JTFH01000439v1_decoy chrUn_JTFH01000440v1_decoy chrUn_JTFH01000441v1_decoy chrUn_JTFH01000442v1_decoy chrUn_JTFH01000443v1_decoy chrUn_JTFH01000444v1_decoy chrUn_JTFH01000445v1_decoy chrUn_JTFH01000446v1_decoy chrUn_JTFH01000447v1_decoy chrUn_JTFH01000448v1_decoy chrUn_JTFH01000449v1_decoy chrUn_JTFH01000450v1_decoy chrUn_JTFH01000451v1_decoy chrUn_JTFH01000452v1_decoy chrUn_JTFH01000453v1_decoy chrUn_JTFH01000454v1_decoy chrUn_JTFH01000455v1_decoy chrUn_JTFH01000456v1_decoy chrUn_JTFH01000457v1_decoy chrUn_JTFH01000458v1_decoy chrUn_JTFH01000459v1_decoy chrUn_JTFH01000460v1_decoy chrUn_JTFH01000461v1_decoy chrUn_JTFH01000462v1_decoy chrUn_JTFH01000463v1_decoy chrUn_JTFH01000464v1_decoy chrUn_JTFH01000465v1_decoy chrUn_JTFH01000466v1_decoy chrUn_JTFH01000467v1_decoy chrUn_JTFH01000468v1_decoy chrUn_JTFH01000469v1_decoy chrUn_JTFH01000470v1_decoy chrUn_JTFH01000471v1_decoy chrUn_JTFH01000472v1_decoy chrUn_JTFH01000473v1_decoy chrUn_JTFH01000474v1_decoy chrUn_JTFH01000475v1_decoy chrUn_JTFH01000476v1_decoy chrUn_JTFH01000477v1_decoy chrUn_JTFH01000478v1_decoy chrUn_JTFH01000479v1_decoy chrUn_JTFH01000480v1_decoy chrUn_JTFH01000481v1_decoy chrUn_JTFH01000482v1_decoy chrUn_JTFH01000483v1_decoy chrUn_JTFH01000484v1_decoy chrUn_JTFH01000485v1_decoy chrUn_JTFH01000486v1_decoy chrUn_JTFH01000487v1_decoy chrUn_JTFH01000488v1_decoy chrUn_JTFH01000489v1_decoy chrUn_JTFH01000490v1_decoy chrUn_JTFH01000491v1_decoy chrUn_JTFH01000492v1_decoy chrUn_JTFH01000493v1_decoy chrUn_JTFH01000494v1_decoy chrUn_JTFH01000495v1_decoy chrUn_JTFH01000496v1_decoy chrUn_JTFH01000497v1_decoy chrUn_JTFH01000498v1_decoy chrUn_JTFH01000499v1_decoy chrUn_JTFH01000500v1_decoy chrUn_JTFH01000501v1_decoy chrUn_JTFH01000502v1_decoy chrUn_JTFH01000503v1_decoy chrUn_JTFH01000504v1_decoy chrUn_JTFH01000505v1_decoy chrUn_JTFH01000506v1_decoy chrUn_JTFH01000507v1_decoy chrUn_JTFH01000508v1_decoy chrUn_JTFH01000509v1_decoy chrUn_JTFH01000510v1_decoy chrUn_JTFH01000511v1_decoy chrUn_JTFH01000512v1_decoy chrUn_JTFH01000513v1_decoy chrUn_JTFH01000514v1_decoy chrUn_JTFH01000515v1_decoy chrUn_JTFH01000516v1_decoy chrUn_JTFH01000517v1_decoy chrUn_JTFH01000518v1_decoy chrUn_JTFH01000519v1_decoy chrUn_JTFH01000520v1_decoy chrUn_JTFH01000521v1_decoy chrUn_JTFH01000522v1_decoy chrUn_JTFH01000523v1_decoy chrUn_JTFH01000524v1_decoy chrUn_JTFH01000525v1_decoy chrUn_JTFH01000526v1_decoy chrUn_JTFH01000527v1_decoy chrUn_JTFH01000528v1_decoy chrUn_JTFH01000529v1_decoy chrUn_JTFH01000530v1_decoy chrUn_JTFH01000531v1_decoy chrUn_JTFH01000532v1_decoy chrUn_JTFH01000533v1_decoy chrUn_JTFH01000534v1_decoy chrUn_JTFH01000535v1_decoy chrUn_JTFH01000536v1_decoy chrUn_JTFH01000537v1_decoy chrUn_JTFH01000538v1_decoy chrUn_JTFH01000539v1_decoy chrUn_JTFH01000540v1_decoy chrUn_JTFH01000541v1_decoy chrUn_JTFH01000542v1_decoy chrUn_JTFH01000543v1_decoy chrUn_JTFH01000544v1_decoy chrUn_JTFH01000545v1_decoy chrUn_JTFH01000546v1_decoy chrUn_JTFH01000547v1_decoy chrUn_JTFH01000548v1_decoy chrUn_JTFH01000549v1_decoy chrUn_JTFH01000550v1_decoy chrUn_JTFH01000551v1_decoy chrUn_JTFH01000552v1_decoy chrUn_JTFH01000553v1_decoy chrUn_JTFH01000554v1_decoy chrUn_JTFH01000555v1_decoy chrUn_JTFH01000556v1_decoy chrUn_JTFH01000557v1_decoy chrUn_JTFH01000558v1_decoy chrUn_JTFH01000559v1_decoy chrUn_JTFH01000560v1_decoy chrUn_JTFH01000561v1_decoy chrUn_JTFH01000562v1_decoy chrUn_JTFH01000563v1_decoy chrUn_JTFH01000564v1_decoy chrUn_JTFH01000565v1_decoy chrUn_JTFH01000566v1_decoy chrUn_JTFH01000567v1_decoy chrUn_JTFH01000568v1_decoy chrUn_JTFH01000569v1_decoy chrUn_JTFH01000570v1_decoy chrUn_JTFH01000571v1_decoy chrUn_JTFH01000572v1_decoy chrUn_JTFH01000573v1_decoy chrUn_JTFH01000574v1_decoy chrUn_JTFH01000575v1_decoy chrUn_JTFH01000576v1_decoy chrUn_JTFH01000577v1_decoy chrUn_JTFH01000578v1_decoy chrUn_JTFH01000579v1_decoy chrUn_JTFH01000580v1_decoy chrUn_JTFH01000581v1_decoy chrUn_JTFH01000582v1_decoy chrUn_JTFH01000583v1_decoy chrUn_JTFH01000584v1_decoy chrUn_JTFH01000585v1_decoy chrUn_JTFH01000586v1_decoy chrUn_JTFH01000587v1_decoy chrUn_JTFH01000588v1_decoy chrUn_JTFH01000589v1_decoy chrUn_JTFH01000590v1_decoy chrUn_JTFH01000591v1_decoy chrUn_JTFH01000592v1_decoy chrUn_JTFH01000593v1_decoy chrUn_JTFH01000594v1_decoy chrUn_JTFH01000595v1_decoy chrUn_JTFH01000596v1_decoy chrUn_JTFH01000597v1_decoy chrUn_JTFH01000598v1_decoy chrUn_JTFH01000599v1_decoy chrUn_JTFH01000600v1_decoy chrUn_JTFH01000601v1_decoy chrUn_JTFH01000602v1_decoy chrUn_JTFH01000603v1_decoy chrUn_JTFH01000604v1_decoy chrUn_JTFH01000605v1_decoy chrUn_JTFH01000606v1_decoy chrUn_JTFH01000607v1_decoy chrUn_JTFH01000608v1_decoy chrUn_JTFH01000609v1_decoy chrUn_JTFH01000610v1_decoy chrUn_JTFH01000611v1_decoy chrUn_JTFH01000612v1_decoy chrUn_JTFH01000613v1_decoy chrUn_JTFH01000614v1_decoy chrUn_JTFH01000615v1_decoy chrUn_JTFH01000616v1_decoy chrUn_JTFH01000617v1_decoy chrUn_JTFH01000618v1_decoy chrUn_JTFH01000619v1_decoy chrUn_JTFH01000620v1_decoy chrUn_JTFH01000621v1_decoy chrUn_JTFH01000622v1_decoy chrUn_JTFH01000623v1_decoy chrUn_JTFH01000624v1_decoy chrUn_JTFH01000625v1_decoy chrUn_JTFH01000626v1_decoy chrUn_JTFH01000627v1_decoy chrUn_JTFH01000628v1_decoy chrUn_JTFH01000629v1_decoy chrUn_JTFH01000630v1_decoy chrUn_JTFH01000631v1_decoy chrUn_JTFH01000632v1_decoy chrUn_JTFH01000633v1_decoy chrUn_JTFH01000634v1_decoy chrUn_JTFH01000635v1_decoy chrUn_JTFH01000636v1_decoy chrUn_JTFH01000637v1_decoy chrUn_JTFH01000638v1_decoy chrUn_JTFH01000639v1_decoy chrUn_JTFH01000640v1_decoy chrUn_JTFH01000641v1_decoy chrUn_JTFH01000642v1_decoy chrUn_JTFH01000643v1_decoy chrUn_JTFH01000644v1_decoy chrUn_JTFH01000645v1_decoy chrUn_JTFH01000646v1_decoy chrUn_JTFH01000647v1_decoy chrUn_JTFH01000648v1_decoy chrUn_JTFH01000649v1_decoy chrUn_JTFH01000650v1_decoy chrUn_JTFH01000651v1_decoy chrUn_JTFH01000652v1_decoy chrUn_JTFH01000653v1_decoy chrUn_JTFH01000654v1_decoy chrUn_JTFH01000655v1_decoy chrUn_JTFH01000656v1_decoy chrUn_JTFH01000657v1_decoy chrUn_JTFH01000658v1_decoy chrUn_JTFH01000659v1_decoy chrUn_JTFH01000660v1_decoy chrUn_JTFH01000661v1_decoy chrUn_JTFH01000662v1_decoy chrUn_JTFH01000663v1_decoy chrUn_JTFH01000664v1_decoy chrUn_JTFH01000665v1_decoy chrUn_JTFH01000666v1_decoy chrUn_JTFH01000667v1_decoy chrUn_JTFH01000668v1_decoy chrUn_JTFH01000669v1_decoy chrUn_JTFH01000670v1_decoy chrUn_JTFH01000671v1_decoy chrUn_JTFH01000672v1_decoy chrUn_JTFH01000673v1_decoy chrUn_JTFH01000674v1_decoy chrUn_JTFH01000675v1_decoy chrUn_JTFH01000676v1_decoy chrUn_JTFH01000677v1_decoy chrUn_JTFH01000678v1_decoy chrUn_JTFH01000679v1_decoy chrUn_JTFH01000680v1_decoy chrUn_JTFH01000681v1_decoy chrUn_JTFH01000682v1_decoy chrUn_JTFH01000683v1_decoy chrUn_JTFH01000684v1_decoy chrUn_JTFH01000685v1_decoy chrUn_JTFH01000686v1_decoy chrUn_JTFH01000687v1_decoy chrUn_JTFH01000688v1_decoy chrUn_JTFH01000689v1_decoy chrUn_JTFH01000690v1_decoy chrUn_JTFH01000691v1_decoy chrUn_JTFH01000692v1_decoy chrUn_JTFH01000693v1_decoy chrUn_JTFH01000694v1_decoy chrUn_JTFH01000695v1_decoy chrUn_JTFH01000696v1_decoy chrUn_JTFH01000697v1_decoy chrUn_JTFH01000698v1_decoy chrUn_JTFH01000699v1_decoy chrUn_JTFH01000700v1_decoy chrUn_JTFH01000701v1_decoy chrUn_JTFH01000702v1_decoy chrUn_JTFH01000703v1_decoy chrUn_JTFH01000704v1_decoy chrUn_JTFH01000705v1_decoy chrUn_JTFH01000706v1_decoy chrUn_JTFH01000707v1_decoy chrUn_JTFH01000708v1_decoy chrUn_JTFH01000709v1_decoy chrUn_JTFH01000710v1_decoy chrUn_JTFH01000711v1_decoy chrUn_JTFH01000712v1_decoy chrUn_JTFH01000713v1_decoy chrUn_JTFH01000714v1_decoy chrUn_JTFH01000715v1_decoy chrUn_JTFH01000716v1_decoy chrUn_JTFH01000717v1_decoy chrUn_JTFH01000718v1_decoy chrUn_JTFH01000719v1_decoy chrUn_JTFH01000720v1_decoy chrUn_JTFH01000721v1_decoy chrUn_JTFH01000722v1_decoy chrUn_JTFH01000723v1_decoy chrUn_JTFH01000724v1_decoy chrUn_JTFH01000725v1_decoy chrUn_JTFH01000726v1_decoy chrUn_JTFH01000727v1_decoy chrUn_JTFH01000728v1_decoy chrUn_JTFH01000729v1_decoy chrUn_JTFH01000730v1_decoy chrUn_JTFH01000731v1_decoy chrUn_JTFH01000732v1_decoy chrUn_JTFH01000733v1_decoy chrUn_JTFH01000734v1_decoy chrUn_JTFH01000735v1_decoy chrUn_JTFH01000736v1_decoy chrUn_JTFH01000737v1_decoy chrUn_JTFH01000738v1_decoy chrUn_JTFH01000739v1_decoy chrUn_JTFH01000740v1_decoy chrUn_JTFH01000741v1_decoy chrUn_JTFH01000742v1_decoy chrUn_JTFH01000743v1_decoy chrUn_JTFH01000744v1_decoy chrUn_JTFH01000745v1_decoy chrUn_JTFH01000746v1_decoy chrUn_JTFH01000747v1_decoy chrUn_JTFH01000748v1_decoy chrUn_JTFH01000749v1_decoy chrUn_JTFH01000750v1_decoy chrUn_JTFH01000751v1_decoy chrUn_JTFH01000752v1_decoy chrUn_JTFH01000753v1_decoy chrUn_JTFH01000754v1_decoy chrUn_JTFH01000755v1_decoy chrUn_JTFH01000756v1_decoy chrUn_JTFH01000757v1_decoy chrUn_JTFH01000758v1_decoy chrUn_JTFH01000759v1_decoy chrUn_JTFH01000760v1_decoy chrUn_JTFH01000761v1_decoy chrUn_JTFH01000762v1_decoy chrUn_JTFH01000763v1_decoy chrUn_JTFH01000764v1_decoy chrUn_JTFH01000765v1_decoy chrUn_JTFH01000766v1_decoy chrUn_JTFH01000767v1_decoy chrUn_JTFH01000768v1_decoy chrUn_JTFH01000769v1_decoy chrUn_JTFH01000770v1_decoy chrUn_JTFH01000771v1_decoy chrUn_JTFH01000772v1_decoy chrUn_JTFH01000773v1_decoy chrUn_JTFH01000774v1_decoy chrUn_JTFH01000775v1_decoy chrUn_JTFH01000776v1_decoy chrUn_JTFH01000777v1_decoy chrUn_JTFH01000778v1_decoy chrUn_JTFH01000779v1_decoy chrUn_JTFH01000780v1_decoy chrUn_JTFH01000781v1_decoy chrUn_JTFH01000782v1_decoy chrUn_JTFH01000783v1_decoy chrUn_JTFH01000784v1_decoy chrUn_JTFH01000785v1_decoy chrUn_JTFH01000786v1_decoy chrUn_JTFH01000787v1_decoy chrUn_JTFH01000788v1_decoy chrUn_JTFH01000789v1_decoy chrUn_JTFH01000790v1_decoy chrUn_JTFH01000791v1_decoy chrUn_JTFH01000792v1_decoy chrUn_JTFH01000793v1_decoy chrUn_JTFH01000794v1_decoy chrUn_JTFH01000795v1_decoy chrUn_JTFH01000796v1_decoy chrUn_JTFH01000797v1_decoy chrUn_JTFH01000798v1_decoy chrUn_JTFH01000799v1_decoy chrUn_JTFH01000800v1_decoy chrUn_JTFH01000801v1_decoy chrUn_JTFH01000802v1_decoy chrUn_JTFH01000803v1_decoy chrUn_JTFH01000804v1_decoy chrUn_JTFH01000805v1_decoy chrUn_JTFH01000806v1_decoy chrUn_JTFH01000807v1_decoy chrUn_JTFH01000808v1_decoy chrUn_JTFH01000809v1_decoy chrUn_JTFH01000810v1_decoy chrUn_JTFH01000811v1_decoy chrUn_JTFH01000812v1_decoy chrUn_JTFH01000813v1_decoy chrUn_JTFH01000814v1_decoy chrUn_JTFH01000815v1_decoy chrUn_JTFH01000816v1_decoy chrUn_JTFH01000817v1_decoy chrUn_JTFH01000818v1_decoy chrUn_JTFH01000819v1_decoy chrUn_JTFH01000820v1_decoy chrUn_JTFH01000821v1_decoy chrUn_JTFH01000822v1_decoy chrUn_JTFH01000823v1_decoy chrUn_JTFH01000824v1_decoy chrUn_JTFH01000825v1_decoy chrUn_JTFH01000826v1_decoy chrUn_JTFH01000827v1_decoy chrUn_JTFH01000828v1_decoy chrUn_JTFH01000829v1_decoy chrUn_JTFH01000830v1_decoy chrUn_JTFH01000831v1_decoy chrUn_JTFH01000832v1_decoy chrUn_JTFH01000833v1_decoy chrUn_JTFH01000834v1_decoy chrUn_JTFH01000835v1_decoy chrUn_JTFH01000836v1_decoy chrUn_JTFH01000837v1_decoy chrUn_JTFH01000838v1_decoy chrUn_JTFH01000839v1_decoy chrUn_JTFH01000840v1_decoy chrUn_JTFH01000841v1_decoy chrUn_JTFH01000842v1_decoy chrUn_JTFH01000843v1_decoy chrUn_JTFH01000844v1_decoy chrUn_JTFH01000845v1_decoy chrUn_JTFH01000846v1_decoy chrUn_JTFH01000847v1_decoy chrUn_JTFH01000848v1_decoy chrUn_JTFH01000849v1_decoy chrUn_JTFH01000850v1_decoy chrUn_JTFH01000851v1_decoy chrUn_JTFH01000852v1_decoy chrUn_JTFH01000853v1_decoy chrUn_JTFH01000854v1_decoy chrUn_JTFH01000855v1_decoy chrUn_JTFH01000856v1_decoy chrUn_JTFH01000857v1_decoy chrUn_JTFH01000858v1_decoy chrUn_JTFH01000859v1_decoy chrUn_JTFH01000860v1_decoy chrUn_JTFH01000861v1_decoy chrUn_JTFH01000862v1_decoy chrUn_JTFH01000863v1_decoy chrUn_JTFH01000864v1_decoy chrUn_JTFH01000865v1_decoy chrUn_JTFH01000866v1_decoy chrUn_JTFH01000867v1_decoy chrUn_JTFH01000868v1_decoy chrUn_JTFH01000869v1_decoy chrUn_JTFH01000870v1_decoy chrUn_JTFH01000871v1_decoy chrUn_JTFH01000872v1_decoy chrUn_JTFH01000873v1_decoy chrUn_JTFH01000874v1_decoy chrUn_JTFH01000875v1_decoy chrUn_JTFH01000876v1_decoy chrUn_JTFH01000877v1_decoy chrUn_JTFH01000878v1_decoy chrUn_JTFH01000879v1_decoy chrUn_JTFH01000880v1_decoy chrUn_JTFH01000881v1_decoy chrUn_JTFH01000882v1_decoy chrUn_JTFH01000883v1_decoy chrUn_JTFH01000884v1_decoy chrUn_JTFH01000885v1_decoy chrUn_JTFH01000886v1_decoy chrUn_JTFH01000887v1_decoy chrUn_JTFH01000888v1_decoy chrUn_JTFH01000889v1_decoy chrUn_JTFH01000890v1_decoy chrUn_JTFH01000891v1_decoy chrUn_JTFH01000892v1_decoy chrUn_JTFH01000893v1_decoy chrUn_JTFH01000894v1_decoy chrUn_JTFH01000895v1_decoy chrUn_JTFH01000896v1_decoy chrUn_JTFH01000897v1_decoy chrUn_JTFH01000898v1_decoy chrUn_JTFH01000899v1_decoy chrUn_JTFH01000900v1_decoy chrUn_JTFH01000901v1_decoy chrUn_JTFH01000902v1_decoy chrUn_JTFH01000903v1_decoy chrUn_JTFH01000904v1_decoy chrUn_JTFH01000905v1_decoy chrUn_JTFH01000906v1_decoy chrUn_JTFH01000907v1_decoy chrUn_JTFH01000908v1_decoy chrUn_JTFH01000909v1_decoy chrUn_JTFH01000910v1_decoy chrUn_JTFH01000911v1_decoy chrUn_JTFH01000912v1_decoy chrUn_JTFH01000913v1_decoy chrUn_JTFH01000914v1_decoy chrUn_JTFH01000915v1_decoy chrUn_JTFH01000916v1_decoy chrUn_JTFH01000917v1_decoy chrUn_JTFH01000918v1_decoy chrUn_JTFH01000919v1_decoy chrUn_JTFH01000920v1_decoy chrUn_JTFH01000921v1_decoy chrUn_JTFH01000922v1_decoy chrUn_JTFH01000923v1_decoy chrUn_JTFH01000924v1_decoy chrUn_JTFH01000925v1_decoy chrUn_JTFH01000926v1_decoy chrUn_JTFH01000927v1_decoy chrUn_JTFH01000928v1_decoy chrUn_JTFH01000929v1_decoy chrUn_JTFH01000930v1_decoy chrUn_JTFH01000931v1_decoy chrUn_JTFH01000932v1_decoy chrUn_JTFH01000933v1_decoy chrUn_JTFH01000934v1_decoy chrUn_JTFH01000935v1_decoy chrUn_JTFH01000936v1_decoy chrUn_JTFH01000937v1_decoy chrUn_JTFH01000938v1_decoy chrUn_JTFH01000939v1_decoy chrUn_JTFH01000940v1_decoy chrUn_JTFH01000941v1_decoy chrUn_JTFH01000942v1_decoy chrUn_JTFH01000943v1_decoy chrUn_JTFH01000944v1_decoy chrUn_JTFH01000945v1_decoy chrUn_JTFH01000946v1_decoy chrUn_JTFH01000947v1_decoy chrUn_JTFH01000948v1_decoy chrUn_JTFH01000949v1_decoy chrUn_JTFH01000950v1_decoy chrUn_JTFH01000951v1_decoy chrUn_JTFH01000952v1_decoy chrUn_JTFH01000953v1_decoy chrUn_JTFH01000954v1_decoy chrUn_JTFH01000955v1_decoy chrUn_JTFH01000956v1_decoy chrUn_JTFH01000957v1_decoy chrUn_JTFH01000958v1_decoy chrUn_JTFH01000959v1_decoy chrUn_JTFH01000960v1_decoy chrUn_JTFH01000961v1_decoy chrUn_JTFH01000962v1_decoy chrUn_JTFH01000963v1_decoy chrUn_JTFH01000964v1_decoy chrUn_JTFH01000965v1_decoy chrUn_JTFH01000966v1_decoy chrUn_JTFH01000967v1_decoy chrUn_JTFH01000968v1_decoy chrUn_JTFH01000969v1_decoy chrUn_JTFH01000970v1_decoy chrUn_JTFH01000971v1_decoy chrUn_JTFH01000972v1_decoy chrUn_JTFH01000973v1_decoy chrUn_JTFH01000974v1_decoy chrUn_JTFH01000975v1_decoy chrUn_JTFH01000976v1_decoy chrUn_JTFH01000977v1_decoy chrUn_JTFH01000978v1_decoy chrUn_JTFH01000979v1_decoy chrUn_JTFH01000980v1_decoy chrUn_JTFH01000981v1_decoy chrUn_JTFH01000982v1_decoy chrUn_JTFH01000983v1_decoy chrUn_JTFH01000984v1_decoy chrUn_JTFH01000985v1_decoy chrUn_JTFH01000986v1_decoy chrUn_JTFH01000987v1_decoy chrUn_JTFH01000988v1_decoy chrUn_JTFH01000989v1_decoy chrUn_JTFH01000990v1_decoy chrUn_JTFH01000991v1_decoy chrUn_JTFH01000992v1_decoy chrUn_JTFH01000993v1_decoy chrUn_JTFH01000994v1_decoy chrUn_JTFH01000995v1_decoy chrUn_JTFH01000996v1_decoy chrUn_JTFH01000997v1_decoy chrUn_JTFH01000998v1_decoy chrUn_JTFH01000999v1_decoy chrUn_JTFH01001000v1_decoy chrUn_JTFH01001001v1_decoy chrUn_JTFH01001002v1_decoy chrUn_JTFH01001003v1_decoy chrUn_JTFH01001004v1_decoy chrUn_JTFH01001005v1_decoy chrUn_JTFH01001006v1_decoy chrUn_JTFH01001007v1_decoy chrUn_JTFH01001008v1_decoy chrUn_JTFH01001009v1_decoy chrUn_JTFH01001010v1_decoy chrUn_JTFH01001011v1_decoy chrUn_JTFH01001012v1_decoy chrUn_JTFH01001013v1_decoy chrUn_JTFH01001014v1_decoy chrUn_JTFH01001015v1_decoy chrUn_JTFH01001016v1_decoy chrUn_JTFH01001017v1_decoy chrUn_JTFH01001018v1_decoy chrUn_JTFH01001019v1_decoy chrUn_JTFH01001020v1_decoy chrUn_JTFH01001021v1_decoy chrUn_JTFH01001022v1_decoy chrUn_JTFH01001023v1_decoy chrUn_JTFH01001024v1_decoy chrUn_JTFH01001025v1_decoy chrUn_JTFH01001026v1_decoy chrUn_JTFH01001027v1_decoy chrUn_JTFH01001028v1_decoy chrUn_JTFH01001029v1_decoy chrUn_JTFH01001030v1_decoy chrUn_JTFH01001031v1_decoy chrUn_JTFH01001032v1_decoy chrUn_JTFH01001033v1_decoy chrUn_JTFH01001034v1_decoy chrUn_JTFH01001035v1_decoy chrUn_JTFH01001036v1_decoy chrUn_JTFH01001037v1_decoy chrUn_JTFH01001038v1_decoy chrUn_JTFH01001039v1_decoy chrUn_JTFH01001040v1_decoy chrUn_JTFH01001041v1_decoy chrUn_JTFH01001042v1_decoy chrUn_JTFH01001043v1_decoy chrUn_JTFH01001044v1_decoy chrUn_JTFH01001045v1_decoy chrUn_JTFH01001046v1_decoy chrUn_JTFH01001047v1_decoy chrUn_JTFH01001048v1_decoy chrUn_JTFH01001049v1_decoy chrUn_JTFH01001050v1_decoy chrUn_JTFH01001051v1_decoy chrUn_JTFH01001052v1_decoy chrUn_JTFH01001053v1_decoy chrUn_JTFH01001054v1_decoy chrUn_JTFH01001055v1_decoy chrUn_JTFH01001056v1_decoy chrUn_JTFH01001057v1_decoy chrUn_JTFH01001058v1_decoy chrUn_JTFH01001059v1_decoy chrUn_JTFH01001060v1_decoy chrUn_JTFH01001061v1_decoy chrUn_JTFH01001062v1_decoy chrUn_JTFH01001063v1_decoy chrUn_JTFH01001064v1_decoy chrUn_JTFH01001065v1_decoy chrUn_JTFH01001066v1_decoy chrUn_JTFH01001067v1_decoy chrUn_JTFH01001068v1_decoy chrUn_JTFH01001069v1_decoy chrUn_JTFH01001070v1_decoy chrUn_JTFH01001071v1_decoy chrUn_JTFH01001072v1_decoy chrUn_JTFH01001073v1_decoy chrUn_JTFH01001074v1_decoy chrUn_JTFH01001075v1_decoy chrUn_JTFH01001076v1_decoy chrUn_JTFH01001077v1_decoy chrUn_JTFH01001078v1_decoy chrUn_JTFH01001079v1_decoy chrUn_JTFH01001080v1_decoy chrUn_JTFH01001081v1_decoy chrUn_JTFH01001082v1_decoy chrUn_JTFH01001083v1_decoy chrUn_JTFH01001084v1_decoy chrUn_JTFH01001085v1_decoy chrUn_JTFH01001086v1_decoy chrUn_JTFH01001087v1_decoy chrUn_JTFH01001088v1_decoy chrUn_JTFH01001089v1_decoy chrUn_JTFH01001090v1_decoy chrUn_JTFH01001091v1_decoy chrUn_JTFH01001092v1_decoy chrUn_JTFH01001093v1_decoy chrUn_JTFH01001094v1_decoy chrUn_JTFH01001095v1_decoy chrUn_JTFH01001096v1_decoy chrUn_JTFH01001097v1_decoy chrUn_JTFH01001098v1_decoy chrUn_JTFH01001099v1_decoy chrUn_JTFH01001100v1_decoy chrUn_JTFH01001101v1_decoy chrUn_JTFH01001102v1_decoy chrUn_JTFH01001103v1_decoy chrUn_JTFH01001104v1_decoy chrUn_JTFH01001105v1_decoy chrUn_JTFH01001106v1_decoy chrUn_JTFH01001107v1_decoy chrUn_JTFH01001108v1_decoy chrUn_JTFH01001109v1_decoy chrUn_JTFH01001110v1_decoy chrUn_JTFH01001111v1_decoy chrUn_JTFH01001112v1_decoy chrUn_JTFH01001113v1_decoy chrUn_JTFH01001114v1_decoy chrUn_JTFH01001115v1_decoy chrUn_JTFH01001116v1_decoy chrUn_JTFH01001117v1_decoy chrUn_JTFH01001118v1_decoy chrUn_JTFH01001119v1_decoy chrUn_JTFH01001120v1_decoy chrUn_JTFH01001121v1_decoy chrUn_JTFH01001122v1_decoy chrUn_JTFH01001123v1_decoy chrUn_JTFH01001124v1_decoy chrUn_JTFH01001125v1_decoy chrUn_JTFH01001126v1_decoy chrUn_JTFH01001127v1_decoy chrUn_JTFH01001128v1_decoy chrUn_JTFH01001129v1_decoy chrUn_JTFH01001130v1_decoy chrUn_JTFH01001131v1_decoy chrUn_JTFH01001132v1_decoy chrUn_JTFH01001133v1_decoy chrUn_JTFH01001134v1_decoy chrUn_JTFH01001135v1_decoy chrUn_JTFH01001136v1_decoy chrUn_JTFH01001137v1_decoy chrUn_JTFH01001138v1_decoy chrUn_JTFH01001139v1_decoy chrUn_JTFH01001140v1_decoy chrUn_JTFH01001141v1_decoy chrUn_JTFH01001142v1_decoy chrUn_JTFH01001143v1_decoy chrUn_JTFH01001144v1_decoy chrUn_JTFH01001145v1_decoy chrUn_JTFH01001146v1_decoy chrUn_JTFH01001147v1_decoy chrUn_JTFH01001148v1_decoy chrUn_JTFH01001149v1_decoy chrUn_JTFH01001150v1_decoy chrUn_JTFH01001151v1_decoy chrUn_JTFH01001152v1_decoy chrUn_JTFH01001153v1_decoy chrUn_JTFH01001154v1_decoy chrUn_JTFH01001155v1_decoy chrUn_JTFH01001156v1_decoy chrUn_JTFH01001157v1_decoy chrUn_JTFH01001158v1_decoy chrUn_JTFH01001159v1_decoy chrUn_JTFH01001160v1_decoy chrUn_JTFH01001161v1_decoy chrUn_JTFH01001162v1_decoy chrUn_JTFH01001163v1_decoy chrUn_JTFH01001164v1_decoy chrUn_JTFH01001165v1_decoy chrUn_JTFH01001166v1_decoy chrUn_JTFH01001167v1_decoy chrUn_JTFH01001168v1_decoy chrUn_JTFH01001169v1_decoy chrUn_JTFH01001170v1_decoy chrUn_JTFH01001171v1_decoy chrUn_JTFH01001172v1_decoy chrUn_JTFH01001173v1_decoy chrUn_JTFH01001174v1_decoy chrUn_JTFH01001175v1_decoy chrUn_JTFH01001176v1_decoy chrUn_JTFH01001177v1_decoy chrUn_JTFH01001178v1_decoy chrUn_JTFH01001179v1_decoy chrUn_JTFH01001180v1_decoy chrUn_JTFH01001181v1_decoy chrUn_JTFH01001182v1_decoy chrUn_JTFH01001183v1_decoy chrUn_JTFH01001184v1_decoy chrUn_JTFH01001185v1_decoy chrUn_JTFH01001186v1_decoy chrUn_JTFH01001187v1_decoy chrUn_JTFH01001188v1_decoy chrUn_JTFH01001189v1_decoy chrUn_JTFH01001190v1_decoy chrUn_JTFH01001191v1_decoy chrUn_JTFH01001192v1_decoy chrUn_JTFH01001193v1_decoy chrUn_JTFH01001194v1_decoy chrUn_JTFH01001195v1_decoy chrUn_JTFH01001196v1_decoy chrUn_JTFH01001197v1_decoy chrUn_JTFH01001198v1_decoy chrUn_JTFH01001199v1_decoy chrUn_JTFH01001200v1_decoy chrUn_JTFH01001201v1_decoy chrUn_JTFH01001202v1_decoy chrUn_JTFH01001203v1_decoy chrUn_JTFH01001204v1_decoy chrUn_JTFH01001205v1_decoy chrUn_JTFH01001206v1_decoy chrUn_JTFH01001207v1_decoy chrUn_JTFH01001208v1_decoy chrUn_JTFH01001209v1_decoy chrUn_JTFH01001210v1_decoy chrUn_JTFH01001211v1_decoy chrUn_JTFH01001212v1_decoy chrUn_JTFH01001213v1_decoy chrUn_JTFH01001214v1_decoy chrUn_JTFH01001215v1_decoy chrUn_JTFH01001216v1_decoy chrUn_JTFH01001217v1_decoy chrUn_JTFH01001218v1_decoy chrUn_JTFH01001219v1_decoy chrUn_JTFH01001220v1_decoy chrUn_JTFH01001221v1_decoy chrUn_JTFH01001222v1_decoy chrUn_JTFH01001223v1_decoy chrUn_JTFH01001224v1_decoy chrUn_JTFH01001225v1_decoy chrUn_JTFH01001226v1_decoy chrUn_JTFH01001227v1_decoy chrUn_JTFH01001228v1_decoy chrUn_JTFH01001229v1_decoy chrUn_JTFH01001230v1_decoy chrUn_JTFH01001231v1_decoy chrUn_JTFH01001232v1_decoy chrUn_JTFH01001233v1_decoy chrUn_JTFH01001234v1_decoy chrUn_JTFH01001235v1_decoy chrUn_JTFH01001236v1_decoy chrUn_JTFH01001237v1_decoy chrUn_JTFH01001238v1_decoy chrUn_JTFH01001239v1_decoy chrUn_JTFH01001240v1_decoy chrUn_JTFH01001241v1_decoy chrUn_JTFH01001242v1_decoy chrUn_JTFH01001243v1_decoy chrUn_JTFH01001244v1_decoy chrUn_JTFH01001245v1_decoy chrUn_JTFH01001246v1_decoy chrUn_JTFH01001247v1_decoy chrUn_JTFH01001248v1_decoy chrUn_JTFH01001249v1_decoy chrUn_JTFH01001250v1_decoy chrUn_JTFH01001251v1_decoy chrUn_JTFH01001252v1_decoy chrUn_JTFH01001253v1_decoy chrUn_JTFH01001254v1_decoy chrUn_JTFH01001255v1_decoy chrUn_JTFH01001256v1_decoy chrUn_JTFH01001257v1_decoy chrUn_JTFH01001258v1_decoy chrUn_JTFH01001259v1_decoy chrUn_JTFH01001260v1_decoy chrUn_JTFH01001261v1_decoy chrUn_JTFH01001262v1_decoy chrUn_JTFH01001263v1_decoy chrUn_JTFH01001264v1_decoy chrUn_JTFH01001265v1_decoy chrUn_JTFH01001266v1_decoy chrUn_JTFH01001267v1_decoy chrUn_JTFH01001268v1_decoy chrUn_JTFH01001269v1_decoy chrUn_JTFH01001270v1_decoy chrUn_JTFH01001271v1_decoy chrUn_JTFH01001272v1_decoy chrUn_JTFH01001273v1_decoy chrUn_JTFH01001274v1_decoy chrUn_JTFH01001275v1_decoy chrUn_JTFH01001276v1_decoy chrUn_JTFH01001277v1_decoy chrUn_JTFH01001278v1_decoy chrUn_JTFH01001279v1_decoy chrUn_JTFH01001280v1_decoy chrUn_JTFH01001281v1_decoy chrUn_JTFH01001282v1_decoy chrUn_JTFH01001283v1_decoy chrUn_JTFH01001284v1_decoy chrUn_JTFH01001285v1_decoy chrUn_JTFH01001286v1_decoy chrUn_JTFH01001287v1_decoy chrUn_JTFH01001288v1_decoy chrUn_JTFH01001289v1_decoy chrUn_JTFH01001290v1_decoy chrUn_JTFH01001291v1_decoy chrUn_JTFH01001292v1_decoy chrUn_JTFH01001293v1_decoy chrUn_JTFH01001294v1_decoy chrUn_JTFH01001295v1_decoy chrUn_JTFH01001296v1_decoy chrUn_JTFH01001297v1_decoy chrUn_JTFH01001298v1_decoy chrUn_JTFH01001299v1_decoy chrUn_JTFH01001300v1_decoy chrUn_JTFH01001301v1_decoy chrUn_JTFH01001302v1_decoy chrUn_JTFH01001303v1_decoy chrUn_JTFH01001304v1_decoy chrUn_JTFH01001305v1_decoy chrUn_JTFH01001306v1_decoy chrUn_JTFH01001307v1_decoy chrUn_JTFH01001308v1_decoy chrUn_JTFH01001309v1_decoy chrUn_JTFH01001310v1_decoy chrUn_JTFH01001311v1_decoy chrUn_JTFH01001312v1_decoy chrUn_JTFH01001313v1_decoy chrUn_JTFH01001314v1_decoy chrUn_JTFH01001315v1_decoy chrUn_JTFH01001316v1_decoy chrUn_JTFH01001317v1_decoy chrUn_JTFH01001318v1_decoy chrUn_JTFH01001319v1_decoy chrUn_JTFH01001320v1_decoy chrUn_JTFH01001321v1_decoy chrUn_JTFH01001322v1_decoy chrUn_JTFH01001323v1_decoy chrUn_JTFH01001324v1_decoy chrUn_JTFH01001325v1_decoy chrUn_JTFH01001326v1_decoy chrUn_JTFH01001327v1_decoy chrUn_JTFH01001328v1_decoy chrUn_JTFH01001329v1_decoy chrUn_JTFH01001330v1_decoy chrUn_JTFH01001331v1_decoy chrUn_JTFH01001332v1_decoy chrUn_JTFH01001333v1_decoy chrUn_JTFH01001334v1_decoy chrUn_JTFH01001335v1_decoy chrUn_JTFH01001336v1_decoy chrUn_JTFH01001337v1_decoy chrUn_JTFH01001338v1_decoy chrUn_JTFH01001339v1_decoy chrUn_JTFH01001340v1_decoy chrUn_JTFH01001341v1_decoy chrUn_JTFH01001342v1_decoy chrUn_JTFH01001343v1_decoy chrUn_JTFH01001344v1_decoy chrUn_JTFH01001345v1_decoy chrUn_JTFH01001346v1_decoy chrUn_JTFH01001347v1_decoy chrUn_JTFH01001348v1_decoy chrUn_JTFH01001349v1_decoy chrUn_JTFH01001350v1_decoy chrUn_JTFH01001351v1_decoy chrUn_JTFH01001352v1_decoy chrUn_JTFH01001353v1_decoy chrUn_JTFH01001354v1_decoy chrUn_JTFH01001355v1_decoy chrUn_JTFH01001356v1_decoy chrUn_JTFH01001357v1_decoy chrUn_JTFH01001358v1_decoy chrUn_JTFH01001359v1_decoy chrUn_JTFH01001360v1_decoy chrUn_JTFH01001361v1_decoy chrUn_JTFH01001362v1_decoy chrUn_JTFH01001363v1_decoy chrUn_JTFH01001364v1_decoy chrUn_JTFH01001365v1_decoy chrUn_JTFH01001366v1_decoy chrUn_JTFH01001367v1_decoy chrUn_JTFH01001368v1_decoy chrUn_JTFH01001369v1_decoy chrUn_JTFH01001370v1_decoy chrUn_JTFH01001371v1_decoy chrUn_JTFH01001372v1_decoy chrUn_JTFH01001373v1_decoy chrUn_JTFH01001374v1_decoy chrUn_JTFH01001375v1_decoy chrUn_JTFH01001376v1_decoy chrUn_JTFH01001377v1_decoy chrUn_JTFH01001378v1_decoy chrUn_JTFH01001379v1_decoy chrUn_JTFH01001380v1_decoy chrUn_JTFH01001381v1_decoy chrUn_JTFH01001382v1_decoy chrUn_JTFH01001383v1_decoy chrUn_JTFH01001384v1_decoy chrUn_JTFH01001385v1_decoy chrUn_JTFH01001386v1_decoy chrUn_JTFH01001387v1_decoy chrUn_JTFH01001388v1_decoy chrUn_JTFH01001389v1_decoy chrUn_JTFH01001390v1_decoy chrUn_JTFH01001391v1_decoy chrUn_JTFH01001392v1_decoy chrUn_JTFH01001393v1_decoy chrUn_JTFH01001394v1_decoy chrUn_JTFH01001395v1_decoy chrUn_JTFH01001396v1_decoy chrUn_JTFH01001397v1_decoy chrUn_JTFH01001398v1_decoy chrUn_JTFH01001399v1_decoy chrUn_JTFH01001400v1_decoy chrUn_JTFH01001401v1_decoy chrUn_JTFH01001402v1_decoy chrUn_JTFH01001403v1_decoy chrUn_JTFH01001404v1_decoy chrUn_JTFH01001405v1_decoy chrUn_JTFH01001406v1_decoy chrUn_JTFH01001407v1_decoy chrUn_JTFH01001408v1_decoy chrUn_JTFH01001409v1_decoy chrUn_JTFH01001410v1_decoy chrUn_JTFH01001411v1_decoy chrUn_JTFH01001412v1_decoy chrUn_JTFH01001413v1_decoy chrUn_JTFH01001414v1_decoy chrUn_JTFH01001415v1_decoy chrUn_JTFH01001416v1_decoy chrUn_JTFH01001417v1_decoy chrUn_JTFH01001418v1_decoy chrUn_JTFH01001419v1_decoy chrUn_JTFH01001420v1_decoy chrUn_JTFH01001421v1_decoy chrUn_JTFH01001422v1_decoy chrUn_JTFH01001423v1_decoy chrUn_JTFH01001424v1_decoy chrUn_JTFH01001425v1_decoy chrUn_JTFH01001426v1_decoy chrUn_JTFH01001427v1_decoy chrUn_JTFH01001428v1_decoy chrUn_JTFH01001429v1_decoy chrUn_JTFH01001430v1_decoy chrUn_JTFH01001431v1_decoy chrUn_JTFH01001432v1_decoy chrUn_JTFH01001433v1_decoy chrUn_JTFH01001434v1_decoy chrUn_JTFH01001435v1_decoy chrUn_JTFH01001436v1_decoy chrUn_JTFH01001437v1_decoy chrUn_JTFH01001438v1_decoy chrUn_JTFH01001439v1_decoy chrUn_JTFH01001440v1_decoy chrUn_JTFH01001441v1_decoy chrUn_JTFH01001442v1_decoy chrUn_JTFH01001443v1_decoy chrUn_JTFH01001444v1_decoy chrUn_JTFH01001445v1_decoy chrUn_JTFH01001446v1_decoy chrUn_JTFH01001447v1_decoy chrUn_JTFH01001448v1_decoy chrUn_JTFH01001449v1_decoy chrUn_JTFH01001450v1_decoy chrUn_JTFH01001451v1_decoy chrUn_JTFH01001452v1_decoy chrUn_JTFH01001453v1_decoy chrUn_JTFH01001454v1_decoy chrUn_JTFH01001455v1_decoy chrUn_JTFH01001456v1_decoy chrUn_JTFH01001457v1_decoy chrUn_JTFH01001458v1_decoy chrUn_JTFH01001459v1_decoy chrUn_JTFH01001460v1_decoy chrUn_JTFH01001461v1_decoy chrUn_JTFH01001462v1_decoy chrUn_JTFH01001463v1_decoy chrUn_JTFH01001464v1_decoy chrUn_JTFH01001465v1_decoy chrUn_JTFH01001466v1_decoy chrUn_JTFH01001467v1_decoy chrUn_JTFH01001468v1_decoy chrUn_JTFH01001469v1_decoy chrUn_JTFH01001470v1_decoy chrUn_JTFH01001471v1_decoy chrUn_JTFH01001472v1_decoy chrUn_JTFH01001473v1_decoy chrUn_JTFH01001474v1_decoy chrUn_JTFH01001475v1_decoy chrUn_JTFH01001476v1_decoy chrUn_JTFH01001477v1_decoy chrUn_JTFH01001478v1_decoy chrUn_JTFH01001479v1_decoy chrUn_JTFH01001480v1_decoy chrUn_JTFH01001481v1_decoy chrUn_JTFH01001482v1_decoy chrUn_JTFH01001483v1_decoy chrUn_JTFH01001484v1_decoy chrUn_JTFH01001485v1_decoy chrUn_JTFH01001486v1_decoy chrUn_JTFH01001487v1_decoy chrUn_JTFH01001488v1_decoy chrUn_JTFH01001489v1_decoy chrUn_JTFH01001490v1_decoy chrUn_JTFH01001491v1_decoy chrUn_JTFH01001492v1_decoy chrUn_JTFH01001493v1_decoy chrUn_JTFH01001494v1_decoy chrUn_JTFH01001495v1_decoy chrUn_JTFH01001496v1_decoy chrUn_JTFH01001497v1_decoy chrUn_JTFH01001498v1_decoy chrUn_JTFH01001499v1_decoy chrUn_JTFH01001500v1_decoy chrUn_JTFH01001501v1_decoy chrUn_JTFH01001502v1_decoy chrUn_JTFH01001503v1_decoy chrUn_JTFH01001504v1_decoy chrUn_JTFH01001505v1_decoy chrUn_JTFH01001506v1_decoy chrUn_JTFH01001507v1_decoy chrUn_JTFH01001508v1_decoy chrUn_JTFH01001509v1_decoy chrUn_JTFH01001510v1_decoy chrUn_JTFH01001511v1_decoy chrUn_JTFH01001512v1_decoy chrUn_JTFH01001513v1_decoy chrUn_JTFH01001514v1_decoy chrUn_JTFH01001515v1_decoy chrUn_JTFH01001516v1_decoy chrUn_JTFH01001517v1_decoy chrUn_JTFH01001518v1_decoy chrUn_JTFH01001519v1_decoy chrUn_JTFH01001520v1_decoy chrUn_JTFH01001521v1_decoy chrUn_JTFH01001522v1_decoy chrUn_JTFH01001523v1_decoy chrUn_JTFH01001524v1_decoy chrUn_JTFH01001525v1_decoy chrUn_JTFH01001526v1_decoy chrUn_JTFH01001527v1_decoy chrUn_JTFH01001528v1_decoy chrUn_JTFH01001529v1_decoy chrUn_JTFH01001530v1_decoy chrUn_JTFH01001531v1_decoy chrUn_JTFH01001532v1_decoy chrUn_JTFH01001533v1_decoy chrUn_JTFH01001534v1_decoy chrUn_JTFH01001535v1_decoy chrUn_JTFH01001536v1_decoy chrUn_JTFH01001537v1_decoy chrUn_JTFH01001538v1_decoy chrUn_JTFH01001539v1_decoy chrUn_JTFH01001540v1_decoy chrUn_JTFH01001541v1_decoy chrUn_JTFH01001542v1_decoy chrUn_JTFH01001543v1_decoy chrUn_JTFH01001544v1_decoy chrUn_JTFH01001545v1_decoy chrUn_JTFH01001546v1_decoy chrUn_JTFH01001547v1_decoy chrUn_JTFH01001548v1_decoy chrUn_JTFH01001549v1_decoy chrUn_JTFH01001550v1_decoy chrUn_JTFH01001551v1_decoy chrUn_JTFH01001552v1_decoy chrUn_JTFH01001553v1_decoy chrUn_JTFH01001554v1_decoy chrUn_JTFH01001555v1_decoy chrUn_JTFH01001556v1_decoy chrUn_JTFH01001557v1_decoy chrUn_JTFH01001558v1_decoy chrUn_JTFH01001559v1_decoy chrUn_JTFH01001560v1_decoy chrUn_JTFH01001561v1_decoy chrUn_JTFH01001562v1_decoy chrUn_JTFH01001563v1_decoy chrUn_JTFH01001564v1_decoy chrUn_JTFH01001565v1_decoy chrUn_JTFH01001566v1_decoy chrUn_JTFH01001567v1_decoy chrUn_JTFH01001568v1_decoy chrUn_JTFH01001569v1_decoy chrUn_JTFH01001570v1_decoy chrUn_JTFH01001571v1_decoy chrUn_JTFH01001572v1_decoy chrUn_JTFH01001573v1_decoy chrUn_JTFH01001574v1_decoy chrUn_JTFH01001575v1_decoy chrUn_JTFH01001576v1_decoy chrUn_JTFH01001577v1_decoy chrUn_JTFH01001578v1_decoy chrUn_JTFH01001579v1_decoy chrUn_JTFH01001580v1_decoy chrUn_JTFH01001581v1_decoy chrUn_JTFH01001582v1_decoy chrUn_JTFH01001583v1_decoy chrUn_JTFH01001584v1_decoy chrUn_JTFH01001585v1_decoy chrUn_JTFH01001586v1_decoy chrUn_JTFH01001587v1_decoy chrUn_JTFH01001588v1_decoy chrUn_JTFH01001589v1_decoy chrUn_JTFH01001590v1_decoy chrUn_JTFH01001591v1_decoy chrUn_JTFH01001592v1_decoy chrUn_JTFH01001593v1_decoy chrUn_JTFH01001594v1_decoy chrUn_JTFH01001595v1_decoy chrUn_JTFH01001596v1_decoy chrUn_JTFH01001597v1_decoy chrUn_JTFH01001598v1_decoy chrUn_JTFH01001599v1_decoy chrUn_JTFH01001600v1_decoy chrUn_JTFH01001601v1_decoy chrUn_JTFH01001602v1_decoy chrUn_JTFH01001603v1_decoy chrUn_JTFH01001604v1_decoy chrUn_JTFH01001605v1_decoy chrUn_JTFH01001606v1_decoy chrUn_JTFH01001607v1_decoy chrUn_JTFH01001608v1_decoy chrUn_JTFH01001609v1_decoy chrUn_JTFH01001610v1_decoy chrUn_JTFH01001611v1_decoy chrUn_JTFH01001612v1_decoy chrUn_JTFH01001613v1_decoy chrUn_JTFH01001614v1_decoy chrUn_JTFH01001615v1_decoy chrUn_JTFH01001616v1_decoy chrUn_JTFH01001617v1_decoy chrUn_JTFH01001618v1_decoy chrUn_JTFH01001619v1_decoy chrUn_JTFH01001620v1_decoy chrUn_JTFH01001621v1_decoy chrUn_JTFH01001622v1_decoy chrUn_JTFH01001623v1_decoy chrUn_JTFH01001624v1_decoy chrUn_JTFH01001625v1_decoy chrUn_JTFH01001626v1_decoy chrUn_JTFH01001627v1_decoy chrUn_JTFH01001628v1_decoy chrUn_JTFH01001629v1_decoy chrUn_JTFH01001630v1_decoy chrUn_JTFH01001631v1_decoy chrUn_JTFH01001632v1_decoy chrUn_JTFH01001633v1_decoy chrUn_JTFH01001634v1_decoy chrUn_JTFH01001635v1_decoy chrUn_JTFH01001636v1_decoy chrUn_JTFH01001637v1_decoy chrUn_JTFH01001638v1_decoy chrUn_JTFH01001639v1_decoy chrUn_JTFH01001640v1_decoy chrUn_JTFH01001641v1_decoy chrUn_JTFH01001642v1_decoy chrUn_JTFH01001643v1_decoy chrUn_JTFH01001644v1_decoy chrUn_JTFH01001645v1_decoy chrUn_JTFH01001646v1_decoy chrUn_JTFH01001647v1_decoy chrUn_JTFH01001648v1_decoy chrUn_JTFH01001649v1_decoy chrUn_JTFH01001650v1_decoy chrUn_JTFH01001651v1_decoy chrUn_JTFH01001652v1_decoy chrUn_JTFH01001653v1_decoy chrUn_JTFH01001654v1_decoy chrUn_JTFH01001655v1_decoy chrUn_JTFH01001656v1_decoy chrUn_JTFH01001657v1_decoy chrUn_JTFH01001658v1_decoy chrUn_JTFH01001659v1_decoy chrUn_JTFH01001660v1_decoy chrUn_JTFH01001661v1_decoy chrUn_JTFH01001662v1_decoy chrUn_JTFH01001663v1_decoy chrUn_JTFH01001664v1_decoy chrUn_JTFH01001665v1_decoy chrUn_JTFH01001666v1_decoy chrUn_JTFH01001667v1_decoy chrUn_JTFH01001668v1_decoy chrUn_JTFH01001669v1_decoy chrUn_JTFH01001670v1_decoy chrUn_JTFH01001671v1_decoy chrUn_JTFH01001672v1_decoy chrUn_JTFH01001673v1_decoy chrUn_JTFH01001674v1_decoy chrUn_JTFH01001675v1_decoy chrUn_JTFH01001676v1_decoy chrUn_JTFH01001677v1_decoy chrUn_JTFH01001678v1_decoy chrUn_JTFH01001679v1_decoy chrUn_JTFH01001680v1_decoy chrUn_JTFH01001681v1_decoy chrUn_JTFH01001682v1_decoy chrUn_JTFH01001683v1_decoy chrUn_JTFH01001684v1_decoy chrUn_JTFH01001685v1_decoy chrUn_JTFH01001686v1_decoy chrUn_JTFH01001687v1_decoy chrUn_JTFH01001688v1_decoy chrUn_JTFH01001689v1_decoy chrUn_JTFH01001690v1_decoy chrUn_JTFH01001691v1_decoy chrUn_JTFH01001692v1_decoy chrUn_JTFH01001693v1_decoy chrUn_JTFH01001694v1_decoy chrUn_JTFH01001695v1_decoy chrUn_JTFH01001696v1_decoy chrUn_JTFH01001697v1_decoy chrUn_JTFH01001698v1_decoy chrUn_JTFH01001699v1_decoy chrUn_JTFH01001700v1_decoy chrUn_JTFH01001701v1_decoy chrUn_JTFH01001702v1_decoy chrUn_JTFH01001703v1_decoy chrUn_JTFH01001704v1_decoy chrUn_JTFH01001705v1_decoy chrUn_JTFH01001706v1_decoy chrUn_JTFH01001707v1_decoy chrUn_JTFH01001708v1_decoy chrUn_JTFH01001709v1_decoy chrUn_JTFH01001710v1_decoy chrUn_JTFH01001711v1_decoy chrUn_JTFH01001712v1_decoy chrUn_JTFH01001713v1_decoy chrUn_JTFH01001714v1_decoy chrUn_JTFH01001715v1_decoy chrUn_JTFH01001716v1_decoy chrUn_JTFH01001717v1_decoy chrUn_JTFH01001718v1_decoy chrUn_JTFH01001719v1_decoy chrUn_JTFH01001720v1_decoy chrUn_JTFH01001721v1_decoy chrUn_JTFH01001722v1_decoy chrUn_JTFH01001723v1_decoy chrUn_JTFH01001724v1_decoy chrUn_JTFH01001725v1_decoy chrUn_JTFH01001726v1_decoy chrUn_JTFH01001727v1_decoy chrUn_JTFH01001728v1_decoy chrUn_JTFH01001729v1_decoy chrUn_JTFH01001730v1_decoy chrUn_JTFH01001731v1_decoy chrUn_JTFH01001732v1_decoy chrUn_JTFH01001733v1_decoy chrUn_JTFH01001734v1_decoy chrUn_JTFH01001735v1_decoy chrUn_JTFH01001736v1_decoy chrUn_JTFH01001737v1_decoy chrUn_JTFH01001738v1_decoy chrUn_JTFH01001739v1_decoy chrUn_JTFH01001740v1_decoy chrUn_JTFH01001741v1_decoy chrUn_JTFH01001742v1_decoy chrUn_JTFH01001743v1_decoy chrUn_JTFH01001744v1_decoy chrUn_JTFH01001745v1_decoy chrUn_JTFH01001746v1_decoy chrUn_JTFH01001747v1_decoy chrUn_JTFH01001748v1_decoy chrUn_JTFH01001749v1_decoy chrUn_JTFH01001750v1_decoy chrUn_JTFH01001751v1_decoy chrUn_JTFH01001752v1_decoy chrUn_JTFH01001753v1_decoy chrUn_JTFH01001754v1_decoy chrUn_JTFH01001755v1_decoy chrUn_JTFH01001756v1_decoy chrUn_JTFH01001757v1_decoy chrUn_JTFH01001758v1_decoy chrUn_JTFH01001759v1_decoy chrUn_JTFH01001760v1_decoy chrUn_JTFH01001761v1_decoy chrUn_JTFH01001762v1_decoy chrUn_JTFH01001763v1_decoy chrUn_JTFH01001764v1_decoy chrUn_JTFH01001765v1_decoy chrUn_JTFH01001766v1_decoy chrUn_JTFH01001767v1_decoy chrUn_JTFH01001768v1_decoy chrUn_JTFH01001769v1_decoy chrUn_JTFH01001770v1_decoy chrUn_JTFH01001771v1_decoy chrUn_JTFH01001772v1_decoy chrUn_JTFH01001773v1_decoy chrUn_JTFH01001774v1_decoy chrUn_JTFH01001775v1_decoy chrUn_JTFH01001776v1_decoy chrUn_JTFH01001777v1_decoy chrUn_JTFH01001778v1_decoy chrUn_JTFH01001779v1_decoy chrUn_JTFH01001780v1_decoy chrUn_JTFH01001781v1_decoy chrUn_JTFH01001782v1_decoy chrUn_JTFH01001783v1_decoy chrUn_JTFH01001784v1_decoy chrUn_JTFH01001785v1_decoy chrUn_JTFH01001786v1_decoy chrUn_JTFH01001787v1_decoy chrUn_JTFH01001788v1_decoy chrUn_JTFH01001789v1_decoy chrUn_JTFH01001790v1_decoy chrUn_JTFH01001791v1_decoy chrUn_JTFH01001792v1_decoy chrUn_JTFH01001793v1_decoy chrUn_JTFH01001794v1_decoy chrUn_JTFH01001795v1_decoy chrUn_JTFH01001796v1_decoy chrUn_JTFH01001797v1_decoy chrUn_JTFH01001798v1_decoy chrUn_JTFH01001799v1_decoy chrUn_JTFH01001800v1_decoy chrUn_JTFH01001801v1_decoy chrUn_JTFH01001802v1_decoy chrUn_JTFH01001803v1_decoy chrUn_JTFH01001804v1_decoy chrUn_JTFH01001805v1_decoy chrUn_JTFH01001806v1_decoy chrUn_JTFH01001807v1_decoy chrUn_JTFH01001808v1_decoy chrUn_JTFH01001809v1_decoy chrUn_JTFH01001810v1_decoy chrUn_JTFH01001811v1_decoy chrUn_JTFH01001812v1_decoy chrUn_JTFH01001813v1_decoy chrUn_JTFH01001814v1_decoy chrUn_JTFH01001815v1_decoy chrUn_JTFH01001816v1_decoy chrUn_JTFH01001817v1_decoy chrUn_JTFH01001818v1_decoy chrUn_JTFH01001819v1_decoy chrUn_JTFH01001820v1_decoy chrUn_JTFH01001821v1_decoy chrUn_JTFH01001822v1_decoy chrUn_JTFH01001823v1_decoy chrUn_JTFH01001824v1_decoy chrUn_JTFH01001825v1_decoy chrUn_JTFH01001826v1_decoy chrUn_JTFH01001827v1_decoy chrUn_JTFH01001828v1_decoy chrUn_JTFH01001829v1_decoy chrUn_JTFH01001830v1_decoy chrUn_JTFH01001831v1_decoy chrUn_JTFH01001832v1_decoy chrUn_JTFH01001833v1_decoy chrUn_JTFH01001834v1_decoy chrUn_JTFH01001835v1_decoy chrUn_JTFH01001836v1_decoy chrUn_JTFH01001837v1_decoy chrUn_JTFH01001838v1_decoy chrUn_JTFH01001839v1_decoy chrUn_JTFH01001840v1_decoy chrUn_JTFH01001841v1_decoy chrUn_JTFH01001842v1_decoy chrUn_JTFH01001843v1_decoy chrUn_JTFH01001844v1_decoy chrUn_JTFH01001845v1_decoy chrUn_JTFH01001846v1_decoy chrUn_JTFH01001847v1_decoy chrUn_JTFH01001848v1_decoy chrUn_JTFH01001849v1_decoy chrUn_JTFH01001850v1_decoy chrUn_JTFH01001851v1_decoy chrUn_JTFH01001852v1_decoy chrUn_JTFH01001853v1_decoy chrUn_JTFH01001854v1_decoy chrUn_JTFH01001855v1_decoy chrUn_JTFH01001856v1_decoy chrUn_JTFH01001857v1_decoy chrUn_JTFH01001858v1_decoy chrUn_JTFH01001859v1_decoy chrUn_JTFH01001860v1_decoy chrUn_JTFH01001861v1_decoy chrUn_JTFH01001862v1_decoy chrUn_JTFH01001863v1_decoy chrUn_JTFH01001864v1_decoy chrUn_JTFH01001865v1_decoy chrUn_JTFH01001866v1_decoy chrUn_JTFH01001867v1_decoy chrUn_JTFH01001868v1_decoy chrUn_JTFH01001869v1_decoy chrUn_JTFH01001870v1_decoy chrUn_JTFH01001871v1_decoy chrUn_JTFH01001872v1_decoy chrUn_JTFH01001873v1_decoy chrUn_JTFH01001874v1_decoy chrUn_JTFH01001875v1_decoy chrUn_JTFH01001876v1_decoy chrUn_JTFH01001877v1_decoy chrUn_JTFH01001878v1_decoy chrUn_JTFH01001879v1_decoy chrUn_JTFH01001880v1_decoy chrUn_JTFH01001881v1_decoy chrUn_JTFH01001882v1_decoy chrUn_JTFH01001883v1_decoy chrUn_JTFH01001884v1_decoy chrUn_JTFH01001885v1_decoy chrUn_JTFH01001886v1_decoy chrUn_JTFH01001887v1_decoy chrUn_JTFH01001888v1_decoy chrUn_JTFH01001889v1_decoy chrUn_JTFH01001890v1_decoy chrUn_JTFH01001891v1_decoy chrUn_JTFH01001892v1_decoy chrUn_JTFH01001893v1_decoy chrUn_JTFH01001894v1_decoy chrUn_JTFH01001895v1_decoy chrUn_JTFH01001896v1_decoy chrUn_JTFH01001897v1_decoy chrUn_JTFH01001898v1_decoy chrUn_JTFH01001899v1_decoy chrUn_JTFH01001900v1_decoy chrUn_JTFH01001901v1_decoy chrUn_JTFH01001902v1_decoy chrUn_JTFH01001903v1_decoy chrUn_JTFH01001904v1_decoy chrUn_JTFH01001905v1_decoy chrUn_JTFH01001906v1_decoy chrUn_JTFH01001907v1_decoy chrUn_JTFH01001908v1_decoy chrUn_JTFH01001909v1_decoy chrUn_JTFH01001910v1_decoy chrUn_JTFH01001911v1_decoy chrUn_JTFH01001912v1_decoy chrUn_JTFH01001913v1_decoy chrUn_JTFH01001914v1_decoy chrUn_JTFH01001915v1_decoy chrUn_JTFH01001916v1_decoy chrUn_JTFH01001917v1_decoy chrUn_JTFH01001918v1_decoy chrUn_JTFH01001919v1_decoy chrUn_JTFH01001920v1_decoy chrUn_JTFH01001921v1_decoy chrUn_JTFH01001922v1_decoy chrUn_JTFH01001923v1_decoy chrUn_JTFH01001924v1_decoy chrUn_JTFH01001925v1_decoy chrUn_JTFH01001926v1_decoy chrUn_JTFH01001927v1_decoy chrUn_JTFH01001928v1_decoy chrUn_JTFH01001929v1_decoy chrUn_JTFH01001930v1_decoy chrUn_JTFH01001931v1_decoy chrUn_JTFH01001932v1_decoy chrUn_JTFH01001933v1_decoy chrUn_JTFH01001934v1_decoy chrUn_JTFH01001935v1_decoy chrUn_JTFH01001936v1_decoy chrUn_JTFH01001937v1_decoy chrUn_JTFH01001938v1_decoy chrUn_JTFH01001939v1_decoy chrUn_JTFH01001940v1_decoy chrUn_JTFH01001941v1_decoy chrUn_JTFH01001942v1_decoy chrUn_JTFH01001943v1_decoy chrUn_JTFH01001944v1_decoy chrUn_JTFH01001945v1_decoy chrUn_JTFH01001946v1_decoy chrUn_JTFH01001947v1_decoy chrUn_JTFH01001948v1_decoy chrUn_JTFH01001949v1_decoy chrUn_JTFH01001950v1_decoy chrUn_JTFH01001951v1_decoy chrUn_JTFH01001952v1_decoy chrUn_JTFH01001953v1_decoy chrUn_JTFH01001954v1_decoy chrUn_JTFH01001955v1_decoy chrUn_JTFH01001956v1_decoy chrUn_JTFH01001957v1_decoy chrUn_JTFH01001958v1_decoy chrUn_JTFH01001959v1_decoy chrUn_JTFH01001960v1_decoy chrUn_JTFH01001961v1_decoy chrUn_JTFH01001962v1_decoy chrUn_JTFH01001963v1_decoy chrUn_JTFH01001964v1_decoy chrUn_JTFH01001965v1_decoy chrUn_JTFH01001966v1_decoy chrUn_JTFH01001967v1_decoy chrUn_JTFH01001968v1_decoy chrUn_JTFH01001969v1_decoy chrUn_JTFH01001970v1_decoy chrUn_JTFH01001971v1_decoy chrUn_JTFH01001972v1_decoy chrUn_JTFH01001973v1_decoy chrUn_JTFH01001974v1_decoy chrUn_JTFH01001975v1_decoy chrUn_JTFH01001976v1_decoy chrUn_JTFH01001977v1_decoy chrUn_JTFH01001978v1_decoy chrUn_JTFH01001979v1_decoy chrUn_JTFH01001980v1_decoy chrUn_JTFH01001981v1_decoy chrUn_JTFH01001982v1_decoy chrUn_JTFH01001983v1_decoy chrUn_JTFH01001984v1_decoy chrUn_JTFH01001985v1_decoy chrUn_JTFH01001986v1_decoy chrUn_JTFH01001987v1_decoy chrUn_JTFH01001988v1_decoy chrUn_JTFH01001989v1_decoy chrUn_JTFH01001990v1_decoy chrUn_JTFH01001991v1_decoy chrUn_JTFH01001992v1_decoy chrUn_JTFH01001993v1_decoy chrUn_JTFH01001994v1_decoy chrUn_JTFH01001995v1_decoy chrUn_JTFH01001996v1_decoy chrUn_JTFH01001997v1_decoy chrUn_JTFH01001998v1_decoy; do

            
            # Create fastq file with reads mapping to any alternative haplotypes.
            samtools view -F 0x100 -F 0x400 -q 60 -F 0x200 s3://ihart-hg38/cram/$SAMPLE.final.cram $contig -b | bedtools bamtofastq -i - -fq kmers.${contig}.fastq
        done
    \rm *.crai
    

    # Count all kmers from alt haplotype fastqs.
    echo "Counting all kmers..."
    jellyfish count --canonical -m 100 -s 100M -L 2  -o kmers.jf kmers.*.fastq
    \rm kmers.*.fastq
    
    # Query specific "known" alternative haplotype kmers.
    echo "Querying specific known alt hap kmers..."
    cut -f1 $MY_HOME/alt_haplotypes/intermediate_files/ground_truth/sample_kmer_counts/known_alt_haplotype_kmers.txt | xargs jellyfish query kmers.jf | awk  '{print $2}' > kmer_counts.txt
    \rm kmers.jf
    
    echo "Splitting files..."
    split -l 100000 -d -a 3 --additional-suffix=.txt kmer_counts.txt kmer_counts. # Split into many 100K line files.

    \rm kmer_counts.txt
    
    done < $SCRATCH/tmp/tmp_kmers_from_unmapped_reads_$SLURM_ARRAY_TASK_ID.txt
    \rm $SCRATCH/tmp/tmp_kmers_from_unmapped_reads_$SLURM_ARRAY_TASK_ID.txt 
done


cut -f1 $MY_HOME/alt_haplotypes/intermediate_files/ground_truth/sample_kmer_counts/known_alt_haplotype_kmers.txt | xargs jellyfish query kmers.jf | awk  '{print $2}' > kmer_counts.txt

